/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.handler;

import java.security.AccessController;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.felix.eventadmin.impl.handler.EventHandlerTracker;
import org.apache.felix.eventadmin.impl.tasks.AsyncDeliverTasks;
import org.apache.felix.eventadmin.impl.tasks.DefaultThreadPool;
import org.apache.felix.eventadmin.impl.tasks.SyncDeliverTasks;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class EventAdminImpl
implements EventAdmin {
    private volatile EventHandlerTracker tracker;
    private final AsyncDeliverTasks m_postManager;
    private final SyncDeliverTasks m_sendManager;

    public EventAdminImpl(BundleContext bundleContext, DefaultThreadPool syncPool, DefaultThreadPool asyncPool, int timeout, String[] ignoreTimeout, boolean requireTopic) {
        this.checkNull(syncPool, "syncPool");
        this.checkNull(asyncPool, "asyncPool");
        this.tracker = new EventHandlerTracker(bundleContext);
        this.tracker.update(ignoreTimeout, requireTopic);
        this.tracker.open();
        this.m_sendManager = new SyncDeliverTasks(syncPool, timeout);
        this.m_postManager = new AsyncDeliverTasks(asyncPool, this.m_sendManager);
    }

    private EventHandlerTracker getTracker() {
        EventHandlerTracker localTracker = this.tracker;
        if (localTracker == null) {
            throw new IllegalStateException("The EventAdmin is stopped");
        }
        return localTracker;
    }

    @Override
    public void postEvent(Event event) {
        Event eventModded = this.prepare(event);
        this.m_postManager.execute(this.getTracker().getHandlers(eventModded), eventModded);
    }

    @Override
    public void sendEvent(Event event) {
        Event eventModded = this.prepare(event);
        this.m_sendManager.execute(this.getTracker().getHandlers(eventModded), eventModded, false);
    }

    public void stop() {
        this.tracker.close();
        this.tracker = null;
    }

    public void update(int timeout, String[] ignoreTimeout, boolean requireTopic) {
        this.tracker.close();
        this.tracker.update(ignoreTimeout, requireTopic);
        this.m_sendManager.update(timeout);
        this.tracker.open();
    }

    private Event prepare(Event event) {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null) {
            try {
                String[] names = event.getPropertyNames();
                HashMap<String, Object> map = new HashMap<String, Object>(names.length + 1);
                for (int i = 0; i < names.length; ++i) {
                    if ("event.topics".equals(names[i])) continue;
                    map.put(names[i], event.getProperty(names[i]));
                }
                map.put("event.subject", subject);
                event = new Event(event.getTopic(), map);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return event;
    }

    private void checkNull(Object object, String name) {
        if (null == object) {
            throw new NullPointerException(name + " may not be null");
        }
    }
}

