/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.commands;

import io.fabric8.agent.commands.ProfileWatcher;
import io.fabric8.agent.commands.support.ProfileVersionKey;
import io.fabric8.agent.commands.support.Utils;
import io.fabric8.maven.util.Parser;
import io.fabric8.utils.TablePrinter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(name="watch", scope="fabric", description="Watches and updates bundles", detailedDescription="classpath:watch.txt")
public class WatchAction
extends OsgiCommandSupport {
    @Argument(index=0, name="urls", description="The bundle URLs", required=false, multiValued=true)
    List<String> urls;
    @Option(name="-i", aliases={}, description="Watch interval", required=false, multiValued=false)
    private long interval;
    @Option(name="--start", description="Starts watching the selected bundles", required=false, multiValued=false)
    protected boolean start;
    @Option(name="--stop", description="Stops watching all bundles", required=false, multiValued=false)
    protected boolean stop;
    @Option(name="--remove", description="Removes bundles from the watch list", required=false, multiValued=false)
    protected boolean remove;
    @Option(name="--list", description="Displays the watch list", required=false, multiValued=false)
    protected boolean list;
    @Option(name="--no-upload", description="If specified then updated bundles are not uploaded to the Fabric's maven proxy repository", required=false, multiValued=false)
    protected boolean noUpload;
    private ProfileWatcher watcher;

    WatchAction(ProfileWatcher watcher) {
        this.watcher = watcher;
    }

    protected Object doExecute() throws Exception {
        if (this.start && this.stop) {
            System.err.println("Please use only one of --start and --stop options!");
            return null;
        }
        if (this.interval > 0L) {
            System.out.println("Setting watch interval to " + this.interval + " ms");
            this.watcher.setInterval(this.interval);
        }
        if (this.stop) {
            System.out.println("Stopping watch");
            this.watcher.stop();
        }
        this.watcher.setUpload(!this.noUpload);
        if (this.urls != null) {
            if (this.remove) {
                for (String url : this.urls) {
                    this.watcher.remove(url);
                }
            } else {
                for (String url : this.urls) {
                    this.watcher.add(url);
                }
            }
        }
        if (this.start) {
            System.out.println("Starting watch");
            this.watcher.start();
        }
        if (this.list) {
            TablePrinter printer = new TablePrinter();
            printer.columns("url", "profile", "version", "bundle");
            for (String url : this.watcher.getWatchURLs()) {
                Map<ProfileVersionKey, Map<String, Parser>> profileArtifacts = this.watcher.getProfileArtifacts();
                if (profileArtifacts.size() > 0) {
                    Set<Map.Entry<ProfileVersionKey, Map<String, Parser>>> entries = profileArtifacts.entrySet();
                    for (Map.Entry<ProfileVersionKey, Map<String, Parser>> entry : entries) {
                        ProfileVersionKey key = entry.getKey();
                        Map<String, Parser> artifactMap = entry.getValue();
                        Set<Map.Entry<String, Parser>> artifactMapEntries = artifactMap.entrySet();
                        for (Map.Entry<String, Parser> artifactMapEntry : artifactMapEntries) {
                            String location = artifactMapEntry.getKey();
                            Parser parser = artifactMapEntry.getValue();
                            if (!Utils.isSnapshot(parser) && !this.watcher.wildCardMatch(location, url)) continue;
                            printer.row(url, key.getProfileId(), key.getVersion(), location);
                        }
                    }
                    continue;
                }
                printer.row(url, "", "", "");
            }
            printer.print();
        } else {
            List<String> urls = this.watcher.getWatchURLs();
            if (urls != null && urls.size() > 0) {
                System.out.println("Watched URLs: ");
                for (String url : this.watcher.getWatchURLs()) {
                    System.out.println(url);
                }
            } else {
                System.out.println("No watched URLs");
            }
        }
        return null;
    }

    public ProfileWatcher getWatcher() {
        return this.watcher;
    }

    public void setWatcher(ProfileWatcher watcher) {
        this.watcher = watcher;
    }
}

