/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.core.jmx;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.api.AutoScaleStatus;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerProvider;
import io.fabric8.api.CreateContainerBasicMetadata;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.Ids;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.api.VersionSequence;
import io.fabric8.api.gravia.IllegalStateAssertion;
import io.fabric8.api.jmx.FabricManagerMBean;
import io.fabric8.api.jmx.FabricStatusDTO;
import io.fabric8.api.jmx.ServiceStatusDTO;
import io.fabric8.common.util.PublicPortMapper;
import io.fabric8.common.util.ShutdownTracker;
import io.fabric8.common.util.Strings;
import io.fabric8.core.jmx.BeanUtils;
import io.fabric8.service.FabricServiceImpl;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.codec.binary.Base64;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FabricManager
implements FabricManagerMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(FabricManager.class);
    private final ProfileService profileService;
    private final FabricServiceImpl fabricService;
    private ObjectName objectName;
    private static final Set<String> ID_AND_DEFAULT_VERSION = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("id", "defaultVersion")));

    public FabricManager(FabricServiceImpl fabricService) {
        this.profileService = fabricService.adapt(ProfileService.class);
        this.fabricService = fabricService;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this.objectName == null) {
            this.objectName = new ObjectName("io.fabric8:type=Fabric");
        }
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void registerMBeanServer(ShutdownTracker shutdownTracker, MBeanServer mbeanServer) {
        try {
            ObjectName name = this.getObjectName();
            if (!mbeanServer.isRegistered(name)) {
                StandardMBean mbean = new StandardMBean(this, FabricManagerMBean.class);
                mbeanServer.registerMBean(mbean, name);
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                ObjectName name = this.getObjectName();
                if (mbeanServer.isRegistered(name)) {
                    mbeanServer.unregisterMBean(name);
                }
            }
            catch (Exception e) {
                LOG.warn("An error occurred during mbean server registration: " + e, (Throwable)e);
            }
        }
    }

    public String getFabricEnvironment() {
        return this.fabricService.getEnvironment();
    }

    public List<String> getFields(String className) {
        try {
            return BeanUtils.getFields(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new FabricException("Failed to load class " + className, (Throwable)e);
        }
    }

    public ServiceStatusDTO getFabricServiceStatus() {
        ServiceStatusDTO rc = new ServiceStatusDTO();
        CuratorFramework curator = this.fabricService.adapt(CuratorFramework.class);
        try {
            rc.setClientValid(curator != null);
        }
        catch (Throwable t) {
            rc.setClientValid(false);
        }
        if (rc.isClientValid()) {
            try {
                rc.setClientConnected(curator.getZookeeperClient().isConnected());
                if (!rc.isClientConnected()) {
                    rc.setClientConnectionError(curator.getState().toString());
                }
            }
            catch (Throwable t) {
                rc.setClientConnected(false);
            }
            if (rc.isClientValid() && rc.isClientConnected()) {
                Container c = this.fabricService.getCurrentContainer();
                try {
                    rc.setManaged(c.isManaged());
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    rc.setProvisionComplete(c.isProvisioningComplete());
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return rc;
    }

    public Map<String, Object> fabricServiceStatus() {
        ServiceStatusDTO dto = this.getFabricServiceStatus();
        TreeMap<String, Object> answer = new TreeMap<String, Object>();
        answer.put("clientValid", dto.isClientValid());
        answer.put("clientConnected", dto.isClientConnected());
        answer.put("clientConnectionError", dto.getClientConnectionError());
        answer.put("provisionComplete", dto.isProvisionComplete());
        answer.put("managed", dto.isManaged());
        return answer;
    }

    public Map<String, String> createContainers(Map<String, Object> options) {
        String providerType;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating containers from JSON data: " + options);
        }
        if ((providerType = (String)options.get("providerType")) == null) {
            throw new RuntimeException("No providerType provided");
        }
        CreateContainerBasicOptions.Builder builder = null;
        ContainerProvider provider = this.fabricService.getValidProviders().get(providerType);
        if (provider == null) {
            throw new RuntimeException("Can't find valid provider of type: " + providerType);
        }
        Class clazz = provider.getOptionsType();
        try {
            builder = (CreateContainerBasicOptions.Builder)clazz.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to find builder type", (Throwable)e);
        }
        if (builder == null) {
            throw new RuntimeException("Unknown provider type : " + providerType);
        }
        ObjectMapper mapper = this.getObjectMapper();
        builder = (CreateContainerBasicOptions.Builder)mapper.convertValue(options, builder.getClass());
        builder.zookeeperPassword(this.fabricService.getZookeeperPassword());
        builder.zookeeperUrl(this.fabricService.getZookeeperUrl());
        Object profileObject = options.get("profiles");
        if (profileObject != null) {
            List profiles = (List)mapper.convertValue(profileObject, List.class);
            builder.profiles(profiles);
        }
        if (builder.getProxyUri() == null) {
            builder.proxyUri(this.fabricService.getMavenRepoURI());
        }
        CreateContainerBasicOptions build = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created container options: " + build + " with profiles " + build.getProfiles());
        }
        CreateContainerMetadata[] metadatas = this.fabricService.createContainers((CreateContainerOptions)build);
        LinkedHashMap<String, String> rc = new LinkedHashMap<String, String>();
        for (CreateContainerMetadata metadata : metadatas) {
            if (metadata.isSuccess()) continue;
            LOG.error("Failed to create container {}: ", (Object)metadata.getContainerName(), (Object)metadata.getFailure());
            rc.put(metadata.getContainerName(), metadata.getFailure().getMessage());
        }
        return rc;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        return mapper;
    }

    public void importProfiles(String versionId, List<String> profileZipUrls) {
        this.fabricService.adapt(ProfileRegistry.class).importProfiles(versionId, profileZipUrls);
    }

    @Deprecated
    public Map<String, Object> createProfile(String versionId, String profileId) {
        ProfileBuilder builder = ProfileBuilder.Factory.create((String)versionId, (String)profileId);
        Profile profile = this.profileService.createProfile(builder.getProfile());
        return this.getProfile(versionId, profile.getId());
    }

    public Map<String, Object> createProfile(String versionId, String profileId, List<String> parents) {
        ProfileBuilder builder = ProfileBuilder.Factory.create((String)versionId, (String)profileId).addParents(parents);
        Profile profile = this.profileService.createProfile(builder.getProfile());
        return this.getProfile(versionId, profile.getId());
    }

    public Map<String, Object> changeProfileParents(String versionId, String profileId, List<String> parents) {
        Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile).setParents(parents);
        profile = this.profileService.updateProfile(builder.getProfile());
        return this.getProfile(versionId, profile.getId());
    }

    public String profileWebAppURL(String webAppId, String profileId, String versionId) {
        return this.fabricService.profileWebAppURL(webAppId, profileId, versionId);
    }

    public String containerWebAppURL(String webAppId, String name) {
        return this.fabricService.containerWebAppURL(webAppId, name);
    }

    public Map<String, Object> createVersion(String sourceId, String targetId) {
        Version version = this.profileService.createVersionFrom(sourceId, targetId, null);
        return BeanUtils.convertVersionToMap(this.fabricService, version, BeanUtils.getFields(Version.class));
    }

    public Map<String, Object> createVersion(String version) {
        return this.createVersion(this.getLatestVersion().getId(), version);
    }

    public Map<String, Object> createVersion() {
        Version latestVersion = this.getLatestVersion();
        VersionSequence sequence = new VersionSequence(latestVersion.getId());
        return this.createVersion(sequence.next().getName());
    }

    private Version getLatestVersion() {
        List versions = this.profileService.getVersions();
        IllegalStateAssertion.assertFalse((Boolean)versions.isEmpty(), (String)"No versions available");
        String latestId = (String)versions.get(versions.size() - 1);
        return this.profileService.getRequiredVersion(latestId);
    }

    public void deleteProfile(String versionId, String profileId) {
        this.deleteProfile(versionId, profileId, true);
    }

    public void deleteProfile(String versionId, String profileId, boolean force) {
        this.profileService.deleteProfile((FabricService)this.fabricService, versionId, profileId, force);
    }

    public void deleteVersion(String versionId) {
        Container[] containers = this.fabricService.getContainers();
        StringBuilder sb = new StringBuilder();
        for (Container container : this.fabricService.getContainers()) {
            if (!versionId.equals(container.getVersionId())) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(container.getId());
        }
        IllegalStateAssertion.assertTrue((Boolean)(sb.length() == 0 ? 1 : 0), (String)("Version " + versionId + " is still used by the following containers: " + sb.toString()));
        this.profileService.deleteVersion(versionId);
    }

    public void destroyContainer(String containerId) {
        this.fabricService.destroyContainer(containerId);
    }

    public Map<String, Object> getContainer(String name) {
        return this.getContainer(name, BeanUtils.getFields(Container.class));
    }

    public Map<String, Object> getContainer(String name, List<String> fields) {
        Container c = this.fabricService.getContainer(name);
        return BeanUtils.convertContainerToMap(this.fabricService, c, fields);
    }

    public String getJvmOpts(String containerName) {
        String result = "";
        Container container = this.fabricService.getContainer(containerName);
        CreateContainerBasicMetadata metadata = (CreateContainerBasicMetadata)container.getMetadata();
        if (metadata == null) {
            return "Inapplicable";
        }
        switch (metadata.getCreateOptions().getProviderType()) {
            case "child": 
            case "ssh": {
                CreateContainerOptions createOptions = metadata.getCreateOptions();
                result = createOptions.getJvmOpts();
                break;
            }
            default: {
                result = "Inapplicable";
            }
        }
        return result;
    }

    public void setJvmOpts(String containerName, String jvmOpts) {
        Container container = this.fabricService.getContainer(containerName);
        this.changeCreateOptionsField(container.getId(), "jvmOpts", jvmOpts);
    }

    public List<String> getContainerProvisionList(String name) {
        Container container = this.fabricService.getContainer(name);
        if (container != null) {
            return new ArrayList<String>();
        }
        throw new IllegalStateException(String.format("Container %s not found.", name));
    }

    public void applyVersionToContainers(String version, List<String> containers) {
        Version v = this.profileService.getVersion(version);
        for (String container : containers) {
            this.fabricService.getContainer(container).setVersion(v);
        }
    }

    public void applyProfilesToContainers(String version, List<String> profiles, List<String> containers) {
        Profile[] p = this.stringsToProfiles(version, profiles);
        for (String container : containers) {
            this.fabricService.getContainer(container).setProfiles(p);
        }
    }

    public void addProfilesToContainer(String container, List<String> profiles) {
        Container cont = this.fabricService.getContainer(container);
        cont.addProfiles(this.stringsToProfiles(cont.getVersion(), profiles));
    }

    public void removeProfilesFromContainer(String container, List<String> profileIds) {
        Container cont = this.fabricService.getContainer(container);
        cont.removeProfiles(profileIds.toArray(new String[profileIds.size()]));
    }

    public List<Map<String, Object>> containers() {
        return this.containers(BeanUtils.getFields(Container.class));
    }

    public List<Map<String, Object>> containers(List<String> fields) {
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        for (Container c : this.fabricService.getContainers()) {
            answer.add(BeanUtils.convertContainerToMap(this.fabricService, c, fields));
        }
        return answer;
    }

    public List<Map<String, Object>> containers(List<String> fields, List<String> profileFields) {
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        for (Container c : this.fabricService.getContainers()) {
            Map<String, Object> map = BeanUtils.convertContainerToMap(this.fabricService, c, fields);
            ArrayList<Map<String, Object>> profiles = new ArrayList<Map<String, Object>>();
            for (Profile p : c.getProfiles()) {
                profiles.add(BeanUtils.convertProfileToMap(this.fabricService, p, profileFields));
            }
            map.put("profiles", profiles);
            answer.add(map);
        }
        return answer;
    }

    private CreateContainerMetadata<?> getContainerMetaData(String id) {
        Container container = this.fabricService.getContainer(id);
        return container.getMetadata();
    }

    public String containerMetadataType(String id) {
        CreateContainerMetadata<?> metadata = this.getContainerMetaData(id);
        if (metadata == null) {
            return null;
        }
        return metadata.getClass().getName();
    }

    public Map<String, String> getProfileProperties(String versionId, String profileId, String pid) {
        Profile profile;
        Map answer = null;
        Version version = this.profileService.getVersion(versionId);
        if (version != null && (profile = version.getRequiredProfile(profileId)) != null) {
            answer = profile.getConfiguration(pid);
        }
        return answer;
    }

    public Map<String, String> getOverlayProfileProperties(String versionId, String profileId, String pid) {
        Profile profile;
        Map answer = null;
        Version version = this.profileService.getVersion(versionId);
        if (version != null && (profile = version.getRequiredProfile(profileId)) != null) {
            Profile overlayProfile = this.profileService.getOverlayProfile(profile);
            answer = overlayProfile.getConfiguration(pid);
        }
        return answer;
    }

    public boolean setProfileProperties(String versionId, String profileId, String pid, Map<String, String> properties) {
        boolean answer = false;
        Version version = this.profileService.getVersion(versionId);
        if (version != null) {
            Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
            ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
            builder.addConfiguration(pid, properties);
            this.profileService.updateProfile(builder.getProfile());
            answer = true;
        }
        return answer;
    }

    public String getProfileProperty(String versionId, String profileId, String pid, String propertyName) {
        String answer = null;
        Map<String, String> properties = this.getProfileProperties(versionId, profileId, pid);
        if (properties != null) {
            answer = properties.get(propertyName);
        }
        return answer;
    }

    public String setProfileProperty(String versionId, String profileId, String pid, String propertyName, String value) {
        Map<String, String> properties = this.getProfileProperties(versionId, profileId, pid);
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        String answer = properties.put(propertyName, value);
        this.setProfileProperties(versionId, profileId, pid, properties);
        return answer;
    }

    public void setProfileAttribute(String versionId, String profileId, String attributeId, String value) {
        Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        builder.addAttribute(attributeId, value);
        this.profileService.updateProfile(builder.getProfile());
    }

    public void setProfileSystemProperties(String versionId, String profileId, Map<String, String> systemProperties) {
        Version version = this.profileService.getVersion(versionId);
        Profile profile = version.getRequiredProfile(profileId);
        Map<String, String> profileProperties = this.getProfileProperties(versionId, profileId, "io.fabric8.agent");
        if (profileProperties == null) {
            profileProperties = new HashMap<String, String>();
        }
        Iterator<Map.Entry<String, String>> iterator = profileProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!entry.getKey().startsWith("system.")) continue;
            iterator.remove();
        }
        for (String k : systemProperties.keySet()) {
            profileProperties.put("system." + k, systemProperties.get(k));
        }
        this.setProfileProperties(versionId, profileId, "io.fabric8.agent", profileProperties);
    }

    public String containerCreateOptionsType(String id) {
        CreateContainerMetadata<?> metadata = this.getContainerMetaData(id);
        if (metadata == null) {
            return null;
        }
        CreateContainerOptions options = metadata.getCreateOptions();
        if (options == null) {
            return null;
        }
        return options.getClass().getName();
    }

    public void changeCreateOptionsField(String containerId, String field, Object value) {
        CreateContainerMetadata<?> metadata = this.getContainerMetaData(containerId);
        if (metadata == null) {
            return;
        }
        CreateContainerOptions options = metadata.getCreateOptions();
        if (options == null) {
            return;
        }
        ObjectMapper mapper = this.getObjectMapper();
        JsonNode optionsJson = (JsonNode)mapper.convertValue((Object)options, JsonNode.class);
        JsonNode valueJson = (JsonNode)mapper.convertValue(value, JsonNode.class);
        ((ObjectNode)optionsJson).put(field, valueJson);
        Object builder = null;
        try {
            builder = options.getClass().getMethod("builder", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to get builder when setting " + field + " on container " + containerId, (Throwable)e);
            throw new RuntimeException("Failed to get builder when setting " + field + " on container " + containerId, e);
        }
        builder = mapper.convertValue((Object)optionsJson, builder.getClass());
        CreateContainerOptions newOptions = null;
        try {
            newOptions = (CreateContainerOptions)builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to build CreatecontainerOptions when setting " + field + " on container " + containerId, (Throwable)e);
            throw new RuntimeException("Failed to build CreatecontainerOptions when setting " + field + " on container " + containerId, e);
        }
        metadata.setCreateOptions(newOptions);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Create container metadata: " + metadata);
        }
        this.fabricService.adapt(DataStore.class).setContainerMetadata(metadata);
    }

    public String[] containerIds() {
        ArrayList<String> answer = new ArrayList<String>();
        for (Container container : this.fabricService.getContainers()) {
            answer.add(container.getId());
        }
        return answer.toArray(new String[answer.size()]);
    }

    public List<String> containerIdsForProfile(String versionId, String profileId) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id");
        return BeanUtils.collapseToList(this.containersForProfile(versionId, profileId, fields), "id");
    }

    public List<List<String>> containerIdsForProfiles(String versionId, List<String> profileIds, boolean checkParents) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id");
        ArrayList<List<String>> result = new ArrayList<List<String>>(profileIds.size());
        for (String profileId : profileIds) {
            try {
                result.add(BeanUtils.collapseToList(this.containersForProfile(versionId, profileId, fields, checkParents), "id"));
            }
            catch (IllegalStateException notAValidProfile) {
                result.add(Collections.emptyList());
            }
        }
        return result;
    }

    public List<Map<String, Object>> containersForProfile(String versionId, String profileId) {
        return this.containersForProfile(versionId, profileId, BeanUtils.getFields(Container.class));
    }

    public List<Map<String, Object>> containersForProfile(String versionId, String profileId, List<String> fields) {
        return this.containersForProfile(versionId, profileId, fields, false);
    }

    public List<Map<String, Object>> containersForProfile(String versionId, String profileId, List<String> fields, boolean checkParents) {
        Version version = this.profileService.getVersion(versionId);
        Profile profile = version != null ? version.getRequiredProfile(profileId) : null;
        LinkedHashSet<Map<String, Object>> answer = new LinkedHashSet<Map<String, Object>>();
        if (profile != null) {
            for (Container c : this.fabricService.getContainers()) {
                block1: for (Profile p : c.getProfiles()) {
                    if (p.equals(profile)) {
                        answer.add(BeanUtils.convertContainerToMap(this.fabricService, c, fields));
                        continue;
                    }
                    if (!checkParents) continue;
                    HashSet<Profile> profileIDs = new HashSet<Profile>();
                    this.getAllParentProfiles(version, p, profileIDs);
                    for (Profile pprofile : profileIDs) {
                        if (!pprofile.equals(profile)) continue;
                        answer.add(BeanUtils.convertContainerToMap(this.fabricService, c, fields));
                        continue block1;
                    }
                }
            }
        }
        return new ArrayList<Map<String, Object>>(answer);
    }

    private void getAllParentProfiles(Version version, Profile profile, Set<Profile> parentProfiles) {
        for (String parentProfileId : profile.getParentIds()) {
            Profile pprofile = version.getProfile(parentProfileId);
            if (pprofile == null) continue;
            parentProfiles.add(pprofile);
            this.getAllParentProfiles(version, pprofile, parentProfiles);
        }
    }

    public List<String> containerIdsForVersion(String versionId) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id");
        return BeanUtils.collapseToList(this.containersForVersion(versionId, fields), "id");
    }

    public List<Map<String, Object>> containersForVersion(String versionId) {
        return this.containersForVersion(versionId, BeanUtils.getFields(Container.class));
    }

    public List<Map<String, Object>> containersForVersion(String versionId, List<String> fields) {
        Version version = this.profileService.getVersion(versionId);
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        if (version != null) {
            for (Container c : this.fabricService.getContainers()) {
                if (!c.getVersion().equals(version)) continue;
                answer.add(BeanUtils.convertContainerToMap(this.fabricService, c, fields));
            }
        }
        return answer;
    }

    public void setContainerProperty(String containerId, String property, Object value) {
        Container container = this.fabricService.getContainer(containerId);
        BeanUtils.setValue(container, property, value);
    }

    protected Profile[] stringsToProfiles(String version, List<String> names) {
        return this.stringsToProfiles(this.profileService.getVersion(version), names);
    }

    protected Profile[] stringsToProfiles(Version version, List<String> names) {
        List allProfiles = version.getProfiles();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        if (names == null) {
            return new Profile[0];
        }
        for (String name : names) {
            Profile profile = null;
            for (Profile p : allProfiles) {
                if (!name.equals(p.getId())) continue;
                profile = p;
                break;
            }
            if (profile == null) {
                throw new IllegalArgumentException("Profile " + name + " not found.");
            }
            profiles.add(profile);
        }
        return profiles.toArray(new Profile[profiles.size()]);
    }

    public Map<String, Object> currentContainer() {
        return BeanUtils.convertContainerToMap(this.fabricService, this.fabricService.getCurrentContainer(), BeanUtils.getFields(Container.class));
    }

    public String getCurrentContainerName() {
        return this.fabricService.getCurrentContainerName();
    }

    public int getPublicPortOnCurrentContainer(int localPort) {
        try {
            return PublicPortMapper.getPublicPort((int)localPort);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String getDefaultJvmOptions() {
        return this.fabricService.getDefaultJvmOptions();
    }

    public String getDefaultRepo() {
        return this.fabricService.getDefaultRepo();
    }

    public Map<String, Object> defaultVersion() {
        return BeanUtils.convertVersionToMap(this.fabricService, this.fabricService.getRequiredDefaultVersion(), BeanUtils.getFields(Version.class));
    }

    public String getDefaultVersion() {
        return this.fabricService.getDefaultVersionId();
    }

    public FabricStatusDTO fabricStatus() {
        return new FabricStatusDTO(this.fabricService.getFabricStatus());
    }

    public String fabricStatusAsJson() {
        FabricStatusDTO dto = this.fabricStatus();
        if (dto != null) {
            try {
                return this.getObjectMapper().writerWithDefaultPrettyPrinter().withType(FabricStatusDTO.class).writeValueAsString((Object)dto);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Error writing data as json", e);
            }
        }
        return null;
    }

    public String getMavenRepoUploadURI() {
        URI answer = this.fabricService.getMavenRepoUploadURI();
        return answer != null ? answer.toString() : null;
    }

    public String getMavenRepoURI() {
        URI answer = this.fabricService.getMavenRepoURI();
        return answer != null ? answer.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProfileFeatures(String versionId, String profileId) {
        Profile profile = this.profileService.getVersion(versionId).getRequiredProfile(profileId);
        Profile effectiveProfile = Profiles.getEffectiveProfile((FabricService)this.fabricService, (Profile)this.profileService.getOverlayProfile(profile));
        HashMap<String, Boolean> isParentFeature = new HashMap<String, Boolean>();
        for (String feature : profile.getFeatures()) {
            isParentFeature.put(feature, Boolean.FALSE);
        }
        for (String feature : effectiveProfile.getFeatures()) {
            if (isParentFeature.get(feature) != null) continue;
            isParentFeature.put(feature, Boolean.TRUE);
        }
        HashMap<String, Object> rc = new HashMap<String, Object>();
        ArrayList featureDefs = new ArrayList();
        for (Map.Entry featureEntry : isParentFeature.entrySet()) {
            HashMap<String, Object> featureDef = new HashMap<String, Object>();
            featureDef.put("id", featureEntry.getKey());
            featureDef.put("isParentFeature", featureEntry.getValue());
            featureDefs.add(featureDef);
        }
        rc.put("featureDefinitions", featureDefs);
        ArrayList repositoryDefs = new ArrayList();
        for (String repo : effectiveProfile.getRepositories()) {
            HashMap<String, String> repoDef = new HashMap<String, String>();
            repoDef.put("id", repo);
            Closeable closeable = null;
            try {
                int stat;
                URL url = new URL(repo);
                InputStream os = url.openStream();
                closeable = os;
                BufferedInputStream is = new BufferedInputStream(url.openStream());
                closeable = is;
                char[] buffer = new char[8192];
                StringBuilder data = new StringBuilder();
                InputStreamReader in = new InputStreamReader((InputStream)is, "UTF-8");
                closeable = in;
                while ((stat = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                    data.append(buffer, 0, stat);
                }
                repoDef.put("data", data.toString());
            }
            catch (Throwable t) {
                repoDef.put("error", t.getMessage());
            }
            finally {
                try {
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t) {}
            }
            repositoryDefs.add(repoDef);
        }
        rc.put("repositoryDefinitions", repositoryDefs);
        return rc;
    }

    public Map<String, Object> getProfile(String versionId, String profileId) {
        return this.getProfile(versionId, profileId, true);
    }

    public Map<String, Object> getProfile(String versionId, String profileId, boolean mandatory) {
        return this.doGetProfile(versionId, profileId, BeanUtils.getFields(Profile.class), mandatory);
    }

    public Map<String, Object> getProfile(String versionId, String profileId, List<String> fields) {
        return this.doGetProfile(versionId, profileId, fields, true);
    }

    Map<String, Object> doGetProfile(String versionId, String profileId, List<String> fields, boolean mandatory) {
        String restApi;
        Version version = this.profileService.getVersion(versionId);
        Profile profile = mandatory ? version.getRequiredProfile(profileId) : version.getProfile(profileId);
        if (profile == null) {
            return null;
        }
        Map<String, Object> answer = BeanUtils.convertProfileToMap(this.fabricService, profile, fields);
        String iconURLField = "iconURL";
        if (fields.contains(iconURLField) && !profile.isOverlay() && (restApi = this.restApiUrl()) != null && restApi.length() > 0) {
            try {
                URL url = new URL(restApi);
                restApi = url.getPath();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            String icon = this.getIconURL(version, versionId, profile, profileId, restApi);
            answer.put(iconURLField, icon);
        }
        return answer;
    }

    protected String getIconURL(Version version, String versionId, Profile profile, String profileId, String restApi) {
        List parentIds;
        String relativeIcon = profile.getIconRelativePath();
        String iconProfileId = profileId;
        if (FabricManager.isNullOrEmpty(relativeIcon) && (parentIds = profile.getParentIds()) != null && !parentIds.isEmpty()) {
            for (String parentId : parentIds) {
                String answer;
                Profile parentProfile;
                if (parentId == null || parentId.trim().equals("")) {
                    parentId = "default";
                }
                if (FabricManager.isNullOrEmpty(relativeIcon = (parentProfile = version.getRequiredProfile(parentId)).getIconRelativePath()) && !FabricManager.isNullOrEmpty(answer = this.getIconURL(version, versionId, parentProfile, parentId, restApi))) {
                    return answer;
                }
                if (FabricManager.isNullOrEmpty(relativeIcon)) continue;
                iconProfileId = parentId;
                break;
            }
        }
        String icon = null;
        if (!FabricManager.isNullOrEmpty(relativeIcon)) {
            icon = restApi + "/version/" + versionId + "/profile/" + iconProfileId + "/overlay/file/" + relativeIcon;
        }
        return icon;
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public List<Map<String, Object>> getProfiles(String versionId) {
        return this.getProfiles(versionId, BeanUtils.getFields(Profile.class));
    }

    public List<Map<String, Object>> getProfiles(String versionId, List<String> fields) {
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        for (Profile p : this.profileService.getVersion(versionId).getProfiles()) {
            answer.add(this.getProfile(versionId, p.getId(), fields));
        }
        return answer;
    }

    public List<String> getProfileIds(String version) {
        return Ids.getIds((List)this.profileService.getVersion(version).getProfiles());
    }

    public String getConfigurationFile(String versionId, String profileId, String fileName) {
        return Base64.encodeBase64String((byte[])((byte[])this.profileService.getVersion(versionId).getRequiredProfile(profileId).getFileConfigurations().get(fileName)));
    }

    public List<String> getConfigurationFileNames(String versionId, String profileId) {
        Version version = this.profileService.getVersion(versionId);
        Profile profile = version.getProfile(profileId);
        if (profile != null) {
            ArrayList fileNames = new ArrayList(profile.getConfigurationFileNames());
            return Collections.unmodifiableList(fileNames);
        }
        return Collections.emptyList();
    }

    public Map<String, String> currentContainerConfigurationFiles() {
        FabricServiceImpl service = this.fabricService;
        String containerName = this.getCurrentContainerName();
        Container container = service.getContainer(containerName);
        if (container != null) {
            Profile[] profiles = container.getProfiles();
            return Profiles.getConfigurationFileNameMap((Profile[])profiles);
        }
        return new HashMap<String, String>();
    }

    public Map<String, Object> getConfigurationFiles(String versionId, List<String> profileIds, String filename) {
        Pattern pattern = Pattern.compile(filename);
        TreeMap<String, Object> answer = new TreeMap<String, Object>();
        Version version = this.profileService.getVersion(versionId);
        for (String profileId : profileIds) {
            Profile profile = version.getRequiredProfile(profileId);
            if (profile == null) continue;
            TreeMap files = new TreeMap();
            Map configs = profile.getFileConfigurations();
            for (Map.Entry configEntry : configs.entrySet()) {
                if (!pattern.matcher((CharSequence)configEntry.getKey()).matches()) continue;
                files.put(configEntry.getKey(), Base64.encodeBase64String((byte[])((byte[])configEntry.getValue())));
            }
            answer.put(profileId, files);
        }
        return answer;
    }

    public void deleteConfigurationFile(String versionId, String profileId, String fileName) {
        Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        builder.deleteFileConfiguration(fileName);
        this.profileService.updateProfile(builder.getProfile());
    }

    public void deleteConfigurationFiles(String versionId, List<String> profileIds, List<String> fileNames) {
        if (profileIds.size() != fileNames.size()) {
            throw new FabricException("Lists of profile IDs and filenames should be the same size");
        }
        for (int i = 0; i < profileIds.size(); ++i) {
            String profileId = profileIds.get(i);
            String fileName = fileNames.get(i);
            Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
            ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
            builder.deleteFileConfiguration(fileName);
            this.profileService.updateProfile(builder.getProfile());
        }
    }

    public void setConfigurationFile(String versionId, String profileId, String fileName, String data) {
        Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        builder.addFileConfiguration(fileName, Base64.decodeBase64((String)data));
        this.profileService.updateProfile(builder.getProfile(), true);
    }

    public void setProfileBundles(String versionId, String profileId, List<String> bundles) {
        Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        builder.setBundles(bundles);
        this.profileService.updateProfile(builder.getProfile());
    }

    public void setProfileFeatures(String versionId, String profileId, List<String> features) {
        Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        builder.setFeatures(features);
        this.profileService.updateProfile(builder.getProfile());
    }

    public void setProfileRepositories(String versionId, String profileId, List<String> repositories) {
        Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        builder.setRepositories(repositories);
        this.profileService.updateProfile(builder.getProfile());
    }

    public void setProfileFabs(String versionId, String profileId, List<String> fabs) {
        Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        builder.setFabs(fabs);
        this.profileService.updateProfile(builder.getProfile());
    }

    public void setProfileOverrides(String versionId, String profileId, List<String> overrides) {
        Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        builder.setOverrides(overrides);
        this.profileService.updateProfile(builder.getProfile());
    }

    public void setProfileOptionals(String versionId, String profileId, List<String> optionals) {
        Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        builder.setOptionals(optionals);
        this.profileService.updateProfile(builder.getProfile());
    }

    public void setProfileTags(String versionId, String profileId, List<String> tags) {
        Profile profile = this.profileService.getRequiredProfile(versionId, profileId);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        builder.setTags(tags);
        this.profileService.updateProfile(builder.getProfile());
    }

    public boolean scaleProfile(String profile, int numberOfInstances) throws IOException {
        return this.fabricService.scaleProfile(profile, numberOfInstances);
    }

    public FabricRequirements requirements() {
        return this.fabricService.getRequirements();
    }

    public String requirementsAsJson() {
        FabricRequirements dto = this.requirements();
        try {
            return this.getObjectMapper().writerWithDefaultPrettyPrinter().withType(FabricRequirements.class).writeValueAsString((Object)dto);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error writing data as json", e);
        }
    }

    public AutoScaleStatus autoScaleStatus() {
        return this.fabricService.getAutoScaleStatus();
    }

    public String autoScaleStatusAsJson() {
        AutoScaleStatus dto = this.autoScaleStatus();
        if (dto != null) {
            try {
                return this.getObjectMapper().writerWithDefaultPrettyPrinter().withType(AutoScaleStatus.class).writeValueAsString((Object)dto);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Error writing data as json", e);
            }
        }
        return null;
    }

    public List<String> versionIds() {
        return this.profileService.getVersions();
    }

    public Map<String, Object> getVersion(String versionId) {
        return this.getVersion(versionId, BeanUtils.getFields(Version.class));
    }

    public Map<String, Object> getVersion(String versionId, List<String> fields) {
        return BeanUtils.convertVersionToMap(this.fabricService, this.profileService.getVersion(versionId), fields);
    }

    public List<Map<String, Object>> versions() {
        return this.versions(BeanUtils.getFields(Version.class));
    }

    public List<Map<String, Object>> versions(List<String> fields) {
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        if (ID_AND_DEFAULT_VERSION.equals(Collections.unmodifiableSet(new HashSet<String>(fields)))) {
            for (String version : this.profileService.getVersions()) {
                HashMap<String, Object> obj = new HashMap<String, Object>();
                obj.put("id", version);
                obj.put("defaultVersion", this.fabricService.getDefaultVersionId().equals(version));
                answer.add(obj);
            }
        } else {
            for (String versionId : this.profileService.getVersions()) {
                answer.add(this.getVersion(versionId, fields));
            }
        }
        return answer;
    }

    public void copyProfile(String versionId, String sourceId, String targetId, boolean force) {
        Version v = this.profileService.getVersion(versionId);
        if (v != null) {
            Profiles.copyProfile((FabricService)this.fabricService, (String)versionId, (String)sourceId, (String)targetId, (boolean)force);
        }
    }

    public void renameProfile(String versionId, String profileId, String newId, boolean force) {
        Version v = this.profileService.getVersion(versionId);
        if (v != null) {
            Profiles.renameProfile((FabricService)this.fabricService, (String)versionId, (String)profileId, (String)newId, (boolean)force);
        }
    }

    public void refreshProfile(String versionId, String profileId) {
        Profile profile;
        Version version = this.profileService.getVersion(versionId);
        if (version != null && (profile = version.getRequiredProfile(profileId)) != null) {
            Profiles.refreshProfile((FabricService)this.fabricService, (Profile)profile);
        }
    }

    public String getZookeeperInfo(String name) {
        return this.fabricService.getZookeeperInfo(name);
    }

    public String webConsoleUrl() {
        return this.fabricService.getWebConsoleUrl();
    }

    public String gitUrl() {
        return this.fabricService.getGitUrl();
    }

    public String getZookeeperUrl() {
        return this.fabricService.getZookeeperUrl();
    }

    public void registerProvider(ContainerProvider provider, Map<String, Object> properties) {
        this.fabricService.registerProvider(provider, properties);
    }

    public void registerProvider(String scheme, ContainerProvider provider) {
        this.fabricService.registerProvider(scheme, provider);
    }

    public void setDefaultJvmOptions(String jvmOptions) {
        this.fabricService.setDefaultJvmOptions(jvmOptions);
    }

    public void setDefaultRepo(String defaultRepo) {
        this.fabricService.setDefaultRepo(defaultRepo);
    }

    public void setDefaultVersion(String versionId) {
        this.fabricService.setDefaultVersionId(versionId);
    }

    public void requirements(FabricRequirements requirements) throws IOException {
        this.fabricService.setRequirements(requirements);
    }

    public void requirementsJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        Object value = mapper.reader(FabricRequirements.class).readValue(json);
        if (!(value instanceof FabricRequirements)) {
            throw new IOException("Failed to parse FabricRequirements from JSON. Got " + value + ". JSON: " + json);
        }
        this.requirements((FabricRequirements)value);
    }

    public void startContainer(String containerId) {
        this.fabricService.startContainer(containerId);
    }

    public List<Map<String, Object>> startContainers(List<String> containerIds) {
        ArrayList<Map<String, Object>> rc = new ArrayList<Map<String, Object>>();
        for (String containerId : containerIds) {
            LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
            status.put("id", containerId);
            try {
                this.startContainer(containerId);
                status.put("success", true);
            }
            catch (Throwable t) {
                status.put("error", t);
                status.put("errorMessage", t.getMessage());
            }
            rc.add(status);
        }
        return rc;
    }

    public void stopContainer(String containerId) {
        this.fabricService.stopContainer(containerId);
    }

    public List<Map<String, Object>> stopContainers(List<String> containerIds) {
        ArrayList<Map<String, Object>> rc = new ArrayList<Map<String, Object>>();
        for (String containerId : containerIds) {
            LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
            status.put("id", containerId);
            try {
                this.stopContainer(containerId);
                status.put("success", true);
            }
            catch (Throwable t) {
                status.put("error", t);
                status.put("errorMessage", t.getMessage());
            }
            rc.add(status);
        }
        return rc;
    }

    public Map<String, String> registeredProviders() {
        Map<String, ContainerProvider> providers = this.fabricService.getProviders();
        return this.toJsonMap(providers);
    }

    public Map<String, String> registeredValidProviders() {
        Map<String, ContainerProvider> providers = this.fabricService.getValidProviders();
        return this.toJsonMap(providers);
    }

    private Map<String, String> toJsonMap(Map<String, ContainerProvider> providers) {
        TreeMap<String, String> answer = new TreeMap<String, String>();
        for (Map.Entry<String, ContainerProvider> providerEntry : providers.entrySet()) {
            answer.put(providerEntry.getKey(), providerEntry.getValue().getOptionsType().getName());
        }
        return answer;
    }

    public void unregisterProvider(ContainerProvider provider, Map<String, Object> properties) {
        this.fabricService.unregisterProvider(provider, properties);
    }

    public void unregisterProvider(String scheme) {
        this.fabricService.unregisterProvider(scheme);
    }

    public void applyPatches(List<String> files, String sourceId, String targetId, String proxyUser, String proxyPassword) {
        ArrayList<File> patchFiles = new ArrayList<File>();
        for (String fileName : files) {
            File file = new File(fileName);
            if (file.exists()) {
                patchFiles.add(file);
                continue;
            }
            LOG.warn("Patch file does not exist, skipping: {}", (Object)fileName);
        }
        if (patchFiles.isEmpty()) {
            LOG.warn("No valid patches to apply");
            throw new FabricException("No valid patches to apply");
        }
        if (targetId == null || targetId.equals("")) {
            Version latestVersion = this.getLatestVersion();
            VersionSequence sequence = new VersionSequence(latestVersion.getId());
            targetId = sequence.next().getName();
        }
        Version targetVersion = this.profileService.createVersionFrom(sourceId, targetId, null);
        File currentPatchFile = null;
        try {
            Iterator i$ = patchFiles.iterator();
            while (i$.hasNext()) {
                File file;
                currentPatchFile = file = (File)i$.next();
                if (!file.isFile()) {
                    LOG.info("File is a directory, skipping: {}", (Object)file);
                    continue;
                }
                LOG.info("Applying patch file {}", (Object)file);
                this.fabricService.getPatchService().applyPatch(targetVersion, file.toURI().toURL(), proxyUser, proxyPassword);
                LOG.info("Successfully applied {}", (Object)file);
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed to apply patch file {}", currentPatchFile, (Object)t);
            this.profileService.deleteVersion(targetId);
            throw new FabricException("Failed to apply patch file " + currentPatchFile, t);
        }
        for (File file : patchFiles) {
            try {
                LOG.info("Deleting patch file {}", (Object)file);
                boolean deleted = file.delete();
                if (deleted) continue;
                LOG.warn("Failed to delete patch file {}", (Object)file);
            }
            catch (Throwable t) {
                LOG.warn("Failed to delete patch file {} due to {}", (Object)file, (Object)t);
            }
        }
    }

    public String getConfigurationValue(String versionId, String profileId, String pid, String key) {
        return this.fabricService.getConfigurationValue(versionId, profileId, pid, key);
    }

    public void setConfigurationValue(String versionId, String profileId, String pid, String key, String value) {
        this.fabricService.setConfigurationValue(versionId, profileId, pid, key, value);
    }

    public String mavenProxyDownloadUrl() {
        URI uri = this.fabricService.getMavenRepoURI();
        if (uri != null) {
            return uri.toASCIIString();
        }
        return null;
    }

    public String mavenProxyUploadUrl() {
        URI uri = this.fabricService.getMavenRepoUploadURI();
        if (uri != null) {
            return uri.toASCIIString();
        }
        return null;
    }

    public String restApiUrl() {
        return this.fabricService.getRestAPI();
    }

    public String clusterJson(String clusterPathSegment) throws Exception {
        String prefix = "/fabric/registry/clusters";
        String path = Strings.isEmpty((String)clusterPathSegment) ? prefix : (clusterPathSegment.startsWith("/") ? clusterPathSegment : prefix + "/" + clusterPathSegment);
        HashMap<String, Object> answer = new HashMap<String, Object>();
        CuratorFramework curator = this.fabricService.adapt(CuratorFramework.class);
        ObjectMapper mapper = new ObjectMapper();
        this.addChildrenToMap(answer, path, curator, mapper);
        return mapper.writeValueAsString(answer);
    }

    protected void addChildrenToMap(Map<String, Object> answer, String path, CuratorFramework curator, ObjectMapper mapper) throws Exception {
        HashSet<String> dontSubstituteKeys = new HashSet<String>(Arrays.asList("id", "container"));
        List children = ZooKeeperUtils.getChildrenSafe((CuratorFramework)curator, (String)path);
        for (String child : children) {
            String childPath = path + "/" + child;
            byte[] data = (byte[])curator.getData().forPath(childPath);
            if (data != null && data.length > 0) {
                Map map;
                String text = new String(data).trim();
                if (text.isEmpty() || (map = (Map)mapper.readValue(data, HashMap.class)) == null) continue;
                HashMap substitutedMap = new HashMap();
                Set set = map.entrySet();
                for (Map.Entry entry : set) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value == null) continue;
                    if (value instanceof String && !dontSubstituteKeys.contains(key)) {
                        value = ZooKeeperUtils.getSubstitutedData((CuratorFramework)curator, (String)value.toString());
                    } else if (value instanceof List) {
                        List list = (List)value;
                        ArrayList<String> substitutedValues = new ArrayList<String>();
                        value = substitutedValues;
                        for (Object item : list) {
                            String serviceText = ZooKeeperUtils.getSubstitutedData((CuratorFramework)curator, (String)item.toString());
                            substitutedValues.add(serviceText);
                        }
                    }
                    substitutedMap.put(key, value);
                }
                answer.put(child, substitutedMap);
                continue;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.addChildrenToMap(map, childPath, curator, mapper);
            if (map.isEmpty()) continue;
            answer.put(child, map);
        }
    }

    public static List listValue(Map<String, Object> map, String key) {
        Object value = null;
        if (map != null) {
            value = map.get(key);
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        if (value != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            return list;
        }
        return null;
    }
}

