/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.data.ServiceInfo;
import io.fabric8.internal.JmxInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class JmxServiceInfo
extends JmxInfo
implements ServiceInfo {
    protected final TabularData properties;

    public JmxServiceInfo(CompositeData data, TabularData properties) {
        super(data, "Identifier");
        this.properties = properties;
    }

    public Long getBundleId() {
        return (Long)this.data.get("BundleIdentifier");
    }

    public Long[] getUsingBundlesId() {
        return (Long[])this.data.get("UsingBundles");
    }

    public String[] getObjectClasses() {
        return (String[])this.data.get("objectClass");
    }

    public ServiceInfo.Property[] getProperties() {
        ServiceInfo.Property[] props = new ServiceInfo.Property[this.properties.size()];
        int i = 0;
        for (CompositeData data : this.properties.values()) {
            String key = data.get("Key").toString();
            Object value = data.get("Value");
            props[i++] = new PropertyImpl(key, value);
        }
        return props;
    }

    static class PropertyImpl
    implements ServiceInfo.Property {
        final String key;
        final Object value;

        PropertyImpl(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

