/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.gravia.IllegalStateAssertion;
import io.fabric8.api.gravia.MapPropertiesProvider;
import io.fabric8.api.gravia.PropertiesProvider;
import io.fabric8.api.gravia.SubstitutionPropertiesProvider;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.support.ConfigInjection;
import io.fabric8.api.visibility.VisibleForExternal;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.BundleContext;

@Component(immediate=true)
@Service(value={Configurer.class})
public class ComponentConfigurer
extends AbstractComponent
implements Configurer {
    private BundleContext bundleContext;

    @VisibleForExternal
    @Activate
    public void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public <T> Map<String, ?> configure(Dictionary<String, ?> configuration, T target, String ... ignorePrefix) throws Exception {
        this.assertValid();
        HashMap mapConfiguration = new HashMap();
        Enumeration<String> keys = configuration.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            mapConfiguration.put(key, configuration.get(key));
        }
        return this.configure(mapConfiguration, target, ignorePrefix);
    }

    public <T> Map<String, ?> configure(Map<String, ?> configuration, T target, String ... ignorePrefix) throws Exception {
        this.assertValid();
        HashMap<String, Object> result = new HashMap<String, Object>();
        PropertiesProvider runtimeProperties = new PropertiesProvider(){

            public Object getProperty(String key) {
                return ComponentConfigurer.this.bundleContext.getProperty(key);
            }

            public Object getRequiredProperty(String key) {
                String value = ComponentConfigurer.this.bundleContext.getProperty(key);
                IllegalStateAssertion.assertNotNull((Object)value, (String)("Cannot obtain property: " + key));
                return value;
            }

            public Object getProperty(String key, Object defaultValue) {
                String value = ComponentConfigurer.this.bundleContext.getProperty(key);
                return value != null ? value : defaultValue;
            }
        };
        MapPropertiesProvider configurationProvider = new MapPropertiesProvider(configuration);
        PropertiesProvider[] propertiesProviders = new PropertiesProvider[]{configurationProvider, runtimeProperties};
        SubstitutionPropertiesProvider provider = new SubstitutionPropertiesProvider(propertiesProviders);
        for (Map.Entry<String, ?> entry : configuration.entrySet()) {
            String key = entry.getKey();
            Object value = provider.getProperty(key);
            result.put(key, value);
        }
        ConfigInjection.applyConfiguration(result, target, (String[])ignorePrefix);
        return result;
    }
}

