/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.ShutdownTracker;
import io.fabric8.core.jmx.FabricManager;
import io.fabric8.core.jmx.FileSystem;
import io.fabric8.core.jmx.HealthCheck;
import io.fabric8.core.jmx.ZooKeeperFacade;
import io.fabric8.service.FabricServiceImpl;
import io.fabric8.utils.NamedThreadFactory;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.mbeanserver.listener", label="Fabric8 MBean Server Listener", metatype=false)
@Service(value={ConnectionStateListener.class})
public final class FabricMBeanRegistrationListener
extends AbstractComponent
implements NotificationListener,
ConnectionStateListener {
    private transient Logger LOGGER = LoggerFactory.getLogger(FabricMBeanRegistrationListener.class);
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=MBeanServer.class, bind="bindMBeanServer", unbind="unbindMBeanServer")
    private final ValidatingReference<MBeanServer> mbeanServer = new ValidatingReference();
    private final Set<String> domains = new HashSet<String>();
    private HealthCheck healthCheck;
    private FabricManager managerMBean;
    private ZooKeeperFacade zooKeeperMBean;
    private FileSystem fileSystemMBean;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("mbean-reg"));
    ShutdownTracker shutdownTracker = new ShutdownTracker();

    @Activate
    void activate() {
        this.registerMBeanServer();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() throws InterruptedException {
        this.deactivateComponent();
        this.unregisterMBeanServer();
        this.shutdownTracker.stop();
        this.executor.shutdownNow();
        this.executor.awaitTermination(5L, TimeUnit.MINUTES);
    }

    @Override
    public void handleNotification(final Notification notif, final Object o) {
        this.executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (FabricMBeanRegistrationListener.this.shutdownTracker.attemptRetain()) {
                    try {
                        FabricMBeanRegistrationListener.this.doHandleNotification(notif, o);
                    }
                    finally {
                        FabricMBeanRegistrationListener.this.shutdownTracker.release();
                    }
                }
            }
        });
    }

    private void doHandleNotification(Notification notif, Object o) {
        this.LOGGER.trace("handleNotification[{}]", (Object)notif);
        if (notif instanceof MBeanServerNotification) {
            MBeanServerNotification notification = (MBeanServerNotification)notif;
            String domain = notification.getMBeanName().getDomain();
            String path = ZkPath.CONTAINER_DOMAIN.getPath(new String[]{(String)o, domain});
            try {
                if ("JMX.mbean.registered".equals(notification.getType())) {
                    if (this.domains.add(domain) && ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path) == null) {
                        ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path, (String)"");
                    }
                } else if ("JMX.mbean.unregistered".equals(notification.getType())) {
                    this.domains.clear();
                    this.domains.addAll(Arrays.asList(((MBeanServer)this.mbeanServer.get()).getDomains()));
                    if (!this.domains.contains(domain)) {
                        ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path);
                    }
                }
            }
            catch (Exception e) {
                this.LOGGER.warn("Exception while jmx domain synchronization from event: " + notif + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        switch (newState) {
            case CONNECTED: 
            case RECONNECTED: {
                this.executor.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (FabricMBeanRegistrationListener.this.shutdownTracker.attemptRetain()) {
                            try {
                                FabricMBeanRegistrationListener.this.updateProcessId();
                                try {
                                    FabricMBeanRegistrationListener.this.registerDomains();
                                }
                                catch (Exception e) {
                                    FabricMBeanRegistrationListener.this.LOGGER.error(e.getMessage(), (Throwable)e);
                                }
                            }
                            finally {
                                FabricMBeanRegistrationListener.this.shutdownTracker.release();
                            }
                        }
                    }
                });
            }
        }
    }

    private void updateProcessId() {
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            Long processId = Long.parseLong(processName.split("@")[0]);
            String runtimeIdentity = ((RuntimeProperties)this.runtimeProperties.get()).getRuntimeIdentity();
            String path = ZkPath.CONTAINER_PROCESS_ID.getPath(new String[]{runtimeIdentity});
            Stat stat = ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path);
            if (stat != null) {
                if (stat.getEphemeralOwner() != ((CuratorFramework)this.curator.get()).getZookeeperClient().getZooKeeper().getSessionId()) {
                    ZooKeeperUtils.delete((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path);
                    if (processId != null) {
                        ZooKeeperUtils.create((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path, (String)processId.toString(), (CreateMode)CreateMode.EPHEMERAL);
                    }
                }
            } else if (processId != null) {
                ZooKeeperUtils.create((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path, (String)processId.toString(), (CreateMode)CreateMode.EPHEMERAL);
            }
        }
        catch (Exception ex) {
            this.LOGGER.error("Error while updating the process id.", (Throwable)ex);
        }
    }

    private void registerMBeanServer() {
        try {
            String runtimeIdentity = ((RuntimeProperties)this.runtimeProperties.get()).getRuntimeIdentity();
            ((MBeanServer)this.mbeanServer.get()).addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, (Object)runtimeIdentity);
            this.registerFabricMBeans();
        }
        catch (Exception e) {
            this.LOGGER.warn("An error occurred during mbean server registration. This exception will be ignored.", (Throwable)e);
        }
    }

    private void unregisterMBeanServer() {
        try {
            ((MBeanServer)this.mbeanServer.get()).removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this);
            this.unregisterFabricMBeans();
        }
        catch (Exception e) {
            this.LOGGER.warn("An error occurred during mbean server unregistration. This exception will be ignored.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDomains() throws Exception {
        String runtimeIdentity = ((RuntimeProperties)this.runtimeProperties.get()).getRuntimeIdentity();
        String domainsNode = ZkPath.CONTAINER_DOMAINS.getPath(new String[]{runtimeIdentity});
        Stat stat = ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)domainsNode);
        if (stat != null) {
            ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)domainsNode);
        }
        FabricMBeanRegistrationListener fabricMBeanRegistrationListener = this;
        synchronized (fabricMBeanRegistrationListener) {
            this.domains.addAll(Arrays.asList(((MBeanServer)this.mbeanServer.get()).getDomains()));
            for (String domain : this.domains) {
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_DOMAIN.getPath(new String[]{runtimeIdentity, domain}), (String)"", (CreateMode)CreateMode.EPHEMERAL);
            }
        }
    }

    private void registerFabricMBeans() {
        this.healthCheck = new HealthCheck((FabricService)this.fabricService.get());
        this.managerMBean = new FabricManager((FabricServiceImpl)((Object)this.fabricService.get()));
        this.zooKeeperMBean = new ZooKeeperFacade((FabricServiceImpl)((Object)this.fabricService.get()));
        this.fileSystemMBean = new FileSystem((RuntimeProperties)this.runtimeProperties.get());
        this.healthCheck.registerMBeanServer(this.shutdownTracker, (MBeanServer)this.mbeanServer.get());
        this.managerMBean.registerMBeanServer(this.shutdownTracker, (MBeanServer)this.mbeanServer.get());
        this.fileSystemMBean.registerMBeanServer(this.shutdownTracker, (MBeanServer)this.mbeanServer.get());
        this.zooKeeperMBean.registerMBeanServer(this.shutdownTracker, (MBeanServer)this.mbeanServer.get());
    }

    private void unregisterFabricMBeans() {
        this.zooKeeperMBean.unregisterMBeanServer((MBeanServer)this.mbeanServer.get());
        this.fileSystemMBean.unregisterMBeanServer((MBeanServer)this.mbeanServer.get());
        this.managerMBean.unregisterMBeanServer((MBeanServer)this.mbeanServer.get());
        this.healthCheck.unregisterMBeanServer((MBeanServer)this.mbeanServer.get());
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer.bind((Object)mbeanServer);
    }

    void unbindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer.unbind((Object)mbeanServer);
    }
}

