/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.GeoLocationService;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component(name="io.fabric8.geolocation.freegoip", immediate=true)
@Service(value={GeoLocationService.class})
public class FreeGeoIpService
implements GeoLocationService {
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGeoLocation() {
        String result = "";
        Closeable closeable = null;
        try {
            String inputLine;
            String urlStr = "http://freegeoip.net/json/";
            URL url = new URL(urlStr);
            URLConnection urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(2000);
            urlConnection.setReadTimeout(5000);
            InputStream is = urlConnection.getInputStream();
            closeable = is;
            InputStreamReader isr = new InputStreamReader(is);
            closeable = isr;
            BufferedReader in = new BufferedReader(isr);
            closeable = in;
            StringBuilder temp = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                temp.append(inputLine);
            }
            if (temp.length() > 0) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = (JsonNode)mapper.readValue(temp.toString(), JsonNode.class);
                JsonNode latitudeNode = node.get(LATITUDE);
                JsonNode longitudeNode = node.get(LONGITUDE);
                if (latitudeNode != null && longitudeNode != null) {
                    result = latitudeNode.toString() + "," + longitudeNode.toString();
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }
}

