/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.ContainerAutoScalerFactory;
import io.fabric8.api.ContainerProvider;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreateRemoteContainerOptions;
import io.fabric8.api.CreationStateListener;
import io.fabric8.api.FabricConstants;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.internal.ContainerProviderUtils;
import io.fabric8.service.ssh.CreateSshContainerMetadata;
import io.fabric8.service.ssh.CreateSshContainerOptions;
import io.fabric8.service.ssh.SshAutoScaler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={ContainerProvider.class})
@org.apache.felix.scr.annotations.Properties(value={@Property(name="fabric.container.protocol", value={"ssh"})})
public class SshContainerProvider
implements ContainerProvider<CreateSshContainerOptions, CreateSshContainerMetadata>,
ContainerAutoScalerFactory {
    static final String SCHEME = "ssh";
    private static final Logger LOGGER = LoggerFactory.getLogger(SshContainerProvider.class);
    private boolean verbose = false;

    public CreateSshContainerOptions.Builder newBuilder() {
        return CreateSshContainerOptions.builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateSshContainerMetadata create(CreateSshContainerOptions options, CreationStateListener listener) {
        try {
            String path = options.getPath();
            String host = options.getHost();
            String ip = InetAddress.getByName(host).getHostAddress();
            if (host == null) {
                throw new IllegalArgumentException("Host name not specified.");
            }
            int port = options.getPort();
            if (port == -1) {
                port = 22;
            }
            String containerName = options.getName();
            CreateSshContainerMetadata metadata = new CreateSshContainerMetadata();
            metadata.setCreateOptions((CreateContainerOptions)options);
            metadata.setContainerName(containerName);
            String script = ContainerProviderUtils.buildInstallAndStartScript((String)containerName, (CreateRemoteContainerOptions)options);
            LOGGER.debug("Running script on host {}:\n{}", (Object)host, (Object)script);
            Session session = null;
            try {
                session = this.createSession(options);
                if (options.doUploadDistribution().booleanValue()) {
                    this.uploadTo(session, options.getProxyUri().resolve("io/fabric8/fabric8-karaf/" + FabricConstants.FABRIC_VERSION + "/fabric8-karaf-" + FabricConstants.FABRIC_VERSION + ".zip").toURL(), "/tmp/fabric8-karaf-" + FabricConstants.FABRIC_VERSION + ".zip");
                }
                this.runScriptOnHost(session, script);
            }
            catch (Throwable ex) {
                metadata.setFailure(ex);
            }
            finally {
                if (session != null) {
                    session.disconnect();
                }
            }
            return metadata;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Container container) {
        CreateContainerMetadata metadata = container.getMetadata();
        if (!(metadata instanceof CreateSshContainerMetadata)) {
            throw new IllegalStateException("Container doesn't have valid create container metadata type");
        }
        CreateSshContainerMetadata sshContainerMetadata = (CreateSshContainerMetadata)metadata;
        CreateSshContainerOptions options = (CreateSshContainerOptions)sshContainerMetadata.getCreateOptions();
        Session session = null;
        try {
            String script = ContainerProviderUtils.buildStartScript((String)container.getId(), (CreateRemoteContainerOptions)options);
            session = this.createSession(options);
            this.runScriptOnHost(session, script);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to start container: " + container.getId(), t);
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Container container) {
        CreateContainerMetadata metadata = container.getMetadata();
        if (!(metadata instanceof CreateSshContainerMetadata)) {
            throw new IllegalStateException("Container doesn't have valid create container metadata type");
        }
        CreateSshContainerMetadata sshContainerMetadata = (CreateSshContainerMetadata)metadata;
        CreateSshContainerOptions options = (CreateSshContainerOptions)sshContainerMetadata.getCreateOptions();
        Session session = null;
        try {
            String script = ContainerProviderUtils.buildStopScript((String)container.getId(), (CreateRemoteContainerOptions)options);
            session = this.createSession(options);
            this.runScriptOnHost(session, script);
            container.setProvisionResult("stopped");
        }
        catch (Throwable t) {
            LOGGER.error("Failed to stop container: " + container.getId(), t);
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Container container) {
        CreateContainerMetadata metadata = container.getMetadata();
        if (!(metadata instanceof CreateSshContainerMetadata)) {
            throw new IllegalStateException("Container doesn't have valid create container metadata type");
        }
        CreateSshContainerMetadata sshContainerMetadata = (CreateSshContainerMetadata)metadata;
        CreateSshContainerOptions options = (CreateSshContainerOptions)sshContainerMetadata.getCreateOptions();
        Session session = null;
        try {
            String script = ContainerProviderUtils.buildUninstallScript((String)container.getId(), (CreateRemoteContainerOptions)options);
            session = this.createSession(options);
            this.runScriptOnHost(session, script);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to stop container: " + container.getId(), t);
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    public String getScheme() {
        return SCHEME;
    }

    public boolean isValidProvider() {
        return true;
    }

    public Class<CreateSshContainerOptions> getOptionsType() {
        return CreateSshContainerOptions.class;
    }

    public Class<CreateSshContainerMetadata> getMetadataType() {
        return CreateSshContainerMetadata.class;
    }

    public ContainerAutoScaler createAutoScaler(FabricRequirements requirements, ProfileRequirements profileRequirements) {
        List hosts = requirements.getSshHosts();
        if (!hosts.isEmpty()) {
            return new SshAutoScaler(this);
        }
        return null;
    }

    protected Session createSession(CreateSshContainerOptions options) throws Exception {
        Session session = null;
        Exception connectException = null;
        for (int i = 0; i <= options.getSshRetries(); ++i) {
            if (i > 0) {
                long delayMs = (long)(200.0 * Math.pow(i, 2.0));
                Thread.sleep(delayMs);
            }
            try {
                byte[] passPhrase;
                JSch jsch = new JSch();
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                byte[] privateKey = this.readFile(options.getPrivateKeyFile());
                byte[] byArray = passPhrase = options.getPassPhrase() != null ? options.getPassPhrase().getBytes() : null;
                if (privateKey != null && options.getPassword() == null) {
                    jsch.addIdentity(options.getUsername(), privateKey, null, passPhrase);
                    session = jsch.getSession(options.getUsername(), options.getHost(), options.getPort());
                    config.put("PreferredAuthentications", "publickey");
                } else {
                    session = jsch.getSession(options.getUsername(), options.getHost(), options.getPort());
                    session.setPassword(options.getPassword());
                    config.put("PreferredAuthentications", "password,keyboard-interactive");
                }
                session.setTimeout(60000);
                session.setConfig(config);
                session.connect();
                connectException = null;
                break;
            }
            catch (Exception from) {
                connectException = from;
                if (session != null && session.isConnected()) {
                    session.disconnect();
                }
                session = null;
                continue;
            }
        }
        if (connectException != null) {
            throw connectException;
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runScriptOnHost(Session session, String script) throws Exception {
        ChannelExec executor = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        try {
            executor = (ChannelExec)session.openChannel("exec");
            executor.setPty(true);
            executor.setCommand(script);
            executor.setOutputStream((OutputStream)output);
            executor.setErrStream((OutputStream)error);
            executor.connect();
            int errorStatus = -1;
            int i = 0;
            while (!executor.isClosed()) {
                if (i > 0) {
                    long delayMs = (long)(200.0 * Math.pow(i, 2.0));
                    Thread.sleep(delayMs);
                }
                if ((errorStatus = executor.getExitStatus()) != -1) break;
                ++i;
            }
            LOGGER.debug("Output: {}", (Object)output.toString());
            LOGGER.debug("Error:  {}", (Object)error.toString());
            if (this.verbose) {
                System.out.println("Output : " + output.toString());
                System.out.println("Error : " + error.toString());
            }
            if (errorStatus != 0) {
                throw new Exception(String.format("%s@%s:%d: received exit status %d executing \n--- command ---\n%s\n--- output ---\n%s\n--- error ---\n%s\n------\n", session.getUserName(), session.getHost(), session.getPort(), executor.getExitStatus(), script, output.toString(), error.toString()));
            }
        }
        finally {
            if (executor != null) {
                executor.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadTo(Session session, URL url, String path) {
        Channel channel = null;
        try (final InputStream is = url.openStream();){
            channel = session.openChannel("sftp");
            channel.connect();
            ChannelSftp sftpChannel = (ChannelSftp)channel;
            final CountDownLatch uploadLatch = new CountDownLatch(1);
            sftpChannel.put(is, path, new SftpProgressMonitor(){

                public void init(int op, String src, String dest, long max) {
                }

                public boolean count(long count) {
                    try {
                        return is.available() > 0;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }

                public void end() {
                    uploadLatch.countDown();
                }
            }, 0);
            uploadLatch.await(10L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to upload. Will attempt downloading distribution via maven.");
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(String path) {
        byte[] bytes = null;
        FileInputStream fin = null;
        File file = new File(path);
        if (path != null && file.exists()) {
            try {
                fin = new FileInputStream(file);
                bytes = new byte[(int)file.length()];
                fin.read(bytes);
            }
            catch (IOException e) {
                LOGGER.warn("Error reading file {}.", (Object)path);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        return bytes;
    }
}

