/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.ssh.commands;

import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricService;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.boot.commands.support.AbstractContainerCreateAction;
import io.fabric8.service.ssh.CreateSshContainerOptions;
import io.fabric8.utils.FabricValidations;
import io.fabric8.utils.shell.ShellUtils;
import java.net.InetAddress;
import java.net.URI;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="container-create-ssh", scope="fabric", description="Creates one or more new containers via SSH", detailedDescription="classpath:containerCreateSsh.txt")
public class ContainerCreateSshAction
extends AbstractContainerCreateAction {
    @Option(name="--host", required=true, description="Host name to SSH into")
    private String host;
    @Option(name="--path", description="Path on the remote filesystem where the container is to be installed.")
    private String path;
    @Option(name="--env", required=false, multiValued=true, description="Adds an environmental variable. To specify multiple variables, use this flag multiple times.")
    private List<String> environmentalVariables;
    @Option(name="--user", description="User name for login.")
    private String user;
    @Option(name="--password", description="Password for login. If the password is omitted, private key authentication is used instead.")
    private String password;
    @Option(name="--port", description="The IP port number for the SSH connection.")
    private int port = 22;
    @Option(name="--min-port", multiValued=false, description="The minimum port of the allowed port range")
    private int minimumPort = 0;
    @Option(name="--max-port", multiValued=false, description="The maximum port of the allowed port range")
    private int maximumPort = 65535;
    @Option(name="--ssh-retries", description="Number of retries to connect on SSH")
    private int sshRetries;
    @Option(name="--proxy-uri", description="Maven proxy URL to use")
    private URI proxyUri;
    @Option(name="--private-key", description="The path to the private key on the filesystem. Default is ~/.ssh/id_rsa on *NIX platforms or C:\\Documents and Settings\\<UserName>\\.ssh\\id_rsa on Windows.")
    private String privateKeyFile;
    @Option(name="--pass-phrase", description="The pass phrase of the key. This is for use with private keys that require a pass phrase.")
    private String passPhrase;
    @Option(name="--new-user", multiValued=false, description="The username of a new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUser = "admin";
    @Option(name="--new-user-password", multiValued=false, description="The password of the new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUserPassword;
    @Option(name="--new-user-role", multiValued=false, description="The role of the new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUserRole = "admin";
    @Option(name="--with-admin-access", description="Indicates that the target user has admin access (password-less sudo). When used installation of missing dependencies will be attempted.")
    private boolean adminAccess;
    @Option(name="--disable-distribution-upload", multiValued=false, description="Flag to disable uploading the distribution. When used distribution will be downloaded via maven")
    private Boolean distributionUploadDisable = false;
    @Argument(index=0, required=true, description="The name of the container to be created. When creating multiple containers it serves as a prefix")
    protected String name;
    @Argument(index=1, required=false, description="The number of containers that should be created")
    protected int number = 0;

    ContainerCreateSshAction(FabricService fabricService, ZooKeeperClusterService clusterService) {
        super(fabricService, clusterService);
    }

    protected Object doExecute() throws Exception {
        this.preCreateContainer(this.name);
        FabricValidations.validateProfileNames(this.profiles);
        if (this.isEnsembleServer.booleanValue() && this.newUserPassword == null) {
            this.newUserPassword = this.zookeeperPassword != null ? this.zookeeperPassword : this.fabricService.getZookeeperPassword();
        }
        CreateSshContainerOptions.Builder builder = ((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)CreateSshContainerOptions.builder().name(this.name)).ensembleServer(this.isEnsembleServer)).resolver(this.resolver)).bindAddress(this.bindAddress)).manualIp(this.manualIp)).number(this.number)).host(this.host).preferredAddress(InetAddress.getByName(this.host).getHostAddress())).username(this.user).password(this.password).privateKeyFile(this.privateKeyFile != null ? this.privateKeyFile : CreateSshContainerOptions.DEFAULT_PRIVATE_KEY_FILE).passPhrase(this.passPhrase).port(this.port).adminAccess(this.adminAccess)).sshRetries(this.sshRetries).minimumPort(this.minimumPort)).maximumPort(this.maximumPort)).password(this.password).proxyUri(this.proxyUri != null ? this.proxyUri : this.fabricService.getMavenRepoURI())).zookeeperUrl(this.fabricService.getZookeeperUrl())).zookeeperPassword(this.isEnsembleServer != false && this.zookeeperPassword != null ? this.zookeeperPassword : this.fabricService.getZookeeperPassword())).jvmOpts(this.jvmOpts != null ? this.jvmOpts : this.fabricService.getDefaultJvmOptions())).environmentalVariable(this.environmentalVariables).withUser(this.newUser, this.newUserPassword, this.newUserRole)).version(this.version)).profiles(this.getProfileNames())).dataStoreProperties(this.getDataStoreProperties())).uploadDistribution(this.distributionUploadDisable == false);
        if (this.path != null && !this.path.isEmpty()) {
            builder.path(this.path);
        }
        CreateContainerMetadata[] metadatas = this.fabricService.createContainers((CreateContainerOptions)builder.build());
        if (this.isEnsembleServer.booleanValue() && metadatas != null && metadatas.length > 0 && metadatas[0].isSuccess()) {
            ShellUtils.storeZookeeperPassword(this.session, metadatas[0].getCreateOptions().getZookeeperPassword());
        }
        this.displayContainers(metadatas);
        return null;
    }
}

