/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.proxy.impl;

import io.fabric8.api.FabricConstants;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.common.util.Closeables;
import io.fabric8.deployer.ProjectDeployer;
import io.fabric8.maven.MavenResolver;
import io.fabric8.maven.proxy.impl.DefaultFuture;
import io.fabric8.maven.proxy.impl.FutureListener;
import io.fabric8.maven.proxy.impl.MavenProxyServletSupport;
import io.fabric8.utils.ThreadFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MavenDownloadProxyServlet
extends MavenProxyServletSupport {
    private final ConcurrentMap<String, ArtifactDownloadFuture> requestMap = new ConcurrentHashMap<String, ArtifactDownloadFuture>();
    private final int threadMaximumPoolSize;
    private ThreadPoolExecutor executorService;

    public MavenDownloadProxyServlet(MavenResolver resolver, RuntimeProperties runtimeProperties, ProjectDeployer projectDeployer, int threadMaximumPoolSize) {
        this(resolver, runtimeProperties, projectDeployer, null, threadMaximumPoolSize);
    }

    protected MavenDownloadProxyServlet(MavenResolver resolver, RuntimeProperties runtimeProperties, ProjectDeployer projectDeployer, File uploadRepository, int threadMaximumPoolSize) {
        super(resolver, runtimeProperties, projectDeployer, uploadRepository);
        this.threadMaximumPoolSize = threadMaximumPoolSize;
    }

    @Override
    public synchronized void start() throws IOException {
        int nbThreads = this.threadMaximumPoolSize > 0 ? this.threadMaximumPoolSize : 8;
        this.executorService = new ThreadPoolExecutor(0, nbThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory("MavenDownloadProxyServlet"));
        super.start();
    }

    @Override
    public synchronized void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                this.executorService.shutdownNow();
            }
        }
        super.stop();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected void doGet(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        String tpath = req.getPathInfo();
        if (tpath == null) {
            resp.setStatus(500);
            return;
        }
        if (tpath.startsWith("/")) {
            tpath = tpath.substring(1);
        }
        final String path = tpath;
        final AsyncContext asyncContext = req.startAsync();
        asyncContext.setTimeout(TimeUnit.MINUTES.toMillis(5L));
        final AsynchronousFileChannel channel = (AsynchronousFileChannel)req.getAttribute(AsynchronousFileChannel.class.getName());
        if (channel != null) {
            long size = (Long)req.getAttribute(AsynchronousFileChannel.class.getName() + ".size");
            long pos = (Long)req.getAttribute(AsynchronousFileChannel.class.getName() + ".position");
            int read = (Integer)req.getAttribute(AsynchronousFileChannel.class.getName() + ".read");
            ByteBuffer buffer = (ByteBuffer)req.getAttribute(ByteBuffer.class.getName());
            ByteBuffer secondBuffer = (ByteBuffer)req.getAttribute(ByteBuffer.class.getName() + ".second");
            if (read > 0) {
                if ((pos += (long)read) < size) {
                    req.setAttribute(AsynchronousFileChannel.class.getName() + ".position", (Object)pos);
                    req.setAttribute(ByteBuffer.class.getName(), (Object)secondBuffer);
                    req.setAttribute(ByteBuffer.class.getName() + ".second", (Object)buffer);
                    channel.read(secondBuffer, pos, asyncContext, new CompletionHandler<Integer, AsyncContext>(){

                        @Override
                        public void completed(Integer result, AsyncContext attachment) {
                            req.setAttribute(AsynchronousFileChannel.class.getName() + ".read", (Object)result);
                            attachment.dispatch();
                        }

                        @Override
                        public void failed(Throwable exc, AsyncContext attachment) {
                            Closeables.closeQuietly((Closeable)channel);
                            resp.setStatus(500);
                            attachment.complete();
                        }
                    });
                }
                buffer.flip();
                resp.getOutputStream().write(buffer.array(), 0, buffer.remaining());
                resp.flushBuffer();
                if (pos == size) {
                    Closeables.closeQuietly((Closeable)channel);
                    asyncContext.complete();
                }
            } else {
                Closeables.closeQuietly((Closeable)channel);
                resp.setStatus(500);
                asyncContext.complete();
            }
            return;
        }
        final ArtifactDownloadFuture future = new ArtifactDownloadFuture(path);
        ArtifactDownloadFuture masterFuture = this.requestMap.putIfAbsent(path, future);
        if (masterFuture == null) {
            masterFuture = future;
            masterFuture.lock();
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        File file = MavenDownloadProxyServlet.this.download(path);
                        future.setValue(file);
                    }
                    catch (Throwable t) {
                        future.setValue(t);
                    }
                }
            });
        } else {
            masterFuture.lock();
        }
        masterFuture.addListener(new FutureListener<ArtifactDownloadFuture>(){

            @Override
            public void operationComplete(ArtifactDownloadFuture future) {
                Object value = future.getValue();
                if (value instanceof Throwable) {
                    MavenProxyServletSupport.LOGGER.warn("Error while downloading artifact: {}", (Object)((Throwable)value).getMessage(), value);
                    resp.setStatus(500);
                } else if (value instanceof File) {
                    File artifactFile = (File)value;
                    AsynchronousFileChannel channel = null;
                    try {
                        channel = AsynchronousFileChannel.open(artifactFile.toPath(), StandardOpenOption.READ);
                        MavenProxyServletSupport.LOGGER.info("Writing response for file : {}", (Object)path);
                        resp.setStatus(200);
                        resp.setContentType("application/octet-stream");
                        resp.setDateHeader("Date", System.currentTimeMillis());
                        resp.setHeader("Connection", "close");
                        resp.setHeader("Server", "MavenProxy Proxy/" + FabricConstants.FABRIC_VERSION);
                        long size = artifactFile.length();
                        if (size < Integer.MAX_VALUE) {
                            resp.setContentLength((int)size);
                        }
                        if ("GET".equals(req.getMethod())) {
                            req.setAttribute(AsynchronousFileChannel.class.getName(), (Object)channel);
                            ByteBuffer buffer = ByteBuffer.allocate(65536);
                            ByteBuffer secondBuffer = ByteBuffer.allocate(65536);
                            req.setAttribute(ByteBuffer.class.getName(), (Object)secondBuffer);
                            req.setAttribute(ByteBuffer.class.getName() + ".second", (Object)buffer);
                            req.setAttribute(AsynchronousFileChannel.class.getName() + ".position", (Object)0L);
                            req.setAttribute(AsynchronousFileChannel.class.getName() + ".size", (Object)size);
                            channel.read(secondBuffer, 0L, asyncContext, new CompletionHandler<Integer, AsyncContext>(){

                                @Override
                                public void completed(Integer result, AsyncContext attachment) {
                                    req.setAttribute(AsynchronousFileChannel.class.getName() + ".read", (Object)result);
                                    attachment.dispatch();
                                }

                                @Override
                                public void failed(Throwable exc, AsyncContext attachment) {
                                    resp.setStatus(500);
                                    attachment.complete();
                                }
                            });
                        } else if ("HEAD".equals(req.getMethod())) {
                            asyncContext.complete();
                        }
                        future.release();
                        return;
                    }
                    catch (Exception e) {
                        Closeables.closeQuietly(channel);
                        MavenProxyServletSupport.LOGGER.warn("Error while sending artifact: {}", (Object)e.getMessage(), (Object)e);
                        resp.setStatus(500);
                    }
                } else {
                    resp.setStatus(404);
                }
                future.release();
                try {
                    asyncContext.complete();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        });
    }

    private class ArtifactDownloadFuture
    extends DefaultFuture<ArtifactDownloadFuture> {
        private final AtomicInteger participants = new AtomicInteger();
        private final String path;

        private ArtifactDownloadFuture(String path) {
            this.path = path;
        }

        public void lock() {
            this.participants.incrementAndGet();
        }

        public void release() {
            if (this.participants.decrementAndGet() == 0) {
                MavenDownloadProxyServlet.this.requestMap.remove(this.path);
                Object v = this.getValue();
                if (v instanceof File) {
                    ((File)v).delete();
                }
            }
        }
    }
}

