/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.proxy.impl;

import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.deployer.ProjectDeployer;
import io.fabric8.maven.MavenResolver;
import io.fabric8.maven.proxy.impl.MavenDownloadProxyServlet;
import io.fabric8.maven.proxy.impl.MavenSecureHttpContext;
import io.fabric8.maven.proxy.impl.MavenUploadProxyServlet;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Servlet;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.zookeeper.CreateMode;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.maven.proxy", label="Fabric8 Maven Proxy Registration Handler", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={ConnectionStateListener.class})
public final class MavenProxyRegistrationHandler
extends AbstractComponent
implements ConnectionStateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProxyRegistrationHandler.class);
    private static final String DEFAULT_ROLE = "admin,manager,viewer,Monitor,Operator,Maintainer,Deployer,Auditor,Administrator,SuperUser";
    private static final String DEFAULT_REALM = "karaf";
    private static final String DEFAULT_LOCAL_REPOSITORY = System.getProperty("karaf.data") + File.separator + "maven" + File.separator + "proxy" + File.separator + "downloads";
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=HttpService.class)
    private final ValidatingReference<HttpService> httpService = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=ProjectDeployer.class)
    private final ValidatingReference<ProjectDeployer> projectDeployer = new ValidatingReference();
    @Reference(referenceInterface=MavenResolver.class)
    private final ValidatingReference<MavenResolver> mavenResolver = new ValidatingReference();
    private final Map<String, Set<String>> registeredProxies;
    @GuardedBy(value="volatile")
    private volatile MavenDownloadProxyServlet mavenDownloadProxyServlet;
    @GuardedBy(value="volatile")
    private volatile MavenUploadProxyServlet mavenUploadProxyServlet;
    @GuardedBy(value="volatile")
    @Property(name="realm", label="Jaas Realm", description="The Jaas Realm to use for uploads", value={"karaf"})
    private volatile String realm;
    @GuardedBy(value="volatile")
    @Property(name="role", label="Jaas Role", description="The Jaas Role to use for uploads", value={"admin,manager,viewer,Monitor,Operator,Maintainer,Deployer,Auditor,Administrator,SuperUser"})
    private volatile String[] role;
    @Property(name="name", label="Container Name", description="The name of the container", value={"${runtime.id}"})
    private String name;
    @Property(name="threadMaximumPoolSize", label="Thread pool maximum size", description="Maximum number of concurrent threads used for the DownloadMavenProxy servlet", intValue={5})
    private int threadMaximumPoolSize;
    @Property(name="upload", label="Upload repository", description="The path to hold uploaded artifacts", value={"${runtime.data}/data/maven/upload"})
    private String uploadRepository;
    @GuardedBy(value="AtomicBoolean")
    private final AtomicBoolean connected = new AtomicBoolean(false);

    public MavenProxyRegistrationHandler() {
        HashMap proxies = new HashMap();
        proxies.put("download", new HashSet());
        proxies.put("upload", new HashSet());
        this.registeredProxies = Collections.unmodifiableMap(proxies);
    }

    @Activate
    void init(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this, new String[0]);
        if (this.uploadRepository == null) {
            this.uploadRepository = ((RuntimeProperties)this.runtimeProperties.get()).getProperty("runtime.data") + "/maven/upload";
        }
        this.mavenDownloadProxyServlet = new MavenDownloadProxyServlet((MavenResolver)this.mavenResolver.get(), (RuntimeProperties)this.runtimeProperties.get(), (ProjectDeployer)this.projectDeployer.get(), this.threadMaximumPoolSize);
        this.mavenDownloadProxyServlet.start();
        this.mavenUploadProxyServlet = new MavenUploadProxyServlet((MavenResolver)this.mavenResolver.get(), (RuntimeProperties)this.runtimeProperties.get(), (ProjectDeployer)this.projectDeployer.get(), new File(this.uploadRepository));
        this.mavenUploadProxyServlet.start();
        try {
            HttpContext base = ((HttpService)this.httpService.get()).createDefaultHttpContext();
            MavenSecureHttpContext secure = new MavenSecureHttpContext(base, this.realm, this.role);
            ((HttpService)this.httpService.get()).registerServlet("/maven/download", (Servlet)this.mavenDownloadProxyServlet, this.createParams("maven-download"), base);
            ((HttpService)this.httpService.get()).registerServlet("/maven/upload", (Servlet)this.mavenUploadProxyServlet, this.createParams("maven-upload"), (HttpContext)secure);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to register fabric maven proxy servlets, due to:" + t.getMessage());
        }
        this.activateComponent();
    }

    @Deactivate
    void destroy() {
        this.deactivateComponent();
        if (this.mavenDownloadProxyServlet != null) {
            this.mavenDownloadProxyServlet.stop();
        }
        if (this.mavenUploadProxyServlet != null) {
            this.mavenUploadProxyServlet.stop();
        }
        try {
            ((HttpService)this.httpService.get()).unregister("/maven/download");
            ((HttpService)this.httpService.get()).unregister("/maven/upload");
        }
        catch (Exception ex) {
            LOGGER.warn("Http service returned error on servlet unregister. Possibly the service has already been stopped");
        }
        if (this.connected.get()) {
            this.unregister("download");
            this.unregister("upload");
        }
    }

    private Dictionary<String, String> createParams(String name) {
        Hashtable<String, String> d = new Hashtable<String, String>();
        ((Dictionary)d).put("servlet-name", name);
        return d;
    }

    private void register(String type) {
        this.unregister(type);
        try {
            String mavenProxyUrl = "${zk:" + this.name + "/http}/maven/" + type + "/";
            String parentPath = ZkPath.MAVEN_PROXY.getPath(new String[]{type});
            String path = parentPath + "/p_";
            this.registeredProxies.get(type).add(ZooKeeperUtils.create((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path, (String)mavenProxyUrl, (CreateMode)CreateMode.EPHEMERAL_SEQUENTIAL));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to register maven proxy.");
        }
    }

    private void unregister(String type) {
        Set<String> proxyNodes = this.registeredProxies.get(type);
        if (proxyNodes != null) {
            try {
                for (String entry : this.registeredProxies.get(type)) {
                    ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)entry);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to remove maven proxy from registry.");
            }
            this.registeredProxies.get(type).clear();
        }
    }

    private String readProperty(Map<String, ?> properties, String key, String defaultValue) {
        return properties != null && properties.containsKey(key) ? properties.get(key).toString() : defaultValue;
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        switch (newState) {
            case CONNECTED: 
            case RECONNECTED: {
                this.connected.set(true);
                if (!this.isValid()) break;
                this.register("download");
                this.register("upload");
                break;
            }
            default: {
                this.connected.set(false);
            }
        }
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindHttpService(HttpService service) {
        this.httpService.bind((Object)service);
    }

    void unbindHttpService(HttpService service) {
        this.httpService.unbind((Object)service);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindProjectDeployer(ProjectDeployer projectDeployer) {
        this.projectDeployer.bind((Object)projectDeployer);
    }

    void unbindProjectDeployer(ProjectDeployer projectDeployer) {
        this.projectDeployer.unbind((Object)projectDeployer);
    }

    void bindMavenResolver(MavenResolver mavenResolver) {
        this.mavenResolver.bind((Object)mavenResolver);
    }

    void unbindMavenResolver(MavenResolver mavenResolver) {
        this.mavenResolver.unbind((Object)mavenResolver);
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

