/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.proxy.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenSecureHttpContext
implements HttpContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenSecureHttpContext.class);
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    private final String realm;
    private final String[] roles;
    private final HttpContext base;

    public MavenSecureHttpContext(HttpContext base, String realm, String[] role) {
        this.base = base;
        this.realm = realm;
        this.roles = role;
    }

    public URL getResource(String name) {
        return this.base.getResource(name);
    }

    public String getMimeType(String name) {
        return this.base.getMimeType(name);
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) {
        return this.authenticate(request, response);
    }

    public Subject doAuthenticate(final String username, final String password) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] instanceof NameCallback) {
                            ((NameCallback)callbacks[i]).setName(username);
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            ((PasswordCallback)callbacks[i]).setPassword(password.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callbacks[i]);
                    }
                }
            });
            loginContext.login();
            boolean found = false;
            block4: for (String role : this.roles) {
                if (role == null || role.length() <= 0) continue;
                String clazz = "org.apache.karaf.jaas.boot.principal.RolePrincipal";
                String name = role;
                int idx = role.indexOf(58);
                if (idx > 0) {
                    clazz = role.substring(0, idx);
                    name = role.substring(idx + 1);
                }
                for (Principal p : subject.getPrincipals()) {
                    if (!p.getClass().getName().equals(clazz) || !p.getName().equals(name)) continue;
                    found = true;
                    continue block4;
                }
            }
            if (!found) {
                throw new FailedLoginException("User does not have the required role " + this.roles);
            }
            return subject;
        }
        catch (AccountException e) {
            LOGGER.warn("Account failure", (Throwable)e);
            return null;
        }
        catch (LoginException e) {
            LOGGER.debug("Login failed", (Throwable)e);
            return null;
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("General Security Exception", (Throwable)e);
            return null;
        }
    }

    public boolean authenticate(HttpServletRequest request, HttpServletResponse response) {
        int blank;
        String authHeader;
        if (request.getHeader("Origin") != null) {
            response.addHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
            String headers = request.getHeader("Access-Control-Request-Headers");
            if (headers != null) {
                response.addHeader("Access-Control-Allow-Headers", headers);
            }
            response.addHeader("Access-Control-Max-Age", "" + TimeUnit.DAYS.toSeconds(1L));
            response.addHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
            response.addHeader("Access-Control-Allow-Credentials", "true");
            if ("OPTIONS".equals(request.getMethod())) {
                return true;
            }
        }
        if ((authHeader = request.getHeader(HEADER_AUTHORIZATION)) != null && authHeader.length() > 0 && (blank = (authHeader = authHeader.trim()).indexOf(32)) > 0) {
            String authType = authHeader.substring(0, blank);
            String authInfo = authHeader.substring(blank).trim();
            if (authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
                try {
                    String srcString = MavenSecureHttpContext.base64Decode(authInfo);
                    int i = srcString.indexOf(58);
                    String username = srcString.substring(0, i);
                    String password = srcString.substring(i + 1);
                    Subject subject = this.doAuthenticate(username, password);
                    if (subject != null) {
                        request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
                        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
                        return true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + this.realm + "\"");
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return false;
    }

    private static String base64Decode(String srcString) {
        byte[] transformed = new byte[]{};
        try {
            transformed = Base64.decodeBase64((byte[])srcString.getBytes("ISO-8859-1"));
            return new String(transformed, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            return new String(transformed);
        }
    }

    public String getRealm() {
        return this.realm;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String toString() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        return this.getClass().getSimpleName() + "{" + bundle.getSymbolicName() + " - " + bundle.getBundleId() + "}";
    }
}

