/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.proxy.impl;

import io.fabric8.api.RuntimeProperties;
import io.fabric8.deployer.ProjectDeployer;
import io.fabric8.deployer.dto.DeployResults;
import io.fabric8.deployer.dto.ProjectRequirements;
import io.fabric8.maven.MavenResolver;
import io.fabric8.maven.proxy.impl.InvalidMavenArtifactRequest;
import io.fabric8.maven.proxy.impl.MavenDownloadProxyServlet;
import io.fabric8.maven.proxy.impl.UploadContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

public class MavenUploadProxyServlet
extends MavenDownloadProxyServlet {
    protected File tmpMultipartFolder;
    private DiskFileItemFactory fileItemFactory;

    public MavenUploadProxyServlet(MavenResolver resolver, RuntimeProperties runtimeProperties, ProjectDeployer projectDeployer, File uploadRepository) {
        super(resolver, runtimeProperties, projectDeployer, uploadRepository, 0);
        this.tmpMultipartFolder = new File(this.tmpFolder, "multipart");
        this.fileItemFactory = new DiskFileItemFactory(10240, this.tmpMultipartFolder);
    }

    @Override
    public synchronized void start() throws IOException {
        super.start();
        this.tmpMultipartFolder.mkdirs();
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String path = req.getPathInfo();
            if (path == null) {
                resp.setStatus(400);
                return;
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            UploadContext result = null;
            String location = req.getHeader("X-Location");
            if (location != null) {
                result = this.move(location, path);
            } else if (FileUploadBase.isMultipartContent(new ServletRequestContext(req))) {
                List<FileItem> items = new ServletFileUpload(this.fileItemFactory).parseRequest(req);
                if (items != null && items.size() > 0) {
                    FileItem item = items.get(0);
                    result = this.doUpload(item.getInputStream(), path);
                    item.delete();
                }
            } else {
                result = this.doUpload((InputStream)req.getInputStream(), path);
            }
            if (result != null && result.status()) {
                this.handleDeploy(req, result);
                MavenUploadProxyServlet.addHeaders(resp, result.headers());
                resp.setStatus(202);
            } else {
                resp.setStatus(406);
            }
        }
        catch (InvalidMavenArtifactRequest ex) {
            resp.setStatus(400);
            resp.setContentLength(0);
            resp.flushBuffer();
        }
        catch (Exception ex) {
            resp.setStatus(500);
            resp.setContentLength(0);
            resp.flushBuffer();
        }
    }

    private void handleDeploy(HttpServletRequest req, UploadContext result) throws Exception {
        String profile = req.getParameter("profile");
        String version = req.getParameter("version");
        if (profile != null && version != null) {
            ProjectRequirements requirements = this.toProjectRequirements(result);
            requirements.setProfileId(profile);
            requirements.setVersion(version);
            DeployResults deployResults = this.addToProfile(requirements);
            LOGGER.info(String.format("Deployed artifact %s to profile: %s", result.toArtifact(), deployResults));
        }
    }

    private static void addHeaders(HttpServletResponse resp, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            resp.addHeader(entry.getKey(), entry.getValue());
        }
    }

    protected void setFileItemFactory(DiskFileItemFactory fileItemFactory) {
        this.fileItemFactory = fileItemFactory;
    }
}

