/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.url.internal;

import io.fabric8.common.util.Filter;
import io.fabric8.common.util.Filters;
import io.fabric8.common.util.IOHelpers;
import io.fabric8.maven.DependencyFilters;
import io.fabric8.maven.DuplicateTransformer;
import io.fabric8.maven.FailedToResolveDependency;
import io.fabric8.maven.MavenResolver;
import io.fabric8.maven.PomDetails;
import io.fabric8.maven.ReplaceConflictingVersionResolver;
import io.fabric8.maven.StaticWagonProvider;
import io.fabric8.maven.util.MavenConfiguration;
import io.fabric8.maven.util.MavenRepositoryURL;
import io.fabric8.maven.util.Parser;
import io.fabric8.maven.util.decrypt.MavenSettingsDecrypter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.model.Model;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.internal.impl.DefaultTransporterProvider;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.graph.manager.ClassicDependencyManager;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.graph.traverser.FatArtifactTraverser;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherBasedResolver
implements MavenResolver {
    private static final Logger LOG = LoggerFactory.getLogger(AetherBasedResolver.class);
    private static final String LATEST_VERSION_RANGE = "(0.0,]";
    private static final String REPO_TYPE = "default";
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherBasedResolver.class);
    private final RepositorySystem m_repoSystem;
    private final MavenConfiguration m_config;
    private final MirrorSelector m_mirrorSelector;
    private final ProxySelector m_proxySelector;
    private Settings m_settings;
    private SettingsDecrypter decrypter;
    private LocalRepository localRepository;
    private final ConcurrentMap<LocalRepository, Deque<DefaultRepositorySystemSession>> sessions = new ConcurrentHashMap<LocalRepository, Deque<DefaultRepositorySystemSession>>();
    private boolean throwExceptionsOnResolveDependencyFailure;

    public AetherBasedResolver(MavenConfiguration configuration) {
        this(configuration, null, null);
    }

    public AetherBasedResolver(MavenConfiguration configuration, Mirror mirror) {
        this(configuration, mirror, null);
    }

    public AetherBasedResolver(MavenConfiguration configuration, Mirror mirror, RepositorySystem repositorySystem) {
        this.m_config = configuration;
        this.m_settings = configuration.getSettings();
        if (repositorySystem == null) {
            this.m_repoSystem = this.newRepositorySystem();
        } else {
            this.m_repoSystem = repositorySystem;
            this.decrypter = new MavenSettingsDecrypter(this.m_config.getSecuritySettings());
        }
        this.decryptSettings();
        this.m_proxySelector = this.selectProxies();
        this.m_mirrorSelector = this.selectMirrors(mirror);
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterProvider.class, DefaultTransporterProvider.class);
        locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
        locator.setServices(WagonProvider.class, new StaticWagonProvider(this.m_config.getTimeout()));
        this.decrypter = new MavenSettingsDecrypter(this.m_config.getSecuritySettings());
        locator.setServices(SettingsDecrypter.class, this.decrypter);
        return locator.getService(RepositorySystem.class);
    }

    private void decryptSettings() {
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(this.m_settings);
        SettingsDecryptionResult result = this.decrypter.decrypt(request);
        this.m_settings.setProxies(result.getProxies());
        this.m_settings.setServers(result.getServers());
    }

    private ProxySelector selectProxies() {
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy proxy : this.m_settings.getProxies()) {
            String nonProxyHosts = proxy.getNonProxyHosts();
            Proxy proxyObj = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), this.getAuthentication(proxy));
            proxySelector.add(proxyObj, nonProxyHosts);
        }
        return proxySelector;
    }

    private MirrorSelector selectMirrors(Mirror mirror) {
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        for (Mirror m : this.m_settings.getMirrors()) {
            selector.add(m.getName(), m.getUrl(), null, false, m.getMirrorOf(), "*");
        }
        if (mirror != null) {
            selector.add(mirror.getName(), mirror.getUrl(), null, false, mirror.getMirrorOf(), "*");
        }
        return selector;
    }

    @Override
    public RepositorySystem getRepositorySystem() {
        return this.m_repoSystem;
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        List<RemoteRepository> repos = this.selectRepositories();
        this.assignProxyAndMirrors(repos);
        return repos;
    }

    private List<RemoteRepository> selectRepositories() {
        ArrayList<RemoteRepository> list = new ArrayList<RemoteRepository>();
        List<Object> urls = Collections.emptyList();
        try {
            urls = this.m_config.getRepositories();
        }
        catch (MalformedURLException exc) {
            LOG.error("invalid repository URLs", (Throwable)exc);
        }
        for (MavenRepositoryURL mavenRepositoryURL : urls) {
            if (mavenRepositoryURL.isMulti()) {
                this.addSubDirs(list, mavenRepositoryURL.getFile());
                continue;
            }
            this.addRepo(list, mavenRepositoryURL);
        }
        return list;
    }

    private void assignProxyAndMirrors(List<RemoteRepository> remoteRepos) {
        HashMap map = new HashMap();
        HashMap<String, RemoteRepository> naming = new HashMap<String, RemoteRepository>();
        ArrayList<RemoteRepository> resultingRepos = new ArrayList<RemoteRepository>();
        for (RemoteRepository r : remoteRepos) {
            naming.put(r.getId(), r);
            RemoteRepository rProxy = new RemoteRepository.Builder(r).setProxy(this.m_proxySelector.getProxy(r)).build();
            resultingRepos.add(rProxy);
            RemoteRepository mirror = this.m_mirrorSelector.getMirror(r);
            if (mirror == null) continue;
            String key = mirror.getId();
            naming.put(key, mirror);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            List mirrored = (List)map.get(key);
            mirrored.add(r.getId());
        }
        for (String mirrorId : map.keySet()) {
            RemoteRepository mirror = (RemoteRepository)naming.get(mirrorId);
            ArrayList<RemoteRepository> mirroredRepos = new ArrayList<RemoteRepository>();
            for (String rep : (List)map.get(mirrorId)) {
                mirroredRepos.add((RemoteRepository)naming.get(rep));
            }
            mirror = new RemoteRepository.Builder(mirror).setMirroredRepositories(mirroredRepos).setProxy(this.m_proxySelector.getProxy(mirror)).build();
            resultingRepos.removeAll(mirroredRepos);
            resultingRepos.add(0, mirror);
        }
        remoteRepos.clear();
        remoteRepos.addAll(resultingRepos);
    }

    List<LocalRepository> selectDefaultRepositories() {
        ArrayList<LocalRepository> list = new ArrayList<LocalRepository>();
        List<Object> urls = Collections.emptyList();
        try {
            urls = this.m_config.getDefaultRepositories();
        }
        catch (MalformedURLException exc) {
            LOG.error("invalid repository URLs", (Throwable)exc);
        }
        for (MavenRepositoryURL mavenRepositoryURL : urls) {
            if (mavenRepositoryURL.isMulti()) {
                this.addLocalSubDirs(list, mavenRepositoryURL.getFile());
                continue;
            }
            this.addLocalRepo(list, mavenRepositoryURL);
        }
        return list;
    }

    private void addSubDirs(List<RemoteRepository> list, File parentDir) {
        if (!parentDir.isDirectory()) {
            LOG.debug("Repository marked with @multi does not resolve to a directory: " + parentDir);
            return;
        }
        for (File repo : parentDir.listFiles()) {
            if (!repo.isDirectory()) continue;
            try {
                String repoURI = repo.toURI().toString() + "@id=" + repo.getName();
                LOG.debug("Adding repo from inside multi dir: " + repoURI);
                this.addRepo(list, new MavenRepositoryURL(repoURI));
            }
            catch (MalformedURLException e) {
                LOG.error("Error resolving repo url of a multi repo " + repo.toURI());
            }
        }
    }

    private void addRepo(List<RemoteRepository> list, MavenRepositoryURL repo) {
        String snapshotsChecksumPolicy;
        String snapshotsUpdatePolicy;
        String releasesChecksumPolicy;
        String releasesUpdatePolicy = repo.getReleasesUpdatePolicy();
        if (releasesUpdatePolicy == null || releasesUpdatePolicy.isEmpty()) {
            releasesUpdatePolicy = new RepositoryPolicy().getUpdatePolicy();
        }
        if ((releasesChecksumPolicy = repo.getReleasesChecksumPolicy()) == null || releasesChecksumPolicy.isEmpty()) {
            releasesChecksumPolicy = new RepositoryPolicy().getChecksumPolicy();
        }
        if ((snapshotsUpdatePolicy = repo.getSnapshotsUpdatePolicy()) == null || snapshotsUpdatePolicy.isEmpty()) {
            snapshotsUpdatePolicy = new RepositoryPolicy().getUpdatePolicy();
        }
        if ((snapshotsChecksumPolicy = repo.getSnapshotsChecksumPolicy()) == null || snapshotsChecksumPolicy.isEmpty()) {
            snapshotsChecksumPolicy = new RepositoryPolicy().getChecksumPolicy();
        }
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repo.getId(), REPO_TYPE, repo.getURL().toExternalForm());
        RepositoryPolicy releasePolicy = new RepositoryPolicy(repo.isReleasesEnabled(), releasesUpdatePolicy, releasesChecksumPolicy);
        builder.setReleasePolicy(releasePolicy);
        RepositoryPolicy snapshotPolicy = new RepositoryPolicy(repo.isSnapshotsEnabled(), snapshotsUpdatePolicy, snapshotsChecksumPolicy);
        builder.setSnapshotPolicy(snapshotPolicy);
        Authentication authentication = this.getAuthentication(repo.getId());
        if (authentication != null) {
            builder.setAuthentication(authentication);
        }
        list.add(builder.build());
    }

    private void addLocalSubDirs(List<LocalRepository> list, File parentDir) {
        if (!parentDir.isDirectory()) {
            LOG.debug("Repository marked with @multi does not resolve to a directory: " + parentDir);
            return;
        }
        for (File repo : parentDir.listFiles()) {
            if (!repo.isDirectory()) continue;
            try {
                String repoURI = repo.toURI().toString() + "@id=" + repo.getName();
                LOG.debug("Adding repo from inside multi dir: " + repoURI);
                this.addLocalRepo(list, new MavenRepositoryURL(repoURI));
            }
            catch (MalformedURLException e) {
                LOG.error("Error resolving repo url of a multi repo " + repo.toURI());
            }
        }
    }

    private void addLocalRepo(List<LocalRepository> list, MavenRepositoryURL repo) {
        if (repo.getFile() != null) {
            LocalRepository local = new LocalRepository(repo.getFile(), "simple");
            list.add(local);
        }
    }

    public InputStream resolve(String groupId, String artifactId, String classifier, String extension, String version) throws IOException {
        File resolved = this.resolveFile(groupId, artifactId, classifier, extension, version);
        return new FileInputStream(resolved);
    }

    public File resolveFile(String groupId, String artifactId, String classifier, String extension, String version) throws IOException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
        return this.resolveFile(artifact);
    }

    @Override
    public File download(String url) throws IOException {
        Parser parser = Parser.parsePathWithSchemePrefix(url);
        return this.resolveFile(parser.getGroup(), parser.getArtifact(), parser.getClassifier(), parser.getType(), parser.getVersion(), parser.getRepositoryURL());
    }

    @Override
    public File resolveFile(Artifact artifact) throws IOException {
        return this.resolveFile(artifact, null);
    }

    public File resolveFile(String groupId, String artifactId, String classifier, String extension, String version, MavenRepositoryURL repositoryURL) throws IOException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
        return this.resolveFile(artifact, repositoryURL);
    }

    public File resolveFile(Artifact artifact, MavenRepositoryURL repositoryURL) throws IOException {
        List<LocalRepository> defaultRepos = this.selectDefaultRepositories();
        List<RemoteRepository> remoteRepos = this.selectRepositories();
        if (repositoryURL != null) {
            this.addRepo(remoteRepos, repositoryURL);
        }
        this.assignProxyAndMirrors(remoteRepos);
        File resolved = this.resolve(defaultRepos, remoteRepos, artifact);
        LOG.debug("Resolved ({}) as {}", (Object)artifact.toString(), (Object)resolved.getAbsolutePath());
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File resolve(List<LocalRepository> defaultRepos, List<RemoteRepository> remoteRepos, Artifact artifact) throws IOException {
        if (artifact.getExtension().isEmpty()) {
            artifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), "jar", artifact.getVersion());
        }
        try {
            VersionConstraint vc = new GenericVersionScheme().parseVersionConstraint(artifact.getVersion());
            if (vc.getVersion() != null && !vc.getVersion().toString().endsWith("SNAPSHOT")) {
                for (LocalRepository repo : defaultRepos) {
                    DefaultRepositorySystemSession session = this.newSession(repo);
                    try {
                        File file = this.m_repoSystem.resolveArtifact(session, new ArtifactRequest(artifact, null, null)).getArtifact().getFile();
                        return file;
                    }
                    catch (ArtifactResolutionException e) {}
                    continue;
                    finally {
                        this.releaseSession(session);
                    }
                }
            }
        }
        catch (InvalidVersionSpecificationException e2) {
            // empty catch block
        }
        DefaultRepositorySystemSession session = this.newSession(null);
        try {
            artifact = this.resolveLatestVersionRange(session, remoteRepos, artifact);
            ArtifactResult result = this.m_repoSystem.resolveArtifact(session, new ArtifactRequest(artifact, remoteRepos, null));
            File resolved = result.getArtifact().getFile();
            LOG.debug("Resolved ({}) as {}", (Object)artifact.toString(), (Object)resolved.getAbsolutePath());
            File file = resolved;
            return file;
        }
        catch (ArtifactResolutionException e) {
            LOG.warn("Error resolving artifact" + artifact.toString() + ":" + e.getMessage(), (Throwable)e);
            throw new IOException("Error resolving artifact " + artifact.toString() + ": " + e.getMessage());
        }
        catch (RepositoryException e) {
            throw new IOException("Error resolving artifact " + artifact.toString(), e);
        }
        finally {
            this.releaseSession(session);
        }
    }

    private Artifact resolveLatestVersionRange(RepositorySystemSession session, List<RemoteRepository> remoteRepos, Artifact artifact) throws VersionRangeResolutionException {
        VersionRangeResult versionResult;
        if (artifact.getVersion().equals("LATEST")) {
            artifact = artifact.setVersion(LATEST_VERSION_RANGE);
        }
        if ((versionResult = this.m_repoSystem.resolveVersionRange(session, new VersionRangeRequest(artifact, remoteRepos, null))) != null) {
            Version v = versionResult.getHighestVersion();
            if (v != null) {
                artifact = artifact.setVersion(v.toString());
            } else {
                throw new VersionRangeResolutionException(versionResult, "No highest version found for " + artifact);
            }
        }
        return artifact;
    }

    public DefaultRepositorySystemSession newSession() {
        return this.newSession(null);
    }

    private DefaultRepositorySystemSession newSession(LocalRepository repo) {
        if (repo == null) {
            if (this.localRepository == null) {
                File local = this.m_config.getLocalRepository() != null ? this.m_config.getLocalRepository().getFile() : new File(System.getProperty("user.home"), ".m2/repository");
                this.localRepository = new LocalRepository(local);
            }
            repo = this.localRepository;
        }
        Deque deque = (Deque)this.sessions.get(repo);
        DefaultRepositorySystemSession session = null;
        if (deque != null) {
            session = (DefaultRepositorySystemSession)deque.pollFirst();
        }
        if (session == null) {
            session = this.createSession(repo);
        }
        return session;
    }

    private void releaseSession(DefaultRepositorySystemSession session) {
        LocalRepository repo = session.getLocalRepository();
        Deque deque = (Deque)this.sessions.get(repo);
        if (deque == null) {
            this.sessions.putIfAbsent(repo, new ConcurrentLinkedDeque());
            deque = (Deque)this.sessions.get(repo);
        }
        deque.add(session);
    }

    @Override
    public RepositorySystemSession createSession() {
        return this.createSession(null);
    }

    public DefaultRepositorySystemSession createSession(LocalRepository repo) {
        String checksumPolicy;
        DefaultRepositorySystemSession session = AetherBasedResolver.newRepositorySystemSession();
        if (repo != null) {
            session.setLocalRepositoryManager(this.m_repoSystem.newLocalRepositoryManager(session, repo));
        } else {
            File local = this.m_config.getLocalRepository() != null ? this.m_config.getLocalRepository().getFile() : new File(System.getProperty("user.home"), ".m2/repository");
            LocalRepository localRepo = new LocalRepository(local);
            session.setLocalRepositoryManager(this.m_repoSystem.newLocalRepositoryManager(session, localRepo));
        }
        session.setMirrorSelector(this.m_mirrorSelector);
        session.setProxySelector(this.m_proxySelector);
        String updatePolicy = this.m_config.getGlobalUpdatePolicy();
        if (null != updatePolicy) {
            session.setUpdatePolicy(updatePolicy);
        }
        if (null != (checksumPolicy = this.m_config.getGlobalChecksumPolicy())) {
            session.setChecksumPolicy(checksumPolicy);
        }
        for (Server server : this.m_settings.getServers()) {
            if (server.getConfiguration() == null || ((Xpp3Dom)server.getConfiguration()).getChild("httpHeaders") == null) continue;
            this.addServerConfig(session, server);
        }
        session.setOffline(this.m_config.isOffline());
        return session;
    }

    private static DefaultRepositorySystemSession newRepositorySystemSession() {
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
        FatArtifactTraverser depTraverser = new FatArtifactTraverser();
        session.setDependencyTraverser(depTraverser);
        ClassicDependencyManager depManager = new ClassicDependencyManager();
        session.setDependencyManager(depManager);
        AndDependencySelector depFilter = new AndDependencySelector(new ScopeDependencySelector("test", "provided"), new OptionalDependencySelector(), new ExclusionDependencySelector());
        session.setDependencySelector(depFilter);
        ConflictResolver transformer = new ConflictResolver(new NearestVersionSelector(), new JavaScopeSelector(), new SimpleOptionalitySelector(), new JavaScopeDeriver());
        new ChainedDependencyGraphTransformer(transformer, new JavaDependencyContextRefiner());
        session.setDependencyGraphTransformer(transformer);
        DefaultArtifactTypeRegistry stereotypes = new DefaultArtifactTypeRegistry();
        stereotypes.add(new DefaultArtifactType("pom"));
        stereotypes.add(new DefaultArtifactType("maven-plugin", "jar", "", "java"));
        stereotypes.add(new DefaultArtifactType("jar", "jar", "", "java"));
        stereotypes.add(new DefaultArtifactType("ejb", "jar", "", "java"));
        stereotypes.add(new DefaultArtifactType("ejb-client", "jar", "client", "java"));
        stereotypes.add(new DefaultArtifactType("test-jar", "jar", "tests", "java"));
        stereotypes.add(new DefaultArtifactType("javadoc", "jar", "javadoc", "java"));
        stereotypes.add(new DefaultArtifactType("java-source", "jar", "sources", "java", false, false));
        stereotypes.add(new DefaultArtifactType("war", "war", "", "java", false, true));
        stereotypes.add(new DefaultArtifactType("ear", "ear", "", "java", false, true));
        stereotypes.add(new DefaultArtifactType("rar", "rar", "", "java", false, true));
        stereotypes.add(new DefaultArtifactType("par", "par", "", "java", false, true));
        session.setArtifactTypeRegistry(stereotypes);
        session.setArtifactDescriptorPolicy(new SimpleArtifactDescriptorPolicy(true, true));
        Properties sysProps = (Properties)System.getProperties().clone();
        session.setSystemProperties(sysProps);
        session.setConfigProperties(sysProps);
        return session;
    }

    private void addServerConfig(DefaultRepositorySystemSession session, Server server) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        Xpp3Dom httpHeaders = configuration.getChild("httpHeaders");
        for (Xpp3Dom httpHeader : httpHeaders.getChildren("httpHeader")) {
            Xpp3Dom name = httpHeader.getChild("name");
            String headerName = name.getValue();
            Xpp3Dom value = httpHeader.getChild("value");
            String headerValue = value.getValue();
            headers.put(headerName, headerValue);
        }
        session.setConfigProperty(String.format("%s.%s", "aether.connector.http.headers", server.getId()), headers);
    }

    private Authentication getAuthentication(org.apache.maven.settings.Proxy proxy) {
        if (proxy.getUsername() != null) {
            return new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
        }
        return null;
    }

    private Authentication getAuthentication(String repoId) {
        Server server = this.m_settings.getServer(repoId);
        if (server != null && server.getUsername() != null) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            return authBuilder.build();
        }
        return null;
    }

    @Override
    public DependencyNode collectDependenciesForJar(File jarFile, Filter<Dependency> excludeDependencyFilter) throws RepositoryException, IOException {
        PomDetails pomDetails = this.findPomFile(jarFile);
        if (pomDetails == null || !pomDetails.isValid()) {
            throw new IllegalArgumentException("No pom.xml file could be found inside the jar file: " + jarFile);
        }
        return this.collectDependencies(pomDetails, excludeDependencyFilter);
    }

    @Override
    public File getLocalRepository() {
        return this.localRepository == null ? null : this.localRepository.getBasedir();
    }

    public DependencyNode collectDependencies(PomDetails pomDetails, Filter<Dependency> excludeDependencyFilter) throws IOException, RepositoryException {
        Model model = pomDetails.getModel();
        return this.collectDependenciesFromPom(pomDetails.getFile(), model, excludeDependencyFilter);
    }

    protected DependencyNode collectDependenciesFromPom(File rootPom, Model model, Filter<Dependency> excludeDependencyFilter) throws RepositoryException, IOException {
        Map<String, String> props = Collections.singletonMap("localPath", rootPom.toString());
        String groupId = model.getGroupId();
        String artifactId = model.getArtifactId();
        String pomVersion = model.getVersion();
        String packaging = "pom";
        if (groupId == null || artifactId == null || pomVersion == null) {
            throw new IllegalArgumentException("Pomegranate pom.xml has missing groupId:artifactId:version " + groupId + ":" + artifactId + ":" + pomVersion);
        }
        DefaultArtifact root = new DefaultArtifact(groupId, artifactId, null, packaging, pomVersion, props, rootPom);
        return this.collectDependencies(root, pomVersion, excludeDependencyFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DependencyNode collectDependencies(Artifact root, String pomVersion, Filter<Dependency> excludeDependencyFilter) throws RepositoryException, IOException {
        final DefaultRepositorySystemSession session = this.newSession();
        try {
            List<RemoteRepository> repos = this.selectRepositories();
            this.assignProxyAndMirrors(repos);
            ArtifactDescriptorResult artifactDescriptorResult = this.m_repoSystem.readArtifactDescriptor(session, new ArtifactDescriptorRequest(root, repos, null));
            repos.addAll(artifactDescriptorResult.getRepositories());
            Dependency rootDependency = new Dependency(root, null);
            List<Dependency> dependencies = artifactDescriptorResult.getDependencies();
            DefaultDependencyNode rootNode = new DefaultDependencyNode(rootDependency);
            GenericVersionScheme versionScheme = new GenericVersionScheme();
            rootNode.setVersion(versionScheme.parseVersion(pomVersion));
            rootNode.setVersionConstraint(versionScheme.parseVersionConstraint(pomVersion));
            DependencyNode pomNode = rootNode;
            final Filter shouldExclude = Filters.or(Arrays.asList(DependencyFilters.testScopeFilter, excludeDependencyFilter));
            AndDependencySelector dependencySelector = new AndDependencySelector(new ScopeDependencySelector("test"), new ExclusionDependencySelector(), new DependencySelector(){

                @Override
                public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
                    return this;
                }

                @Override
                public boolean selectDependency(Dependency dependency) {
                    try {
                        return !DependencyFilters.matches(dependency, (Filter<Dependency>)shouldExclude);
                    }
                    catch (Exception e) {
                        AetherBasedResolver.this.failedToMakeDependencyTree(dependency, e);
                        return false;
                    }
                }
            });
            session.setDependencySelector(dependencySelector);
            for (Dependency dependency : dependencies) {
                DependencyNode node = this.resolveDependencies(session, repos, pomNode, dependency, (Filter<Dependency>)shouldExclude);
                if (node == null) continue;
                pomNode.getChildren().add(node);
            }
            DependencyGraphTransformationContext tranformContext = new DependencyGraphTransformationContext(){
                Map<Object, Object> map = new HashMap<Object, Object>();

                @Override
                public RepositorySystemSession getSession() {
                    return session;
                }

                @Override
                public Object get(Object key) {
                    return this.map.get(key);
                }

                @Override
                public Object put(Object key, Object value) {
                    return this.map.put(key, value);
                }
            };
            DependencyGraphTransformer transformer = new ReplaceConflictingVersionResolver();
            pomNode = transformer.transformGraph(pomNode, tranformContext);
            transformer = new DuplicateTransformer();
            DependencyNode dependencyNode = pomNode = transformer.transformGraph(pomNode, tranformContext);
            return dependencyNode;
        }
        finally {
            this.releaseSession(session);
        }
    }

    public PomDetails findPomFile(File jar) throws IOException {
        JarFile jarFile = new JarFile(jar);
        File file = null;
        Properties properties = null;
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            InputStream in;
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.matches("META-INF/maven/.*/.*/pom.xml")) {
                in = jarFile.getInputStream(entry);
                file = File.createTempFile("fabric-pomegranate-", ".pom.xml");
                IOHelpers.writeTo((File)file, (InputStream)in);
            } else if (name.matches("META-INF/maven/.*/.*/pom.properties")) {
                in = jarFile.getInputStream(entry);
                properties = new Properties();
                properties.load(in);
            }
            if (file == null || properties == null) continue;
            break;
        }
        return new PomDetails(file, properties);
    }

    protected DependencyNode resolveDependencies(RepositorySystemSession session, List<RemoteRepository> repos, DependencyNode pomNode, Dependency dependency, final Filter<Dependency> shouldExclude) throws FailedToResolveDependency {
        if (!DependencyFilters.matches(dependency, shouldExclude)) {
            CollectRequest cr = new CollectRequest(dependency, repos);
            try {
                DependencyNode node = this.m_repoSystem.collectDependencies(session, cr).getRoot();
                DependencyFilter filter = new DependencyFilter(){

                    @Override
                    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                        return !DependencyFilters.matches(node, (Filter<Dependency>)shouldExclude);
                    }
                };
                DependencyRequest request = new DependencyRequest(cr, filter);
                this.m_repoSystem.resolveDependencies(session, request);
                return node;
            }
            catch (DependencyCollectionException | DependencyResolutionException e) {
                this.handleDependencyResolveFailure(pomNode, dependency, e);
            }
        }
        return null;
    }

    protected void handleDependencyResolveFailure(DependencyNode pomNode, Dependency dependency, Exception e) throws FailedToResolveDependency {
        FailedToResolveDependency exception = new FailedToResolveDependency(dependency, e);
        if (this.throwExceptionsOnResolveDependencyFailure) {
            throw exception;
        }
        LOGGER.warn(exception.getMessage(), (Throwable)e);
        DefaultDependencyNode node = new DefaultDependencyNode(dependency);
        pomNode.getChildren().add(node);
    }

    protected void failedToMakeDependencyTree(Object dependency, Exception e) {
        LOGGER.warn("Failed to make Dependency for " + dependency + ". " + e, (Throwable)e);
    }
}

