/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.url.internal;

import io.fabric8.common.util.NullArgumentException;
import io.fabric8.maven.MavenResolver;
import io.fabric8.maven.util.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends URLConnection {
    private static final Logger LOG = LoggerFactory.getLogger(Connection.class);
    private MavenResolver m_resolver;

    public Connection(URL url, MavenResolver resolver) throws MalformedURLException {
        super(url);
        NullArgumentException.validateNotNull((Object)url, (String)"URL cannot be null");
        NullArgumentException.validateNotNull((Object)resolver, (String)"Service configuration");
        this.m_resolver = resolver;
        new Parser(url.getPath());
    }

    @Override
    public void connect() {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        LOG.debug("Resolving [" + this.url.toExternalForm() + "]");
        File file = this.m_resolver.download(this.url.toExternalForm());
        return new FileInputStream(file);
    }
}

