/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.internal;

import io.fabric8.agent.resolver.ResourceUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Overrides {
    protected static final String OVERRIDE_RANGE = "range";
    private static final Logger LOGGER = LoggerFactory.getLogger(Overrides.class);

    private Overrides() {
    }

    public static <T extends Resource> void override(Map<String, T> resources, Collection<String> overrides) {
        for (Clause override : Parser.parseClauses(overrides.toArray(new String[overrides.size()]))) {
            String url = override.getName();
            String vr = override.getAttribute(OVERRIDE_RANGE);
            Resource over = (Resource)resources.get(url);
            if (over == null) continue;
            for (String uri : new ArrayList<String>(resources.keySet())) {
                VersionRange range;
                Resource res = (Resource)resources.get(uri);
                if (!ResourceUtils.getSymbolicName(res).equals(ResourceUtils.getSymbolicName(over))) continue;
                if (vr == null) {
                    Version v1 = ResourceUtils.getVersion(res);
                    Version v2 = new Version(v1.getMajor(), v1.getMinor() + 1, 0);
                    range = new VersionRange(false, v1, v2, true);
                } else {
                    range = VersionRange.parseVersionRange(vr);
                }
                if (!range.contains(ResourceUtils.getVersion(over)) || ResourceUtils.getVersion(res).compareTo(ResourceUtils.getVersion(over)) >= 0) continue;
                resources.put(uri, over);
            }
        }
    }

    public static Set<String> loadOverrides(String overridesUrl) {
        HashSet<String> overrides;
        block15: {
            overrides = new HashSet<String>();
            try {
                if (overridesUrl == null) break block15;
                try (InputStream is = new URL(overridesUrl).openStream();){
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                        overrides.add(line);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("Unable to load overrides bundles list", (Throwable)e);
            }
        }
        return overrides;
    }

    public static String extractUrl(String override) {
        Clause[] cs = Parser.parseClauses(new String[]{override});
        if (cs.length != 1) {
            throw new IllegalStateException("Override contains more than one clause: " + override);
        }
        return cs[0].getName();
    }
}

