/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.model;

import io.fabric8.agent.internal.XmlUtils;
import io.fabric8.agent.model.BundleInfo;
import io.fabric8.agent.model.Capability;
import io.fabric8.agent.model.Conditional;
import io.fabric8.agent.model.Config;
import io.fabric8.agent.model.ConfigFile;
import io.fabric8.agent.model.Content;
import io.fabric8.agent.model.Dependency;
import io.fabric8.agent.model.Feature;
import io.fabric8.agent.model.Features;
import io.fabric8.agent.model.Requirement;
import io.fabric8.agent.model.ScopeFilter;
import io.fabric8.agent.model.Scoping;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public final class JaxbUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaxbUtil.class);
    private static final JAXBContext FEATURES_CONTEXT;
    private static final Map<String, Schema> SCHEMAS;

    private JaxbUtil() {
    }

    public static void marshal(Features features, OutputStream out) throws JAXBException {
        Marshaller marshaller = FEATURES_CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)features, out);
    }

    public static void marshal(Features features, Writer out) throws JAXBException {
        Marshaller marshaller = FEATURES_CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)features, out);
    }

    public static Features unmarshal(String uri, boolean validate) {
        if (validate) {
            return JaxbUtil.unmarshalValidate(uri, null);
        }
        return JaxbUtil.unmarshalNoValidate(uri, null);
    }

    public static Features unmarshal(String uri, InputStream stream, boolean validate) {
        if (validate) {
            return JaxbUtil.unmarshalValidate(uri, stream);
        }
        return JaxbUtil.unmarshalNoValidate(uri, stream);
    }

    private static Features unmarshalValidate(String uri, InputStream stream) {
        try {
            Document doc;
            if (stream != null) {
                doc = XmlUtils.parse(stream);
                doc.setDocumentURI(uri);
            } else {
                doc = XmlUtils.parse(uri);
            }
            String nsuri = doc.getDocumentElement().getNamespaceURI();
            if (nsuri == null) {
                LOGGER.warn("Old style feature file without namespace found (URI: {}). This format is deprecated and support for it will soon be removed", (Object)uri);
            } else {
                Schema schema = JaxbUtil.getSchema(nsuri);
                try {
                    schema.newValidator().validate(new DOMSource(doc));
                }
                catch (SAXException e) {
                    throw new IllegalArgumentException("Unable to validate " + uri, e);
                }
            }
            JaxbUtil.fixDom(doc, doc.getDocumentElement());
            Unmarshaller unmarshaller = FEATURES_CONTEXT.createUnmarshaller();
            return (Features)unmarshaller.unmarshal((Source)new DOMSource(doc));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + uri, e);
        }
    }

    private static Schema getSchema(String namespace) throws SAXException {
        Schema schema = SCHEMAS.get(namespace);
        if (schema == null) {
            String schemaLocation;
            switch (namespace) {
                case "http://karaf.apache.org/xmlns/features/v1.0.0": {
                    schemaLocation = "/org/apache/karaf/features/karaf-features-1.0.0.xsd";
                    break;
                }
                case "http://karaf.apache.org/xmlns/features/v1.1.0": {
                    schemaLocation = "/org/apache/karaf/features/karaf-features-1.1.0.xsd";
                    break;
                }
                case "http://karaf.apache.org/xmlns/features/v1.2.0": {
                    schemaLocation = "/org/apache/karaf/features/karaf-features-1.2.0.xsd";
                    break;
                }
                case "http://karaf.apache.org/xmlns/features/v1.3.0": {
                    schemaLocation = "/org/apache/karaf/features/karaf-features-1.3.0.xsd";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported namespace: " + namespace);
                }
            }
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = JaxbUtil.class.getResource(schemaLocation);
            if (url == null) {
                throw new IllegalStateException("Could not find resource: " + schemaLocation);
            }
            schema = factory.newSchema(new StreamSource(url.toExternalForm()));
            SCHEMAS.put(namespace, schema);
        }
        return schema;
    }

    private static void fixDom(Document doc, Node node) {
        if (node.getNodeType() == 1) {
            if (!"http://karaf.apache.org/xmlns/features/v1.3.0".equals(node.getNamespaceURI())) {
                doc.renameNode(node, "http://karaf.apache.org/xmlns/features/v1.3.0", node.getLocalName());
            }
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                JaxbUtil.fixDom(doc, children.item(i));
            }
        }
    }

    private static Features unmarshalNoValidate(String uri, InputStream stream) {
        try {
            Unmarshaller unmarshaller = FEATURES_CONTEXT.createUnmarshaller();
            NoSourceAndNamespaceFilter xmlFilter = new NoSourceAndNamespaceFilter(XmlUtils.xmlReader());
            xmlFilter.setContentHandler((ContentHandler)unmarshaller.getUnmarshallerHandler());
            InputSource is = new InputSource(uri);
            if (stream != null) {
                is.setByteStream(stream);
            }
            SAXSource source = new SAXSource(xmlFilter, new InputSource(uri));
            return (Features)unmarshaller.unmarshal((Source)source);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + uri, e);
        }
    }

    static {
        SCHEMAS = new ConcurrentHashMap<String, Schema>();
        try {
            FEATURES_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{BundleInfo.class, Capability.class, Conditional.class, Config.class, ConfigFile.class, Content.class, Dependency.class, Feature.class, Features.class, Requirement.class, ScopeFilter.class, Scoping.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static class NoSourceAndNamespaceFilter
    extends XMLFilterImpl {
        private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));

        public NoSourceAndNamespaceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return EMPTY_INPUT_SOURCE;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement("http://karaf.apache.org/xmlns/features/v1.3.0", localName, qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement("http://karaf.apache.org/xmlns/features/v1.3.0", localName, qName);
        }
    }
}

