/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.region;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.Downloader;
import io.fabric8.agent.download.StreamProvider;
import io.fabric8.agent.internal.MapUtils;
import io.fabric8.agent.model.BundleInfo;
import io.fabric8.agent.model.Feature;
import io.fabric8.agent.region.Subsystem;
import io.fabric8.agent.region.SubsystemResolveContext;
import io.fabric8.agent.resolver.CapabilityImpl;
import io.fabric8.agent.resolver.CapabilitySet;
import io.fabric8.agent.resolver.ResourceBuilder;
import io.fabric8.agent.resolver.ResourceImpl;
import io.fabric8.agent.resolver.ResourceUtils;
import io.fabric8.agent.resolver.SimpleFilter;
import io.fabric8.agent.resolver.Slf4jResolverLog;
import io.fabric8.agent.service.MetadataBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.resolver.ResolverImpl;
import org.apache.felix.utils.collections.DictionaryAsMap;
import org.eclipse.equinox.internal.region.StandardRegionDigraph;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubsystemResolver.class);
    private DownloadManager manager;
    private RegionDigraph digraph;
    private Subsystem root;
    private Map<Resource, List<Wire>> wiring;
    private ResourceImpl environmentResource;
    private Map<String, String> flatSubsystemsMap;
    private Map<String, Set<Resource>> bundlesPerRegions;
    private Map<Resource, String> bundles;
    private Map<String, Set<Resource>> featuresPerRegions;
    private Map<Resource, String> features;
    private RegionDigraph flatDigraph;
    private Map<String, Map<String, BundleInfo>> bundleInfos;

    public SubsystemResolver(DownloadManager manager) {
        this.manager = manager;
    }

    public void prepare(Collection<Feature> allFeatures, Map<String, Set<String>> requirements, Map<String, Set<BundleRevision>> system) throws Exception {
        for (Map.Entry<String, Set<String>> entry : requirements.entrySet()) {
            String[] parts = entry.getKey().split("/");
            if (this.root == null) {
                this.root = new Subsystem(parts[0]);
            } else if (!this.root.getName().equals(parts[0])) {
                throw new IllegalArgumentException("Can not use multiple roots: " + this.root.getName() + ", " + parts[0]);
            }
            Subsystem ss = this.root;
            for (int i = 1; i < parts.length; ++i) {
                ss = this.getOrCreateChild(ss, parts[i]);
            }
            for (String requirement : entry.getValue()) {
                ss.require(requirement);
            }
        }
        if (this.root == null) {
            return;
        }
        this.root.build(allFeatures);
        BundleRevision sysBundleRev = null;
        boolean hasEeCap = false;
        for (Map.Entry<String, Set<BundleRevision>> entry : system.entrySet()) {
            Subsystem ss = null;
            String[] parts = entry.getKey().split("/");
            String path = parts[0];
            if (path.equals(this.root.getName())) {
                ss = this.root;
            }
            for (int i = 1; ss != null && i < parts.length; ss = ss.getChild(path), ++i) {
                path = path + "/" + parts[i];
            }
            if (ss == null) continue;
            ResourceImpl dummy = new ResourceImpl("dummy", "dummy", Version.emptyVersion);
            for (BundleRevision res : entry.getValue()) {
                DictionaryAsMap<String, String> headers = new DictionaryAsMap<String, String>(res.getBundle().getHeaders());
                ResourceImpl tmp = ResourceBuilder.build(res.getBundle().getLocation(), headers);
                for (Capability cap : tmp.getCapabilities("osgi.service")) {
                    dummy.addCapability(new CapabilityImpl(dummy, cap.getNamespace(), cap.getDirectives(), cap.getAttributes()));
                }
                ss.addSystemResource((Resource)res);
                for (Capability cap : res.getCapabilities(null)) {
                    hasEeCap |= cap.getNamespace().equals("osgi.ee");
                }
                if (res.getBundle().getBundleId() != 0L) continue;
                sysBundleRev = res;
            }
            ss.addSystemResource(dummy);
        }
        if (!hasEeCap && sysBundleRev != null) {
            String provideCaps = (String)sysBundleRev.getBundle().getHeaders().get("Provide-Capability");
            this.environmentResource = new ResourceImpl("environment", "karaf.environment", Version.emptyVersion);
            this.environmentResource.addCapabilities(ResourceBuilder.parseCapability(this.environmentResource, provideCaps));
            this.root.addSystemResource(this.environmentResource);
        }
    }

    public Set<String> collectPrerequisites() throws Exception {
        if (this.root == null) {
            return Collections.emptySet();
        }
        return this.root.collectPrerequisites();
    }

    public Map<Resource, List<Wire>> resolve(MetadataBuilder builder, Set<String> overrides, String featureResolutionRange, Repository globalRepository) throws Exception {
        if (this.root == null) {
            return Collections.emptyMap();
        }
        this.root.downloadBundles(this.manager, builder, overrides, featureResolutionRange);
        this.digraph = new StandardRegionDigraph(null, null);
        this.populateDigraph(this.digraph, this.root);
        ResolverImpl resolver = new ResolverImpl(new Slf4jResolverLog(LOGGER));
        Downloader downloader = this.manager.createDownloader();
        this.wiring = resolver.resolve(new SubsystemResolveContext(this.root, this.digraph, globalRepository, downloader));
        downloader.await();
        if (this.environmentResource != null) {
            for (List<Wire> wires : this.wiring.values()) {
                Iterator<Wire> iterator = wires.iterator();
                while (iterator.hasNext()) {
                    Wire wire = iterator.next();
                    if (wire.getProvider() != this.environmentResource) continue;
                    iterator.remove();
                }
            }
        }
        this.associateFragments();
        return this.wiring;
    }

    public Map<String, Map<String, BundleInfo>> getBundleInfos() {
        if (this.bundleInfos == null) {
            this.bundleInfos = new HashMap<String, Map<String, BundleInfo>>();
            this.addBundleInfos(this.root);
        }
        return this.bundleInfos;
    }

    private void addBundleInfos(Subsystem subsystem) {
        if (subsystem != null) {
            String region = this.getFlatSubsystemsMap().get(subsystem.getName());
            Map<String, BundleInfo> bis = this.bundleInfos.get(region);
            if (bis == null) {
                bis = new HashMap<String, BundleInfo>();
                this.bundleInfos.put(region, bis);
            }
            bis.putAll(subsystem.getBundleInfos());
            for (Subsystem child : subsystem.getChildren()) {
                this.addBundleInfos(child);
            }
        }
    }

    public Map<String, StreamProvider> getProviders() {
        return this.manager.getProviders();
    }

    public Map<Resource, List<Wire>> getWiring() {
        return this.wiring;
    }

    public RegionDigraph getFlatDigraph() throws BundleException, InvalidSyntaxException {
        if (this.flatDigraph == null) {
            this.flatDigraph = new StandardRegionDigraph(null, null);
            Map<String, String> flats = this.getFlatSubsystemsMap();
            for (Region r : this.digraph.getRegions()) {
                if (!r.getName().equals(flats.get(r.getName()))) continue;
                this.flatDigraph.createRegion(r.getName());
            }
            for (Region r : this.digraph.getRegions()) {
                for (RegionDigraph.FilteredRegion fr : this.digraph.getEdges(r)) {
                    String rt = flats.get(r.getName());
                    String rh = flats.get(fr.getRegion().getName());
                    if (rh.equals(rt)) continue;
                    Region tail = this.flatDigraph.getRegion(rt);
                    Region head = this.flatDigraph.getRegion(rh);
                    RegionFilterBuilder rfb = this.flatDigraph.createRegionFilterBuilder();
                    for (Map.Entry<String, Collection<String>> entry : fr.getFilter().getSharingPolicy().entrySet()) {
                        if ("osgi.identity".equals(entry.getKey())) continue;
                        for (String f : entry.getValue()) {
                            rfb.allow(entry.getKey(), f);
                        }
                    }
                    this.flatDigraph.connect(tail, rfb.build(), head);
                }
            }
        }
        return this.flatDigraph;
    }

    public Map<String, String> getFlatSubsystemsMap() {
        if (this.flatSubsystemsMap == null) {
            this.flatSubsystemsMap = new HashMap<String, String>();
            this.findSubsystemsToFlatten(this.root, this.flatSubsystemsMap);
        }
        return this.flatSubsystemsMap;
    }

    public Map<String, Set<Resource>> getBundlesPerRegions() {
        if (this.bundlesPerRegions == null) {
            this.bundlesPerRegions = MapUtils.invert(this.getBundles());
        }
        return this.bundlesPerRegions;
    }

    public Map<Resource, String> getBundles() {
        if (this.bundles == null) {
            String filter = String.format("(&(%s=*)(|(%s=%s)(%s=%s)))", "osgi.identity", "type", "osgi.bundle", "type", "osgi.fragment");
            SimpleFilter sf = SimpleFilter.parse(filter);
            this.bundles = this.getResourceMapping(sf);
        }
        return this.bundles;
    }

    public Map<String, Set<Resource>> getFeaturesPerRegions() {
        if (this.featuresPerRegions == null) {
            this.featuresPerRegions = MapUtils.invert(this.getFeatures());
        }
        return this.featuresPerRegions;
    }

    public Map<Resource, String> getFeatures() {
        if (this.features == null) {
            SimpleFilter sf = this.createFilter("osgi.identity", "*", "type", "karaf.feature");
            this.features = this.getResourceMapping(sf);
        }
        return this.features;
    }

    private Map<Resource, String> getResourceMapping(SimpleFilter resourceFilter) {
        Map<String, String> flats = this.getFlatSubsystemsMap();
        Map<Resource, List<Wire>> wiring = this.getWiring();
        HashMap<Resource, String> resources = new HashMap<Resource, String>();
        SimpleFilter sf = this.createFilter("osgi.identity", "*", "type", "karaf.subsystem");
        if (wiring != null) {
            for (Resource resource : wiring.keySet()) {
                Wire wire;
                if (this.findMatchingCapability(resourceFilter, resource.getCapabilities(null)) == null || (wire = this.findMatchingWire(sf, (Collection<Wire>)wiring.get(resource))) == null) continue;
                String region = (String)wire.getCapability().getAttributes().get("osgi.identity");
                region = flats.get(region);
                resources.put(resource, region);
            }
        }
        return resources;
    }

    private void associateFragments() {
        SimpleFilter sf = this.createFilter("osgi.identity", "*", "type", "karaf.subsystem");
        for (Map.Entry<Resource, List<Wire>> entry : this.wiring.entrySet()) {
            List<Wire> wires;
            Resource host;
            Wire wire;
            final Resource resource = entry.getKey();
            final Requirement requirement = this.getSubsystemRequirement(resource);
            if (!ResourceUtils.isFragment(resource) || (wire = this.findMatchingWire(sf, (Collection<Wire>)this.wiring.get(host = (wires = entry.getValue()).get(0).getProvider()))) == null) continue;
            wires.add(new Wire(){

                public Capability getCapability() {
                    return wire.getCapability();
                }

                public Requirement getRequirement() {
                    return requirement;
                }

                public Resource getProvider() {
                    return wire.getProvider();
                }

                public Resource getRequirer() {
                    return resource;
                }
            });
        }
    }

    private Requirement getSubsystemRequirement(Resource resource) {
        for (Requirement requirement : resource.getRequirements(null)) {
            if (!"osgi.identity".equals(requirement.getNamespace()) || !"karaf.subsystem".equals(requirement.getAttributes().get("type"))) continue;
            return requirement;
        }
        return null;
    }

    private Capability findMatchingCapability(SimpleFilter filter, Collection<Capability> caps) {
        for (Capability cap : caps) {
            if (!CapabilitySet.matches(cap, filter)) continue;
            return cap;
        }
        return null;
    }

    private Wire findMatchingWire(SimpleFilter filter, Collection<Wire> wires) {
        for (Wire wire : wires) {
            Capability cap = wire.getCapability();
            if (!CapabilitySet.matches(cap, filter)) continue;
            return wire;
        }
        return null;
    }

    private SimpleFilter createFilter(String ... s) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (int i = 0; i < s.length - 1; i += 2) {
            attrs.put(s[i], s[i + 1]);
        }
        return SimpleFilter.convert(attrs);
    }

    private void findSubsystemsToFlatten(Subsystem subsystem, Map<String, String> toFlatten) {
        Subsystem nonFlat = subsystem;
        if (subsystem != null) {
            while (this.isFlat(nonFlat)) {
                nonFlat = nonFlat.getParent();
            }
            toFlatten.put(subsystem.getName(), nonFlat.getName());
            for (Subsystem child : subsystem.getChildren()) {
                this.findSubsystemsToFlatten(child, toFlatten);
            }
        }
    }

    private boolean isFlat(Subsystem subsystem) {
        return subsystem.getFeature() != null && subsystem.getFeature().getScoping() == null;
    }

    private Subsystem getOrCreateChild(Subsystem ss, String name) {
        Subsystem child = ss.getChild(name);
        return child != null ? child : ss.createSubsystem(name, true);
    }

    private void populateDigraph(RegionDigraph digraph, Subsystem subsystem) throws BundleException, InvalidSyntaxException {
        Region region = digraph.createRegion(subsystem.getName());
        if (subsystem.getParent() != null) {
            Region parent = digraph.getRegion(subsystem.getParent().getName());
            digraph.connect(region, this.createRegionFilterBuilder(digraph, subsystem.getImportPolicy()).build(), parent);
            digraph.connect(parent, this.createRegionFilterBuilder(digraph, subsystem.getExportPolicy()).build(), region);
        }
        for (Subsystem child : subsystem.getChildren()) {
            this.populateDigraph(digraph, child);
        }
    }

    private RegionFilterBuilder createRegionFilterBuilder(RegionDigraph digraph, Map<String, Set<String>> sharingPolicy) throws InvalidSyntaxException {
        RegionFilterBuilder result = digraph.createRegionFilterBuilder();
        for (Map.Entry<String, Set<String>> entry : sharingPolicy.entrySet()) {
            for (String filter : entry.getValue()) {
                result.allow(entry.getKey(), filter);
            }
        }
        return result;
    }
}

