/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.repository;

import io.fabric8.agent.repository.BaseRepository;
import io.fabric8.agent.repository.MetadataProvider;
import io.fabric8.agent.resolver.ResourceBuilder;
import io.fabric8.agent.resolver.ResourceImpl;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataRepository
extends BaseRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataRepository.class);

    public MetadataRepository(MetadataProvider provider) {
        Map<String, Map<String, String>> metadatas = provider.getMetadatas();
        for (Map.Entry<String, Map<String, String>> metadata : metadatas.entrySet()) {
            try {
                ResourceImpl resource = ResourceBuilder.build(metadata.getKey(), metadata.getValue());
                this.addResource(resource);
            }
            catch (Exception e) {
                LOGGER.info("Unable to build resource for " + metadata.getKey(), (Throwable)e);
            }
        }
    }
}

