/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.resolver;

import io.fabric8.agent.resolver.CapabilityImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class ResourceImpl
implements Resource {
    protected final List<Capability> caps = new ArrayList<Capability>();
    protected final List<Requirement> reqs;

    public ResourceImpl() {
        this.reqs = new ArrayList<Requirement>();
    }

    public ResourceImpl(String name, String type, Version version) {
        HashMap<String, String> dirs = new HashMap<String, String>();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("osgi.identity", name);
        attrs.put("type", type);
        attrs.put("version", version);
        CapabilityImpl identity = new CapabilityImpl(this, "osgi.identity", dirs, attrs);
        this.caps.add(identity);
        this.reqs = new ArrayList<Requirement>();
    }

    public void addCapability(Capability capability) {
        assert (capability.getResource() == this);
        this.caps.add(capability);
    }

    public void addCapabilities(Iterable<? extends Capability> capabilities) {
        for (Capability capability : capabilities) {
            this.addCapability(capability);
        }
    }

    public void addRequirement(Requirement requirement) {
        assert (requirement.getResource() == this);
        this.reqs.add(requirement);
    }

    public void addRequirements(Iterable<? extends Requirement> requirements) {
        for (Requirement requirement : requirements) {
            this.addRequirement(requirement);
        }
    }

    public List<Capability> getCapabilities(String namespace) {
        List<Capability> result = this.caps;
        if (namespace != null) {
            result = new ArrayList<Capability>();
            for (Capability cap : this.caps) {
                if (!cap.getNamespace().equals(namespace)) continue;
                result.add(cap);
            }
        }
        return result;
    }

    public List<Requirement> getRequirements(String namespace) {
        List<Requirement> result = this.reqs;
        if (namespace != null) {
            result = new ArrayList<Requirement>();
            for (Requirement req : this.reqs) {
                if (!req.getNamespace().equals(namespace)) continue;
                result.add(req);
            }
        }
        return result;
    }

    public String toString() {
        Capability cap = this.getCapabilities("osgi.identity").get(0);
        return cap.getAttributes().get("osgi.identity") + "/" + cap.getAttributes().get("version");
    }
}

