/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.commands;

import io.fabric8.common.util.Strings;
import io.fabric8.tooling.archetype.ArchetypeService;
import io.fabric8.tooling.archetype.catalog.Archetype;
import io.fabric8.tooling.archetype.commands.ArchetypeHelper;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="archetype-info", scope="fabric", description="Displays information about a fabric Maven archetype")
public class ArchetypeInfoAction
extends AbstractAction {
    static final String FORMAT = "%-30s %s";
    @Argument(index=0, name="archetype", description="ArchetypeId or coordinate", required=true, multiValued=false)
    private String archetypeGAV;
    private final ArchetypeService archetypeService;

    public ArchetypeInfoAction(ArchetypeService archetypeService) {
        this.archetypeService = archetypeService;
    }

    protected Object doExecute() throws Exception {
        Archetype archetype = this.archetypeService.getArchetypeByArtifact(this.archetypeGAV);
        if (archetype == null) {
            this.archetypeService.getArchetype(this.archetypeGAV);
        }
        if (archetype != null) {
            System.out.println(String.format(FORMAT, "GroupId:", archetype.groupId));
            System.out.println(String.format(FORMAT, "ArtifactId:", archetype.artifactId));
            System.out.println(String.format(FORMAT, "Version:", archetype.version));
            System.out.println(String.format(FORMAT, "Coordinate:", ArchetypeHelper.toMavenCoordinate(archetype)));
            System.out.println(String.format(FORMAT, "Description:", Strings.emptyIfNull((String)archetype.description)));
            System.out.println(String.format(FORMAT, "Repository:", Strings.emptyIfNull((String)archetype.repository)));
        } else {
            System.err.println("No archetype found for: " + this.archetypeGAV);
        }
        return null;
    }
}

