/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.commands;

import io.fabric8.common.util.Strings;
import io.fabric8.tooling.archetype.ArchetypeService;
import java.util.prefs.Preferences;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="archetype-workspace", scope="fabric", description="To switch the workspace location (the default directory used by the archetype-generate command)")
public class ArchetypeWorkspaceAction
extends AbstractAction {
    @Argument(index=0, name="workspace", description="To switch the workspace location (directory)", required=false, multiValued=false)
    private String workspace;
    private final ArchetypeService archetypeService;

    public ArchetypeWorkspaceAction(ArchetypeService archetypeService) {
        this.archetypeService = archetypeService;
    }

    protected Object doExecute() throws Exception {
        if (Strings.isNullOrBlank((String)this.workspace)) {
            Preferences preferences = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
            String current = preferences.get("workspace", null);
            if (current == null) {
                System.out.println("No workspace has been set.");
            } else {
                System.out.println("Current workspace: " + current);
            }
        } else {
            Preferences preferences = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
            preferences.put("workspace", this.workspace);
            System.out.println("Workspace switched to: " + this.workspace);
        }
        return null;
    }
}

