/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management;

public class BundleUpdate {
    private final String symbolicName;
    private final String previousVersion;
    private final String previousLocation;
    private final String newVersion;
    private String newLocation;
    private int startLevel = -1;
    private int state = -1;
    private boolean independent = true;
    private String toString;

    public BundleUpdate(String symbolicName, String newVersion, String newLocation, String previousVersion, String previousLocation) {
        this(symbolicName, newVersion, newLocation, previousVersion, previousLocation, -1, -1);
    }

    public BundleUpdate(String symbolicName, String newVersion, String newLocation, String previousVersion, String previousLocation, int startLevel, int state) {
        this.symbolicName = symbolicName;
        this.newVersion = newVersion;
        this.newLocation = newLocation;
        this.previousVersion = previousVersion;
        this.previousLocation = previousLocation;
        this.startLevel = startLevel;
        this.state = state;
        this.toString = symbolicName == null ? previousLocation : (newVersion == null ? String.format("%s: reinstall from %s (sl=%d)", symbolicName, previousLocation, startLevel) : (previousVersion == null ? String.format("%s: update to %s (from %s)", symbolicName, newVersion, newLocation) : String.format("%s: %s->%s (from %s) (sl=%d)", symbolicName, previousVersion, newVersion, newLocation, startLevel)));
    }

    public String toString() {
        return this.toString;
    }

    public static BundleUpdate from(String oldLocation) {
        return new BundleUpdate(null, null, null, null, oldLocation);
    }

    public BundleUpdate to(String newLocation) {
        this.newLocation = newLocation;
        return this;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public String getNewLocation() {
        return this.newLocation;
    }

    public String getPreviousVersion() {
        return this.previousVersion;
    }

    public String getPreviousLocation() {
        return this.previousLocation;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public int getState() {
        return this.state;
    }

    public boolean isIndependent() {
        return this.independent;
    }

    public void setIndependent(boolean independent) {
        this.independent = independent;
    }
}

