/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management;

import io.fabric8.patch.management.Artifact;
import io.fabric8.patch.management.BundleUpdate;
import io.fabric8.patch.management.PatchData;
import io.fabric8.patch.management.impl.Activator;
import io.fabric8.patch.management.io.EOLFixingFileOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class Utils {
    private static final Pattern FEATURES_FILE = Pattern.compile(".+-features(?:-core)?$");
    private static final Pattern SYMBOLIC_NAME_PATTERN = Pattern.compile("([^;: ]+)(.*)");
    private static final Pattern KARAF_PACKAGE_VERSION = Pattern.compile(".+;version=\"([^\"]+)\"");

    private Utils() {
    }

    public static void extractAndTrackZipEntry(PatchData patchData, ZipFile zip, ZipArchiveEntry entry, File target, boolean skipRootDir) throws IOException {
        Utils.extractZipEntry(zip, entry, target);
        String name = entry.getName();
        if (skipRootDir) {
            name = name.substring(name.indexOf(47) + 1);
        }
        if (name.startsWith("system/") || name.startsWith("repository/")) {
            if (name.startsWith("system/")) {
                name = name.substring("system/".length());
            } else if (name.startsWith("repository/")) {
                name = name.substring("repository/".length());
            }
            String fileName = FilenameUtils.getBaseName(name);
            String extension = FilenameUtils.getExtension(name);
            name = Utils.pathToMvnurl(name);
            if ("jar".equals(extension) || "war".equals(extension)) {
                patchData.getBundles().add(name);
            } else if ("xml".equals(extension) && FEATURES_FILE.matcher(fileName).matches()) {
                patchData.getFeatureFiles().add(name);
            } else {
                patchData.getOtherArtifacts().add(name);
            }
        } else {
            patchData.getFiles().add(name);
        }
    }

    public static void extractZipEntry(ZipFile zip, ZipArchiveEntry entry, File target) throws IOException {
        target.getParentFile().mkdirs();
        FileOutputStream targetOutputStream = new FileOutputStream(target);
        IOUtils.copyLarge(zip.getInputStream(entry), targetOutputStream);
        IOUtils.closeQuietly(targetOutputStream);
        if (Files.getFileAttributeView(target.toPath(), PosixFileAttributeView.class, new LinkOption[0]) != null) {
            Files.setPosixFilePermissions(target.toPath(), Utils.getPermissionsFromUnixMode(target, entry.getUnixMode()));
        }
    }

    public static Set<PosixFilePermission> getPermissionsFromUnixMode(File file, int unixMode) {
        String numeric = Integer.toOctalString(unixMode);
        if (numeric != null && numeric.length() > 3) {
            numeric = numeric.substring(numeric.length() - 3);
        }
        if (numeric == null || unixMode == 0) {
            return PosixFilePermissions.fromString(file.isDirectory() ? "rwxrwxr-x" : "rw-rw-r--");
        }
        HashSet<PosixFilePermission> result = new HashSet<PosixFilePermission>();
        int shortMode = Integer.parseInt(numeric, 8);
        if ((shortMode & 0x100) == 256) {
            result.add(PosixFilePermission.OWNER_READ);
        }
        result.add(PosixFilePermission.OWNER_WRITE);
        if ((shortMode & 0x40) == 64) {
            result.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((shortMode & 0x20) == 32) {
            result.add(PosixFilePermission.GROUP_READ);
        }
        if ((shortMode & 0x10) == 16) {
            result.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((shortMode & 8) == 8) {
            result.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((shortMode & 4) == 4) {
            result.add(PosixFilePermission.OTHERS_READ);
        }
        if ((shortMode & 2) == 2) {
            result.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((shortMode & 1) == 1) {
            result.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return result;
    }

    public static int getUnixModeFromPermissions(File file, Set<PosixFilePermission> permissions) {
        if (permissions == null) {
            return file.isDirectory() ? 509 : 436;
        }
        int result = 0;
        if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            result |= 0x100;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            result |= 0x80;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            result |= 0x40;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            result |= 0x20;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            result |= 0x10;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            result |= 8;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            result |= 4;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            result |= 2;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            result |= 1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpack(File zipFile, File targetDirectory, int skipInitialDirectories) throws IOException {
        try (ZipFile zf = new ZipFile(zipFile);){
            Enumeration<ZipArchiveEntry> e = zf.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry entry = e.nextElement();
                String name = entry.getName();
                int skip = skipInitialDirectories;
                while (skip-- > 0) {
                    name = name.substring(name.indexOf(47) + 1);
                }
                if (entry.isDirectory()) {
                    new File(targetDirectory, name).mkdirs();
                    continue;
                }
                File file = new File(targetDirectory, name);
                file.getParentFile().mkdirs();
                EOLFixingFileOutputStream output = new EOLFixingFileOutputStream(targetDirectory, file);
                IOUtils.copyLarge(zf.getInputStream(entry), output);
                IOUtils.closeQuietly(output);
                if (Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, new LinkOption[0]) == null) continue;
                Files.setPosixFilePermissions(file.toPath(), Utils.getPermissionsFromUnixMode(file, entry.getUnixMode()));
            }
        }
    }

    public static File getDeployDir(File karafHome) throws IOException {
        String deployDir = null;
        File fileinstallCfg = new File(System.getProperty("karaf.etc"), "org.apache.felix.fileinstall-deploy.cfg");
        if (fileinstallCfg.exists() && fileinstallCfg.isFile()) {
            Properties props = new Properties();
            FileInputStream stream = new FileInputStream(fileinstallCfg);
            props.load(stream);
            deployDir = props.getProperty("felix.fileinstall.dir");
            if (deployDir.contains("${karaf.home}")) {
                deployDir = deployDir.replace("${karaf.home}", System.getProperty("karaf.home"));
            } else if (deployDir.contains("${karaf.base}")) {
                deployDir = deployDir.replace("${karaf.base}", System.getProperty("karaf.base"));
            }
            IOUtils.closeQuietly(stream);
        } else {
            deployDir = karafHome.getAbsolutePath() + "/deploy";
        }
        return new File(deployDir);
    }

    public static File getSystemRepository(File karafHome, BundleContext systemContext) {
        return new File(karafHome, systemContext.getProperty("karaf.default.repository"));
    }

    public static String getBaselineLocationForProduct(File karafHome, BundleContext context, String version) {
        String[] ga;
        String productGA = context.getProperty("fuse.patch.product");
        if (productGA != null && !"".equals(productGA.trim()) && (ga = productGA.split(":")).length == 2) {
            String location = String.format("%s/%s/%s/%s-%s-baseline.zip", ga[0], ga[1], version, ga[1], version);
            if (new File(Utils.getSystemRepository(karafHome, context), location).isFile()) {
                return location;
            }
        }
        return null;
    }

    public static String relative(File f1, File f2) {
        Path p1 = f1.toPath();
        Path p2 = f2.toPath();
        return p1.relativize(p2).toString();
    }

    public static String pathToMvnurl(String path) {
        String[] p = path.split("/");
        if (p.length >= 4 && p[p.length - 1].startsWith(p[p.length - 3] + "-" + p[p.length - 2])) {
            String artifactId = p[p.length - 3];
            String version = p[p.length - 2];
            String artifactIdVersion = artifactId + "-" + version;
            StringBuffer sb = new StringBuffer();
            String classifier = p[p.length - 1].charAt(artifactIdVersion.length()) == '-' ? p[p.length - 1].substring(artifactIdVersion.length() + 1, p[p.length - 1].lastIndexOf(46)) : null;
            String type = p[p.length - 1].substring(p[p.length - 1].lastIndexOf(46) + 1);
            sb.append("mvn:");
            for (int j = 0; j < p.length - 3; ++j) {
                if (j > 0) {
                    sb.append('.');
                }
                sb.append(p[j]);
            }
            sb.append('/').append(artifactId).append('/').append(version);
            if (!"jar".equals(type) || classifier != null) {
                sb.append('/');
                if (!"jar".equals(type)) {
                    sb.append(type);
                } else if (classifier != null) {
                    sb.append(type);
                }
                if (classifier != null) {
                    sb.append('/').append(classifier);
                }
            }
            return sb.toString();
        }
        return null;
    }

    public static String mvnurlToPath(String url) {
        String[] group;
        Artifact artifact = Utils.mvnurlToArtifact(url, true);
        if (artifact == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String g : group = artifact.getGroupId().split("\\.")) {
            sb.append('/').append(g);
        }
        sb.append('/').append(artifact.getArtifactId());
        sb.append('/').append(artifact.getVersion());
        sb.append('/').append(artifact.getArtifactId()).append("-").append(artifact.getVersion());
        if (artifact.getClassifier() != null) {
            sb.append('-').append(artifact.getClassifier());
        }
        sb.append('.').append(artifact.getType());
        return sb.toString().substring(1);
    }

    public static Artifact mvnurlToArtifact(String resourceLocation, boolean skipNonMavenProtocols) {
        String[] parts;
        int index3;
        int index = (resourceLocation = resourceLocation.replace("\r\n", "").replace("\n", "").replace(" ", "").replace("\t", "")).indexOf("mvn:");
        if (index < 0) {
            if (skipNonMavenProtocols) {
                return null;
            }
            throw new IllegalArgumentException("Resource URL is not a maven URL: " + resourceLocation);
        }
        resourceLocation = resourceLocation.substring(index + "mvn:".length());
        int index1 = resourceLocation.indexOf(63);
        int index2 = resourceLocation.indexOf(35);
        int endIndex = -1;
        if (index1 > 0) {
            endIndex = index2 > 0 ? Math.min(index1, index2) : index1;
        } else if (index2 > 0) {
            endIndex = index2;
        }
        if (endIndex >= 0) {
            resourceLocation = resourceLocation.substring(0, endIndex);
        }
        if ((index3 = resourceLocation.indexOf(36)) > 0) {
            resourceLocation = resourceLocation.substring(0, index3);
        }
        if ((parts = resourceLocation.split("/")).length > 2) {
            String groupId = parts[0];
            String artifactId = parts[1];
            String version = parts[2];
            String type = "jar";
            String classifier = null;
            if (parts.length > 3) {
                type = parts[3];
                if (parts.length > 4) {
                    classifier = parts[4];
                }
            }
            return new Artifact(groupId, artifactId, version, type, classifier);
        }
        throw new IllegalArgumentException("Bad maven url: " + resourceLocation);
    }

    public static String stripSymbolicName(String symbolicName) {
        Matcher m = SYMBOLIC_NAME_PATTERN.matcher(symbolicName);
        if (m.matches() && m.groupCount() >= 1) {
            return m.group(1);
        }
        return symbolicName;
    }

    public static Version getFeatureVersion(String version) {
        if (version == null || "".equals(version.trim())) {
            return Version.emptyVersion;
        }
        String[] vt = version.split("\\.");
        String[] nvt = new String[4];
        int[] v123 = new int[]{0, 0, 0};
        String v4 = null;
        if (vt.length < 4) {
            try {
                Integer.parseInt(vt[vt.length - 1]);
                for (int i = 0; i < vt.length; ++i) {
                    v123[i] = Integer.parseInt(vt[i]);
                }
            }
            catch (NumberFormatException e) {
                v4 = vt[vt.length - 1];
                for (int i = 0; i < vt.length - 1; ++i) {
                    v123[i] = Integer.parseInt(vt[i]);
                }
                v4 = vt[vt.length - 1];
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                v123[i] = Integer.parseInt(vt[i]);
            }
            v4 = vt[vt.length - 1];
        }
        return new Version(v123[0], v123[1], v123[2], v4);
    }

    public static Map<String, String> collectLocationUpdates(List<BundleUpdate> bundleUpdatesInThisPatch) {
        HashMap<String, String> locationUpdates = new HashMap<String, String>();
        if (bundleUpdatesInThisPatch != null) {
            for (BundleUpdate update : bundleUpdatesInThisPatch) {
                if (update.getPreviousLocation() == null || update.getNewLocation() == null) continue;
                String l1 = update.getPreviousLocation();
                String l2 = update.getNewLocation();
                if (l1.contains("org/ops4j/pax/url/pax-url-aether")) {
                    l1 = l1.substring(l1.indexOf("org/ops4j/pax/url/pax-url-aether"));
                    l2 = l2.substring(l2.indexOf("org/ops4j/pax/url/pax-url-aether"));
                    locationUpdates.put(l1, l2);
                    continue;
                }
                locationUpdates.put(Utils.mvnurlToPath(l1), Utils.mvnurlToPath(l2));
            }
        }
        return locationUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateKarafPackageVersion(File configProperties, String newVersion, String ... packages) {
        BufferedReader reader = null;
        StringWriter sw = new StringWriter();
        try {
            reader = new BufferedReader(new FileReader(configProperties));
            String line = null;
            while ((line = reader.readLine()) != null) {
                for (String pkg : packages) {
                    Matcher matcher = KARAF_PACKAGE_VERSION.matcher(line);
                    if (!line.contains(pkg + ";version=") || !matcher.find()) continue;
                    StringBuffer sb = new StringBuffer();
                    sb.append(line.substring(0, matcher.start(1)));
                    sb.append(newVersion);
                    sb.append(line.substring(matcher.end(1)));
                    line = sb.toString();
                }
                sw.append(line).append("\n");
            }
            IOUtils.closeQuietly(reader);
            FileUtils.write(configProperties, sw.toString());
        }
        catch (Exception e) {
            try {
                Activator.log(1, null, e.getMessage(), e, true);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly(reader);
        }
        IOUtils.closeQuietly(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long checksum(InputStream is) throws IOException {
        try {
            int l;
            CRC32 crc = new CRC32();
            byte[] buffer = new byte[8192];
            while ((l = is.read(buffer)) > 0) {
                crc.update(buffer, 0, l);
            }
            long l2 = crc.getValue();
            return l2;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }
}

