/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.impl;

import io.fabric8.patch.management.Artifact;
import io.fabric8.patch.management.PatchData;
import io.fabric8.patch.management.PatchException;
import io.fabric8.patch.management.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.Version;

public class Offline {
    private static final String PATCH_BACKUPS = "data/patch/backups";
    private static final String OVERRIDE_RANGE = ";range=";
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    private final File karafBase;
    private final Logger logger;

    public Offline(File karafBase) {
        this(karafBase, new SysLogger());
    }

    public Offline(File karafBase, Logger logger) {
        this.karafBase = karafBase;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(File patchZip) throws IOException {
        ZipFile zipFile = new ZipFile(patchZip);
        try {
            List<PatchData> patches = this.extractPatch(zipFile);
            if (patches.isEmpty()) {
                this.log(2, "No patch to apply");
            } else {
                for (PatchData data : patches) {
                    this.applyPatch(data, zipFile, null);
                }
            }
        }
        finally {
            IOUtils.closeQuietly(zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(File patchZip) throws IOException {
        ZipFile zipFile = new ZipFile(patchZip);
        try {
            List<PatchData> patches = this.extractPatch(zipFile);
            if (patches.isEmpty()) {
                this.log(2, "No patch to apply");
            } else {
                for (PatchData data : patches) {
                    this.rollbackPatch(data);
                }
            }
        }
        finally {
            IOUtils.closeQuietly(zipFile);
        }
    }

    public void rollbackPatch(PatchData patch) throws IOException {
        this.log(0, String.format("Rolling back patch %s / %s", patch.getId(), patch.getDescription()));
        for (String file : patch.getFiles()) {
            this.restore(patch, file);
        }
    }

    public void applyConfigChanges(PatchData patch, File storage) throws IOException {
        this.applyPatch(patch, null, storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PatchData> extractPatch(ZipFile zipFile) throws IOException {
        ArrayList<PatchData> patches = new ArrayList<PatchData>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            String entryName;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".patch") || entryName.contains("/")) continue;
            InputStream fis = zipFile.getInputStream(entry);
            try {
                PatchData patch = PatchData.load((InputStream)fis);
                patches.add(patch);
            }
            finally {
                IOUtils.closeQuietly(fis);
            }
        }
        return patches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyPatch(PatchData patch, ZipFile zipFile, File storage) throws IOException {
        Artifact artifact;
        this.log(0, "Applying patch: " + patch.getId() + " / " + patch.getDescription());
        File startupFile = new File(this.karafBase, "etc/startup.properties");
        File overridesFile = new File(this.karafBase, "etc/overrides.properties");
        List<String> startup = FileUtils.readLines(new File(this.karafBase, "etc/startup.properties"));
        List<String> overrides = FileUtils.readLines(overridesFile);
        ArrayList<Artifact> toExtract = new ArrayList<Artifact>();
        ArrayList<Artifact> toDelete = new ArrayList<Artifact>();
        for (String bundle : patch.getBundles()) {
            String line;
            int i;
            VersionRange range;
            String override;
            Artifact artifact2 = Utils.mvnurlToArtifact((String)bundle, (boolean)true);
            if (artifact2 == null) continue;
            Version oVer = VersionTable.getVersion(artifact2.getVersion());
            String vr = patch.getVersionRange(bundle);
            if (vr != null && !vr.isEmpty()) {
                override = bundle + OVERRIDE_RANGE + vr;
                range = VersionRange.parseVersionRange(vr);
            } else {
                override = bundle;
                Version v1 = new Version(oVer.getMajor(), oVer.getMinor(), 0);
                Version v2 = new Version(oVer.getMajor(), oVer.getMinor() + 1, 0);
                range = new VersionRange(false, v1, v2, true);
            }
            boolean matching = false;
            boolean added = false;
            for (i = 0; i < overrides.size(); ++i) {
                line = overrides.get(i).trim();
                if (line.isEmpty() || line.startsWith("#")) continue;
                Artifact overrideArtifact = Utils.mvnurlToArtifact((String)line, (boolean)true);
                if (overrideArtifact != null) {
                    Version ver = VersionTable.getVersion(overrideArtifact.getVersion());
                    if (!Artifact.isSameButVersion((Artifact)artifact2, (Artifact)overrideArtifact) || !range.contains(ver)) continue;
                    matching = true;
                    if (ver.compareTo(oVer) >= 0) continue;
                    overrides.set(i, override);
                    if (!added) {
                        this.log(0, "Replacing with artifact: " + override);
                        added = true;
                    }
                    toDelete.add(overrideArtifact);
                    toExtract.remove(overrideArtifact);
                    continue;
                }
                this.log(2, "Unable to convert to artifact: " + line);
            }
            if (!matching) {
                overrides.add(override);
                this.log(0, "Adding artifact: " + override);
            }
            for (i = 0; i < startup.size(); ++i) {
                Artifact startupArtifact;
                int index;
                String mvnUrl;
                line = startup.get(i).trim();
                if (line.isEmpty() || line.startsWith("#") || (mvnUrl = Utils.pathToMvnurl((String)line.substring(0, index = line.indexOf(61)))) == null || (startupArtifact = Utils.mvnurlToArtifact((String)mvnUrl, (boolean)true)) == null) continue;
                Version ver = VersionTable.getVersion(startupArtifact.getVersion());
                if (!Artifact.isSameButVersion((Artifact)artifact2, (Artifact)startupArtifact) || !range.contains(ver)) continue;
                matching = true;
                if (ver.compareTo(oVer) >= 0) continue;
                line = artifact2.getPath() + line.substring(index);
                startup.set(i, line);
                this.log(0, "Overwriting startup.properties with: " + artifact2);
                added = true;
            }
            if (matching && !added) continue;
            toExtract.add(artifact2);
        }
        if (zipFile != null) {
            for (Artifact artifact3 : toExtract) {
                this.log(0, "Extracting artifact: " + artifact3);
                ZipEntry entry = zipFile.getEntry("repository/" + artifact3.getPath());
                if (entry == null) {
                    this.log(3, "Could not find artifact in patch zip: " + artifact3);
                    continue;
                }
                File f = new File(this.karafBase, "system/" + artifact3.getPath());
                if (f.isFile()) continue;
                f.getParentFile().mkdirs();
                InputStream fis = zipFile.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(f);
                try {
                    IOUtils.copy(fis, (OutputStream)fos);
                }
                finally {
                    IOUtils.closeQuietly(fis);
                    IOUtils.closeQuietly(fos);
                }
            }
            for (Artifact artifact3 : toDelete) {
                String fileName = artifact3.getPath();
                File file = new File(this.karafBase, "system/" + fileName);
                if (file.exists()) {
                    this.log(0, "Removing old artifact " + artifact3);
                    file.delete();
                    continue;
                }
                this.log(2, "Could not find: " + file);
            }
        }
        overrides = new ArrayList<String>(new HashSet<String>(overrides));
        Collections.sort(overrides);
        FileUtils.writeLines(overridesFile, overrides);
        FileUtils.writeLines(startupFile, startup);
        if (zipFile != null) {
            this.patchFiles(patch, zipFile);
        } else if (storage != null) {
            this.patchFiles(patch, storage);
        } else {
            throw new PatchException("Unable to update patch files: no access to patch ZIP file or patch storage location");
        }
        if (patch.getMigratorBundle() != null && (artifact = Utils.mvnurlToArtifact((String)patch.getMigratorBundle(), (boolean)true)) != null) {
            File src = new File(this.karafBase, "system/" + artifact.getPath());
            File target = new File(new File(this.karafBase, "deploy"), artifact.getArtifactId() + ".jar");
            Offline.copy(src, target);
        }
    }

    static String getJavaFile() throws IOException {
        File file;
        String home = System.getProperty("java.home");
        if (home != null && (file = new File(home, "bin/java")).exists() && file.canExecute()) {
            return file.getCanonicalPath();
        }
        return "java";
    }

    static Process exec(String[] args, File dir) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(args, new String[0], dir);
        Offline.startPump(process.getInputStream(), System.out);
        Offline.startPump(process.getErrorStream(), System.err);
        return process;
    }

    static Thread startPump(final InputStream is, final OutputStream os) {
        Thread thread = new Thread("io"){

            @Override
            public void run() {
                try {
                    Offline.pump(is, os);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        return thread;
    }

    static void pump(InputStream distro, OutputStream fos) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = distro.read(buffer)) > 0) {
            fos.write(buffer, 0, len);
        }
    }

    private void patchFiles(PatchData patch, ZipFile zipFile) throws IOException {
        for (String file : patch.getFiles()) {
            ZipEntry entry = zipFile.getEntry(file);
            if (entry == null) {
                this.log(3, "Could not find file in patch zip: " + file);
                continue;
            }
            this.patchFile(patch, file, zipFile.getInputStream(entry));
        }
    }

    private void patchFiles(PatchData patch, File storage) throws IOException {
        for (String file : patch.getFiles()) {
            File entry = new File(storage, file);
            if (!entry.exists()) {
                this.log(3, "Could not find file in patch storage location: " + entry);
                continue;
            }
            this.patchFile(patch, file, new FileInputStream(entry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void patchFile(PatchData patch, String file, InputStream is) throws IOException {
        File target = new File(this.karafBase, file);
        if (target.exists()) {
            this.backup(patch, file);
            target.delete();
            this.log(0, String.format("Updating file: %s", file));
        } else {
            this.log(0, String.format("Adding file: %s", file));
        }
        target.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(target);
        try {
            IOUtils.copy(is, (OutputStream)fos);
        }
        finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(fos);
        }
    }

    private void backup(PatchData patch, String file) throws IOException {
        File backupDir = new File(new File(this.karafBase, PATCH_BACKUPS), patch.getId());
        File backup = new File(backupDir, file);
        backup.getParentFile().mkdirs();
        File source = new File(this.karafBase, file);
        Offline.copy(source, backup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restore(PatchData patch, String file) throws IOException {
        File backupDir = new File(new File(this.karafBase, PATCH_BACKUPS), patch.getId());
        try {
            File backup = new File(backupDir, file);
            File original = new File(this.karafBase, file);
            if (backup.exists()) {
                this.log(0, String.format("Restoring previous version of file: %s", file));
                Offline.copy(backup, original);
            } else {
                this.log(0, String.format("Removing file: %s", file));
                original.delete();
            }
        }
        finally {
            backupDir.delete();
        }
    }

    protected void log(int level, String message) {
        this.logger.log(level, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File from, File to) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(from);
            fos = new FileOutputStream(to);
            IOUtils.copy((InputStream)fis, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(fis);
        IOUtils.closeQuietly(fos);
    }

    public static class SysLogger
    implements Logger {
        @Override
        public void log(int level, String message) {
            switch (level) {
                case 0: {
                    System.out.println("DEBUG: " + message);
                    break;
                }
                case 1: {
                    System.out.println("INFO:  " + message);
                    break;
                }
                case 2: {
                    System.out.println("WARN:  " + message);
                    break;
                }
                case 3: {
                    System.out.println("ERROR: " + message);
                }
            }
        }
    }

    public static interface Logger {
        public void log(int var1, String var2);
    }
}

