/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.jetty.internal.JettyFactory;
import org.ops4j.pax.web.service.jetty.internal.JettyServer;
import org.ops4j.pax.web.service.jetty.internal.JettyServerImpl;
import org.ops4j.pax.web.service.jetty.internal.NIOSocketConnectorWrapper;
import org.ops4j.pax.web.service.jetty.internal.SocketConnectorWrapper;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.osgi.framework.Bundle;

class JettyFactoryImpl
implements JettyFactory {
    private final ServerModel serverModel;
    private Bundle bundle;

    JettyFactoryImpl(ServerModel serverModel, Bundle bundle) {
        NullArgumentException.validateNotNull(serverModel, "Service model");
        this.serverModel = serverModel;
        this.bundle = bundle;
    }

    @Override
    public JettyServer createServer() {
        return new JettyServerImpl(this.serverModel, this.bundle);
    }

    @Override
    public Connector createConnector(String name, int port, String host, boolean useNIO, Boolean checkForwardedHeaders) {
        if (useNIO) {
            NIOSocketConnectorWrapper nioConnector = new NIOSocketConnectorWrapper();
            nioConnector.setName(name);
            nioConnector.setHost(host);
            nioConnector.setPort(port);
            nioConnector.setUseDirectBuffers(true);
            if (checkForwardedHeaders != null) {
                nioConnector.setForwarded(checkForwardedHeaders);
            }
            return nioConnector;
        }
        SocketConnectorWrapper connector = new SocketConnectorWrapper();
        connector.setName(name);
        connector.setPort(port);
        connector.setHost(host);
        if (checkForwardedHeaders != null) {
            connector.setForwarded(checkForwardedHeaders);
        }
        return connector;
    }

    @Override
    public Connector createSecureConnector(String name, int port, String sslKeystore, String sslPassword, String sslKeyPassword, String host, String sslKeystoreType, String sslKeyAlias, String trustStore, String trustStorePassword, String trustStoreType, boolean isClientAuthNeeded, boolean isClientAuthWanted, boolean useNIO, List<String> cipherSuitesIncluded, List<String> cipherSuitesExcluded, List<String> protocolsIncluded, List<String> protocolsExcluded) {
        SslSelectChannelConnector connector;
        String[] cipherSuites;
        SslContextFactory sslContextFactory = new SslContextFactory(sslKeystore);
        sslContextFactory.setKeyStorePassword(sslKeyPassword);
        sslContextFactory.setKeyManagerPassword(sslPassword);
        sslContextFactory.setNeedClientAuth(isClientAuthNeeded);
        sslContextFactory.setWantClientAuth(isClientAuthWanted);
        if (sslKeystoreType != null) {
            sslContextFactory.setKeyStoreType(sslKeystoreType);
        }
        if (null != sslKeyAlias && !"".equals(sslKeyAlias)) {
            sslContextFactory.setCertAlias(sslKeyAlias);
        }
        if (null != trustStore && !"".equals(trustStore)) {
            sslContextFactory.setTrustStore(trustStore);
        }
        if (null != trustStorePassword && !"".equals(trustStorePassword)) {
            sslContextFactory.setTrustStorePassword(trustStorePassword);
        }
        if (null != trustStoreType && !"".equals(trustStoreType)) {
            sslContextFactory.setTrustStoreType(trustStoreType);
        }
        try {
            SSLContext context = SSLContext.getDefault();
            SSLSocketFactory sf = context.getSocketFactory();
            cipherSuites = sf.getSupportedCipherSuites();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to get supported cipher suites.", e);
        }
        if (cipherSuitesIncluded != null && !cipherSuitesIncluded.isEmpty()) {
            ArrayList<String> cipherSuitesToInclude = new ArrayList<String>();
            for (String cipherSuite : cipherSuites) {
                for (String includeRegex : cipherSuitesIncluded) {
                    if (!cipherSuite.matches(includeRegex)) continue;
                    cipherSuitesToInclude.add(cipherSuite);
                }
            }
            sslContextFactory.setIncludeCipherSuites(cipherSuitesToInclude.toArray(new String[cipherSuitesToInclude.size()]));
        }
        if (cipherSuitesExcluded != null && !cipherSuitesExcluded.isEmpty()) {
            ArrayList<String> cipherSuitesToExclude = new ArrayList<String>();
            for (String cipherSuite : cipherSuites) {
                for (String excludeRegex : cipherSuitesExcluded) {
                    if (!cipherSuite.matches(excludeRegex)) continue;
                    cipherSuitesToExclude.add(cipherSuite);
                }
            }
            sslContextFactory.setExcludeCipherSuites(cipherSuitesToExclude.toArray(new String[cipherSuitesToExclude.size()]));
        }
        if (null != protocolsIncluded && !protocolsIncluded.isEmpty()) {
            sslContextFactory.setIncludeProtocols(protocolsIncluded.toArray(new String[protocolsIncluded.size()]));
        }
        if (null != protocolsExcluded && !protocolsExcluded.isEmpty()) {
            sslContextFactory.setExcludeProtocols(protocolsExcluded.toArray(new String[protocolsExcluded.size()]));
        }
        if (useNIO) {
            connector = new SslSelectChannelConnector(sslContextFactory);
            connector.setName(name);
            connector.setPort(port);
            connector.setHost(host);
            connector.setConfidentialPort(port);
            return connector;
        }
        connector = new SslSocketConnector(sslContextFactory);
        connector.setName(name);
        connector.setPort(port);
        connector.setHost(host);
        connector.setConfidentialPort(port);
        return connector;
    }
}

