/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container.karaf;

import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.gravia.OSGiPropertiesProvider;
import io.fabric8.api.gravia.PropertiesProvider;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractRuntimeProperties;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.BundleContext;

@ThreadSafe
@Component(label="Karaf Runtime Properties Service", immediate=true, metatype=false)
@Service(value={RuntimeProperties.class})
public class KarafPropertiesService
extends AbstractRuntimeProperties {
    private PropertiesProvider propsProvider;

    @Activate
    void activate(BundleContext bundleContext) {
        this.propsProvider = new OSGiPropertiesProvider(bundleContext);
        this.activateInternal();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    protected String getPropertyInternal(String key, String defaultValue) {
        Object value = this.propsProvider.getProperty(key, (Object)defaultValue);
        return value instanceof String ? (String)value : defaultValue;
    }

    private void activateInternal() {
        if (this.propsProvider.getProperty("environment.prefix") == null) {
            System.setProperty("environment.prefix", "FABRIC8_");
        }
        if (this.propsProvider.getProperty("runtime.id") == null) {
            System.setProperty("runtime.id", System.getProperty("karaf.name", System.getenv("FABRIC8_RUNTIME_ID")));
        }
        if (this.propsProvider.getProperty("runtime.home") == null) {
            System.setProperty("runtime.home", System.getProperty("karaf.home"));
        }
        if (this.propsProvider.getProperty("runtime.data") == null) {
            System.setProperty("runtime.data", System.getProperty("karaf.data"));
        }
        if (this.propsProvider.getProperty("runtime.conf") == null) {
            System.setProperty("runtime.conf", System.getProperty("karaf.etc"));
        }
    }
}

