/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.web;

import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.web.WebEventHandler;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.osgi.framework.Bundle;
import org.osgi.service.startlevel.StartLevel;

@Command(scope="web", name="list", description="Lists details for war bundles.")
public class WebListCommand
extends OsgiCommandSupport {
    private StartLevel startLevelService;
    private WebEventHandler eventHandler;

    protected Object doExecute() {
        Bundle[] bundles = this.getBundleContext().getBundles();
        Map<Long, WebEvent> bundleEvents = this.eventHandler.getBundleEvents();
        if (bundles != null) {
            String level = this.startLevelService == null ? "" : "  Level ";
            String webState = bundleEvents == null || bundleEvents.isEmpty() ? "" : "  Web-State     ";
            String headers = "   ID   State       ";
            headers = headers + webState + level + " Web-ContextPath           Name";
            System.out.println(headers);
            for (int i = 0; i < bundles.length; ++i) {
                String webappctxt = (String)bundles[i].getHeaders().get("Web-ContextPath");
                if (webappctxt == null) {
                    webappctxt = (String)bundles[i].getHeaders().get("Webapp-Context");
                }
                if (webappctxt == null) continue;
                webappctxt.trim();
                String name = (String)bundles[i].getHeaders().get("Bundle-Name");
                name = name == null ? bundles[i].getSymbolicName() : name;
                name = name == null ? bundles[i].getLocation() : name;
                String version = (String)bundles[i].getHeaders().get("Bundle-Version");
                name = version != null ? name + " (" + version + ")" : name;
                long l = bundles[i].getBundleId();
                String id = String.valueOf(l);
                level = this.startLevelService == null ? "" : String.valueOf(this.startLevelService.getBundleStartLevel(bundles[i]));
                while (level.length() < 5) {
                    level = " " + level;
                }
                while (id.length() < 4) {
                    id = " " + id;
                }
                if (!webappctxt.startsWith("/")) {
                    webappctxt = "/" + webappctxt;
                }
                while (webappctxt.length() < 24) {
                    webappctxt = webappctxt + " ";
                }
                String line = "[" + id + "] [" + this.getStateString(bundles[i]) + "]";
                if (bundleEvents != null && !bundleEvents.isEmpty()) {
                    line = line + " [" + this.getWebStateString(bundles[i]) + "] ";
                }
                line = line + " [" + level + "] [" + webappctxt + "] " + name;
                System.out.println(line);
            }
        }
        return null;
    }

    public String getStateString(Bundle bundle) {
        int state = bundle.getState();
        if (state == 32) {
            return "Active     ";
        }
        if (state == 2) {
            return "Installed  ";
        }
        if (state == 4) {
            return "Resolved   ";
        }
        if (state == 8) {
            return "Starting   ";
        }
        if (state == 16) {
            return "Stopping   ";
        }
        return "Unknown    ";
    }

    public String getWebStateString(Bundle bundle) {
        long bundleId = bundle.getBundleId();
        Map<Long, WebEvent> bundleEvents = this.eventHandler.getBundleEvents();
        String topic = "Unknown    ";
        if (bundleEvents.containsKey(bundleId)) {
            WebEvent webEvent = bundleEvents.get(bundleId);
            switch (webEvent.getType()) {
                case 1: {
                    topic = "Deploying  ";
                    break;
                }
                case 2: {
                    topic = "Deployed   ";
                    break;
                }
                case 3: {
                    topic = "Undeploying";
                    break;
                }
                case 4: {
                    topic = "Undeployed ";
                    break;
                }
                case 5: {
                    topic = "Unknown    ";
                    topic = "Failed     ";
                    break;
                }
                default: {
                    topic = "Failed     ";
                }
            }
        }
        while (topic.length() < 11) {
            topic = topic + " ";
        }
        return topic;
    }

    public void setStartLevelService(StartLevel startLevelService) {
        this.startLevelService = startLevelService;
    }

    public StartLevel getStartLevelService() {
        return this.startLevelService;
    }

    public void setEventHandler(WebEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public WebEventHandler getEventHandler() {
        return this.eventHandler;
    }
}

