/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.commands;

import io.fabric8.patch.Service;
import io.fabric8.patch.management.BundleUpdate;
import io.fabric8.patch.management.Patch;
import io.fabric8.patch.management.PatchException;
import io.fabric8.patch.management.PatchResult;
import io.fabric8.patch.management.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.karaf.shell.console.AbstractAction;

public abstract class PatchActionSupport
extends AbstractAction {
    protected Service service;

    protected PatchActionSupport(Service service) {
        this.service = service;
    }

    protected Object doExecute() throws Exception {
        this.doExecute(this.service);
        return null;
    }

    protected abstract void doExecute(Service var1) throws Exception;

    protected void display(PatchResult result) {
        int l1 = "[name]".length();
        int l2 = "[old]".length();
        int l3 = "[new]".length();
        for (BundleUpdate update : result.getBundleUpdates()) {
            if (Utils.stripSymbolicName((String)update.getSymbolicName()).length() > l1) {
                l1 = Utils.stripSymbolicName((String)update.getSymbolicName()).length();
            }
            if (update.getPreviousVersion().length() > l2) {
                l2 = update.getPreviousVersion().length();
            }
            if (update.getNewVersion().length() <= l3) continue;
            l3 = update.getNewVersion().length();
        }
        System.out.println(String.format("%-" + l1 + "s   %-" + l2 + "s   %-" + l3 + "s", "[name]", "[old]", "[new]"));
        ArrayList updates = new ArrayList(result.getBundleUpdates());
        Collections.sort(updates, new Comparator<BundleUpdate>(){

            @Override
            public int compare(BundleUpdate o1, BundleUpdate o2) {
                return o1.getSymbolicName().compareTo(o2.getSymbolicName());
            }
        });
        for (BundleUpdate update : updates) {
            System.out.println(String.format("%-" + l1 + "s | %-" + l2 + "s | %-" + l3 + "s", Utils.stripSymbolicName((String)update.getSymbolicName()), update.getPreviousVersion(), update.getNewVersion()));
        }
    }

    protected void display(Iterable<Patch> patches, boolean listBundles) {
        String desc;
        int l1 = "[name]".length();
        int l2 = "[installed]".length();
        int l3 = "[description]".length();
        for (Patch patch : patches) {
            List versions;
            if (patch.getPatchData().getId().length() > l1) {
                l1 = patch.getPatchData().getId().length();
            }
            if (patch.getResult() != null && (versions = patch.getResult().getVersions()).size() > 0) {
                for (String v : versions) {
                    if (("Version " + v).length() <= l2) continue;
                    l2 = ("Version " + v).length();
                }
            }
            if ((desc = patch.getPatchData().getDescription() != null ? patch.getPatchData().getDescription() : "").length() <= l3) continue;
            l3 = desc.length();
        }
        System.out.println(String.format("%-" + l1 + "s %-" + l2 + "s %-" + l3 + "s", "[name]", "[installed]", "[description]"));
        for (Patch patch : patches) {
            desc = patch.getPatchData().getDescription() != null ? patch.getPatchData().getDescription() : "";
            String installed = Boolean.toString(patch.isInstalled());
            if (patch.getResult() != null && patch.getResult().getVersions().size() > 0) {
                installed = "Version " + (String)patch.getResult().getVersions().get(0);
            }
            System.out.println(String.format("%-" + l1 + "s %-" + l2 + "s %-" + l3 + "s", patch.getPatchData().getId(), installed, desc));
            if (patch.getResult() != null && patch.getResult().getVersions().size() > 1) {
                for (String v : patch.getResult().getVersions().subList(1, patch.getResult().getVersions().size())) {
                    System.out.println(String.format("%-" + l1 + "s %-" + l2 + "s %-" + l3 + "s", " ", "Version " + v, " "));
                }
            }
            if (!listBundles) continue;
            for (String b : patch.getPatchData().getBundles()) {
                System.out.println(String.format(" - %s", b));
            }
        }
    }

    protected Patch getPatch(String patchId) {
        Patch patch = this.service.getPatch(patchId);
        if (patch == null) {
            throw new PatchException("Patch '" + patchId + "' not found");
        }
        if (patch.isInstalled()) {
            throw new PatchException("Patch '" + patchId + "' is already installed");
        }
        return patch;
    }
}

