/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.log.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.insight.log.LogFilter;
import io.fabric8.insight.log.LogResults;
import io.fabric8.insight.log.service.LogQueryMBean;
import io.fabric8.insight.log.service.Logs;
import io.fabric8.insight.log.service.support.MavenCoordinates;
import io.fabric8.insight.log.support.LogQuerySupport;
import io.fabric8.insight.log.support.Predicate;
import java.io.IOException;
import javax.management.MBeanServer;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.karaf.shell.log.LruList;
import org.apache.karaf.shell.log.VmLogAppender;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class LogQuery
extends LogQuerySupport
implements LogQueryMBean {
    private transient Logger LOG = LoggerFactory.getLogger(LogQuery.class);
    @Reference
    private MBeanServer mbeanServer;
    @Reference(referenceInterface=PaxAppender.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, bind="bindAppender", unbind="unbindAppender")
    private VmLogAppender appender;

    public LogQuery() {
        this.mapper.getSerializationConfig().withSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    @Activate
    public void activate() {
        this.registerMBeanServer(this.mbeanServer);
    }

    @Deactivate
    public void deactivate() {
        this.unregisterMBeanServer(this.mbeanServer);
    }

    public void bindAppender(PaxAppender paxAppender) {
        if (paxAppender instanceof VmLogAppender) {
            this.appender = (VmLogAppender)paxAppender;
        }
    }

    public void unbindAppender(PaxAppender paxAppender) {
        if (paxAppender.equals(this.appender)) {
            this.appender = null;
        }
    }

    @Override
    public String getBundleMavenCoordinates(long bundleId) {
        return MavenCoordinates.getMavenCoordinates(bundleId);
    }

    @Override
    public LogResults getLogResults(int count) throws IOException {
        LogResults events = this.getLogEventList(count, null);
        return events;
    }

    @Override
    public LogResults queryLogResults(LogFilter filter) {
        Predicate<PaxLoggingEvent> predicate = Logs.createPredicate(filter);
        int count = -1;
        if (filter != null) {
            count = filter.getCount();
        }
        return this.getLogEventList(count, predicate);
    }

    public LogResults getLogEventList(int count, Predicate<PaxLoggingEvent> predicate) {
        LogResults answer = new LogResults();
        answer.setHost(this.getHostName());
        long from = Long.MAX_VALUE;
        long to = Long.MIN_VALUE;
        if (this.appender != null) {
            Iterable iterable;
            LruList events = this.appender.getEvents();
            if (events != null && (iterable = events.getElements()) != null) {
                int matched = 0;
                for (PaxLoggingEvent event : iterable) {
                    if (event == null) continue;
                    long timestamp = event.getTimeStamp();
                    if (timestamp > to) {
                        to = timestamp;
                    }
                    if (timestamp < from) {
                        from = timestamp;
                    }
                    if (predicate != null && !predicate.matches(event)) continue;
                    answer.addEvent(Logs.newInstance(event));
                    if (count <= 0 || ++matched < count) continue;
                    break;
                }
            }
        } else {
            this.LOG.warn("No VmLogAppender available!");
        }
        answer.setFromTimestamp(from);
        answer.setToTimestamp(to);
        return answer;
    }

    protected void bindMbeanServer(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    protected void unbindMbeanServer(MBeanServer mBeanServer) {
        if (this.mbeanServer == mBeanServer) {
            this.mbeanServer = null;
        }
    }
}

