/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.config;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConfigKey {
    HISTORY_MAX_ENTRIES("historyMaxEntries", true, false, "10"),
    DEBUG("debug", true, false, "false"),
    DEBUG_MAX_ENTRIES("debugMaxEntries", true, false, "100"),
    DISPATCHER_CLASSES("dispatcherClasses", true, false),
    LOGHANDLER_CLASS("logHandlerClass", true, false),
    MAX_DEPTH("maxDepth", true, true),
    MAX_COLLECTION_SIZE("maxCollectionSize", true, true),
    MAX_OBJECTS("maxObjects", true, true),
    POLICY_LOCATION("policyLocation", true, false, "classpath:/jolokia-access.xml"),
    IGNORE_ERRORS("ignoreErrors", false, true),
    INCLUDE_STACKTRACE("includeStackTrace", true, true, "true"),
    SERIALIZE_EXCEPTION("serializeException", true, true, "false"),
    CANONICAL_NAMING("canonicalNaming", true, true, "true"),
    MBEAN_QUALIFIER("mbeanQualifier", true, false),
    CALLBACK("callback", false, true),
    MIME_TYPE("mimeType", true, true, "text/plain"),
    IF_MODIFIED_SINCE("ifModifiedSince", false, true),
    DISCOVERY_ENABLED("discoveryEnabled", true, false),
    DISCOVERY_AGENT_URL("discoveryAgentUrl", true, false),
    USER("user", true, false),
    PASSWORD("password", true, false),
    REALM("realm", true, false, "jolokia"),
    AUTH_MODE("authMode", true, false, "basic"),
    AUTH_CLASS("authClass", true, false),
    AUTH_URL("authUrl", true, false),
    AUTH_PRINCIPAL_SPEC("authPrincipalSpec", true, false),
    AUTH_IGNORE_CERTS("authIgnoreCerts", true, false, "false"),
    AGENT_CONTEXT("agentContext", true, false, "/jolokia"),
    USE_RESTRICTOR_SERVICE("useRestrictorService", true, false, "false"),
    LISTEN_FOR_HTTP_SERVICE("listenForHttpService", true, false, "true"),
    HTTP_SERVICE_FILTER("httpServiceFilter", true, false),
    DETECTOR_OPTIONS("detectorOptions", true, false),
    MBEAN_PLUGIN_OPTIONS("mbeanPluginOptions", true, false),
    AGENT_ID("agentId", true, false),
    AGENT_TYPE("agentType", true, false),
    AGENT_DESCRIPTION("agentDescription", true, false);

    public static final String JAAS_SUBJECT_REQUEST_ATTRIBUTE = "org.jolokia.jaasSubject";
    private String key;
    private String defaultValue;
    private boolean globalConfig;
    private boolean requestConfig;
    private static Map<String, ConfigKey> keyByName;
    private static Map<String, ConfigKey> globalKeyByName;
    private static Map<String, ConfigKey> requestKeyByName;

    private ConfigKey(String pValue, boolean pIsGlobalConfig, boolean pIsRequestConfig) {
        this(pValue, pIsGlobalConfig, pIsRequestConfig, null);
    }

    private ConfigKey(String pValue, boolean pIsGlobalConfig, boolean pIsRequestConfig, String pDefault) {
        this.key = pValue;
        this.defaultValue = pDefault;
        this.globalConfig = pIsGlobalConfig;
        this.requestConfig = pIsRequestConfig;
    }

    public String toString() {
        return this.key;
    }

    public static ConfigKey getGlobalConfigKey(String pKeyS) {
        return globalKeyByName.get(pKeyS);
    }

    public static ConfigKey getRequestConfigKey(String pKeyS) {
        return requestKeyByName.get(pKeyS);
    }

    public String getKeyValue() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isGlobalConfig() {
        return this.globalConfig;
    }

    public boolean isRequestConfig() {
        return this.requestConfig;
    }

    static {
        keyByName = new HashMap<String, ConfigKey>();
        globalKeyByName = new HashMap<String, ConfigKey>();
        requestKeyByName = new HashMap<String, ConfigKey>();
        for (ConfigKey ck : ConfigKey.values()) {
            keyByName.put(ck.getKeyValue(), ck);
            if (ck.isGlobalConfig()) {
                globalKeyByName.put(ck.getKeyValue(), ck);
            }
            if (!ck.isRequestConfig()) continue;
            requestKeyByName.put(ck.getKeyValue(), ck);
        }
    }
}

