/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.commands;

import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.tooling.archetype.ArchetypeService;
import io.fabric8.tooling.archetype.commands.ArchetypeWorkspaceAction;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.FileCompleter;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"archetype-workspace"})})
public class ArchetypeWorkspace
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "archetype-workspace";
    public static final String DESCRIPTION = "To switch the workspace location (the default directory used by the archetype-generate command)";
    public static final String PREFERENCE_WORKSPACE = "workspace";
    @Reference(referenceInterface=ArchetypeService.class, bind="bindArchetypeService", unbind="unbindArchetypeService")
    private ArchetypeService archetypeService;

    public Action createNewAction() {
        this.assertValid();
        return new ArchetypeWorkspaceAction(this.archetypeService);
    }

    @Activate
    void activate() {
        this.activateComponent();
        this.bindCompleter((Completer)new FileCompleter(null));
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public void bindArchetypeService(ArchetypeService archetypeService) {
        this.archetypeService = archetypeService;
    }

    public void unbindArchetypeService(ArchetypeService archetypeService) {
        this.archetypeService = null;
    }
}

