/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.commands.support;

import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.tooling.archetype.ArchetypeService;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.osgi.service.component.ComponentContext;

@Component(immediate=true)
@Service(value={ArchetypeCompleter.class, Completer.class})
public class ArchetypeCompleter
extends AbstractComponent
implements Completer {
    @Reference(referenceInterface=ArchetypeService.class, bind="bindArchetypeService", unbind="unbindArchetypeService")
    private ArchetypeService archetypeService;
    private List<String> archetypes = new ArrayList<String>();

    public int complete(String buffer, int cursor, List candidates) {
        StringsCompleter delegate = new StringsCompleter(this.archetypes);
        return delegate.complete(buffer, cursor, candidates);
    }

    @Activate
    void activate(ComponentContext componentContext) {
        this.activateComponent();
        for (String[] gav : this.archetypeService.listArchetypeGAVs()) {
            this.archetypes.add(String.format("%s:%s:%s", gav[0], gav[1], gav[2]));
        }
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public void bindArchetypeService(ArchetypeService archetypeService) {
        this.archetypeService = archetypeService;
    }

    public void unbindArchetypeService(ArchetypeService archetypeService) {
        this.archetypeService = null;
    }
}

