/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent;

import io.fabric8.agent.download.DownloadCallback;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.download.Downloader;
import io.fabric8.agent.download.StreamProvider;
import io.fabric8.agent.internal.Macro;
import io.fabric8.agent.resolver.ResourceUtils;
import io.fabric8.agent.service.Agent;
import io.fabric8.agent.service.FeatureConfigInstaller;
import io.fabric8.agent.service.State;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.common.util.ChecksumUtils;
import io.fabric8.common.util.Files;
import io.fabric8.maven.MavenResolver;
import io.fabric8.maven.MavenResolvers;
import io.fabric8.patch.FabricPatchService;
import io.fabric8.patch.management.PatchManagement;
import io.fabric8.utils.NamedThreadFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.utils.version.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentAgent
implements ManagedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentAgent.class);
    private static final String DEFAULT_DOWNLOAD_THREADS = "4";
    private static final String DOWNLOAD_THREADS = "io.fabric8.agent.download.threads";
    private static long agentCounter = 1L;
    private static final String KARAF_HOME = System.getProperty("karaf.home");
    private static final String KARAF_BASE = System.getProperty("karaf.base");
    private static final String KARAF_DATA = System.getProperty("karaf.data");
    private static final String KARAF_ETC = System.getProperty("karaf.etc");
    private static final String SYSTEM_PATH = KARAF_HOME + File.separator + "system";
    private static final String LIB_PATH = KARAF_BASE + File.separator + "lib";
    private static final String LIB_EXT_PATH = LIB_PATH + File.separator + "ext";
    private static final String LIB_ENDORSED_PATH = LIB_PATH + File.separator + "endorsed";
    private static final String STATE_FILE = "state.json";
    private ServiceTracker<FabricService, FabricService> fabricService;
    private final ExecutorService executor;
    private final ScheduledExecutorService downloadExecutor;
    private final BundleContext bundleContext;
    private final BundleContext systemBundleContext;
    private final org.apache.felix.utils.properties.Properties libChecksums;
    private final org.apache.felix.utils.properties.Properties endorsedChecksums;
    private final org.apache.felix.utils.properties.Properties extensionChecksums;
    private final org.apache.felix.utils.properties.Properties etcChecksums;
    private final org.apache.felix.utils.properties.Properties managedLibs;
    private final org.apache.felix.utils.properties.Properties managedEndorsedLibs;
    private final org.apache.felix.utils.properties.Properties managedExtensionLibs;
    private final org.apache.felix.utils.properties.Properties managedSysProps;
    private final org.apache.felix.utils.properties.Properties managedConfigProps;
    private final org.apache.felix.utils.properties.Properties managedEtcs;
    private volatile String provisioningStatus;
    private volatile Throwable provisioningError;
    private volatile Collection<Resource> provisionList;
    private volatile boolean requiresRestart = false;
    private volatile boolean fabricNotAvailableLogged;
    private volatile String httpUrl;
    private volatile List<URI> mavenRepoURIs = new ArrayList<URI>();
    private Lock fabricServiceOperations = new ReentrantLock();
    private CountDownLatch fabricServiceAvailable = new CountDownLatch(1);
    private final State state = new State();
    private final String deploymentAgentId;
    private long lastStatusUpdate = 0L;
    private static final long UPDATE_INTERVAL = 2000L;

    public DeploymentAgent(BundleContext bundleContext) throws IOException {
        this.bundleContext = bundleContext;
        this.systemBundleContext = bundleContext.getBundle(0L).getBundleContext();
        this.libChecksums = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("lib-checksums.properties"));
        this.endorsedChecksums = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("endorsed-checksums.properties"));
        this.extensionChecksums = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("extension-checksums.properties"));
        this.etcChecksums = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("etc-checksums.properties"));
        this.managedSysProps = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("system.properties"));
        this.managedConfigProps = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("config.properties"));
        this.managedLibs = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("libs.properties"));
        this.managedEndorsedLibs = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("endorsed.properties"));
        this.managedExtensionLibs = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("extension.properties"));
        this.managedEtcs = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("etc.properties"));
        String revision = ((BundleRevision)bundleContext.getBundle().adapt(BundleRevision.class)).toString();
        this.deploymentAgentId = String.format("fabric-agent-%s.%s", revision, agentCounter++);
        this.executor = Executors.newSingleThreadExecutor(new NamedThreadFactory(this.deploymentAgentId));
        this.downloadExecutor = this.createDownloadExecutor();
        this.fabricService = new ServiceTracker(this.systemBundleContext, FabricService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<FabricService, FabricService>(){

            public FabricService addingService(ServiceReference<FabricService> reference) {
                FabricService service = (FabricService)DeploymentAgent.this.systemBundleContext.getService(reference);
                if (DeploymentAgent.this.provisioningStatus != null) {
                    DeploymentAgent.this.updateStatus(service, DeploymentAgent.this.provisioningStatus, DeploymentAgent.this.provisioningError, false);
                }
                if (service != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("FabricService found, getting httpUrl and repositoryURIs");
                    }
                    DeploymentAgent.this.updateMavenRepositoryConfiguration(service);
                }
                return service;
            }

            public void modifiedService(ServiceReference<FabricService> reference, FabricService service) {
                if (DeploymentAgent.this.provisioningStatus != null) {
                    DeploymentAgent.this.updateStatus(service, DeploymentAgent.this.provisioningStatus, DeploymentAgent.this.provisioningError, false);
                }
                if (service != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("FabricService modified, getting httpUrl and repositoryURIs");
                    }
                    DeploymentAgent.this.updateMavenRepositoryConfiguration(service);
                }
            }

            public void removedService(ServiceReference<FabricService> reference, FabricService service) {
            }
        });
        this.fabricService.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMavenRepositoryConfiguration(FabricService service) {
        try {
            this.fabricServiceOperations.lock();
            this.httpUrl = service.getCurrentContainer().getHttpUrl();
            this.mavenRepoURIs = service.getMavenRepoURIs();
            this.fabricServiceAvailable.countDown();
            LOGGER.info("Maven repository configuration correctly updated: httpUrl=[{}], mavenRepoURIs=[{}]", (Object)this.httpUrl, this.mavenRepoURIs);
        }
        catch (RuntimeException e) {
            LOGGER.info("It's been impossible to correctly update maven repositories configuration");
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Detailed Exception", (Throwable)e);
            }
        }
        finally {
            this.fabricServiceOperations.unlock();
        }
    }

    protected ScheduledExecutorService createDownloadExecutor() {
        String size = DEFAULT_DOWNLOAD_THREADS;
        try {
            org.apache.felix.utils.properties.Properties customProps = new org.apache.felix.utils.properties.Properties(new File(KARAF_BASE + File.separator + "etc" + File.separator + "custom.properties"));
            size = customProps.getProperty(DOWNLOAD_THREADS, size);
        }
        catch (Exception customProps) {
            // empty catch block
        }
        int num = Integer.parseInt(size);
        LOGGER.info("Creating fabric-agent-download thread pool with size: {}", (Object)num);
        return Executors.newScheduledThreadPool(num, new NamedThreadFactory("fabric-agent-download"));
    }

    public void start() throws IOException {
        LOGGER.info("Starting DeploymentAgent " + this.deploymentAgentId);
        this.loadLibChecksums(LIB_PATH, this.libChecksums);
        this.loadLibChecksums(LIB_ENDORSED_PATH, this.endorsedChecksums);
        this.loadLibChecksums(LIB_EXT_PATH, this.extensionChecksums);
        this.loadLibChecksums(KARAF_ETC, this.etcChecksums);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("DeploymentAgent ready to accept configadmin tasks");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        LOGGER.info("Stopping DeploymentAgent " + this.deploymentAgentId);
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("DeploymentAgent won't accept new configadmin tasks");
                }
            });
            this.executor.shutdown();
        }
        this.downloadExecutor.shutdown();
        this.fabricService.close();
    }

    private void loadLibChecksums(String path, org.apache.felix.utils.properties.Properties props) throws IOException {
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create fabric lib directory at:" + dir.getAbsolutePath());
        }
        for (String lib : dir.list()) {
            File f = new File(path, lib);
            if (!f.exists() || !f.isFile()) continue;
            props.put(lib, Long.toString(ChecksumUtils.checksum(new FileInputStream(f))));
        }
        props.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(final Dictionary<String, ?> props) throws ConfigurationException {
        LOGGER.info("DeploymentAgent {} updated with {}", (Object)this.deploymentAgentId, props);
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            if (this.executor.isShutdown() || props == null) {
                return;
            }
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    Throwable result = null;
                    boolean success = false;
                    try {
                        success = DeploymentAgent.this.doUpdate(props);
                    }
                    catch (Throwable e) {
                        result = e;
                        LOGGER.error("Unable to update agent", e);
                    }
                    if (success || result != null) {
                        DeploymentAgent.this.updateStatus(success ? "success" : "error", result, true);
                    }
                }
            });
        }
    }

    private void updateStatus(String status, Throwable result) {
        this.updateStatus(status, result, false);
    }

    private void updateStatus(String status, Throwable result, boolean force) {
        try {
            FabricService fs = force ? (FabricService)this.fabricService.waitForService(0L) : (FabricService)this.fabricService.getService();
            this.updateStatus(fs, status, result, force);
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to set provisioning result");
        }
    }

    private void updateStatus(FabricService fs, String status, Throwable result, boolean force) {
        if (!force && System.currentTimeMillis() < this.lastStatusUpdate + 2000L) {
            return;
        }
        this.lastStatusUpdate = System.currentTimeMillis();
        try {
            this.provisioningStatus = status;
            this.provisioningError = result;
            if (fs != null) {
                String e;
                this.fabricNotAvailableLogged = false;
                Container container = fs.getCurrentContainer();
                if (result == null) {
                    e = null;
                } else {
                    StringWriter sw = new StringWriter();
                    result.printStackTrace(new PrintWriter(sw));
                    e = sw.toString();
                }
                if (this.provisionList != null) {
                    TreeSet<String> uris = new TreeSet<String>();
                    for (Resource resource : this.provisionList) {
                        uris.add(ResourceUtils.getUri(resource));
                    }
                    container.setProvisionList(new ArrayList(uris));
                }
                container.setProvisionResult(status);
                container.setProvisionException(e);
                Properties provisionChecksums = new Properties();
                for (Map.Entry entry : this.state.bundleChecksums.entrySet()) {
                    Bundle bundle = this.systemBundleContext.getBundle(((Long)entry.getKey()).longValue());
                    String location = bundle.getLocation();
                    provisionChecksums.put(location, ((Long)entry.getValue()).toString());
                }
                container.setProvisionChecksums(provisionChecksums);
            } else if (!this.fabricNotAvailableLogged) {
                this.fabricNotAvailableLogged = true;
                LOGGER.info("Unable to set provisioning status as FabricService is not available");
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to set provisioning result");
        }
    }

    protected static void putAllProperties(Properties answer, org.apache.felix.utils.properties.Properties properties) {
        Set<Map.Entry<String, String>> entries = properties.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            answer.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doUpdate(Dictionary<String, ?> props) throws Exception {
        File libFile;
        List<URI> mavenRepoURIs;
        String httpUrl;
        if (props == null || Boolean.parseBoolean((String)props.get("disabled"))) {
            return false;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        Enumeration<String> e = props.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object val = props.get(key);
            if ("service.pid".equals(key) || "fabric.zookeeper.pid".equals(key)) continue;
            properties.put(key.toString(), val.toString());
        }
        this.updateStatus("analyzing", null);
        this.fabricServiceAvailable.await(30L, TimeUnit.SECONDS);
        if (!this.fabricService.isEmpty()) {
            this.updateMavenRepositoryConfiguration((FabricService)this.fabricService.getService());
        }
        try {
            this.fabricServiceOperations.lock();
            httpUrl = this.httpUrl;
            mavenRepoURIs = this.mavenRepoURIs;
        }
        finally {
            this.fabricServiceOperations.unlock();
        }
        AgentUtils.addMavenProxies(properties, httpUrl, mavenRepoURIs);
        final MavenResolver resolver = MavenResolvers.createMavenResolver(properties, (String)"org.ops4j.pax.url.mvn");
        final DownloadManager manager = DownloadManagers.createDownloadManager(resolver, this.getDownloadExecutor());
        manager.addListener(new DownloadCallback(){

            @Override
            public void downloaded(StreamProvider provider) throws Exception {
                int pending = manager.pending();
                DeploymentAgent.this.updateStatus(pending > 0 ? "downloading (" + pending + " pending)" : "downloading", null);
            }
        });
        final Object lock = new Object();
        final AtomicBoolean restart = new AtomicBoolean();
        final HashSet libsToRemove = new HashSet(this.managedLibs.keySet());
        final HashSet endorsedLibsToRemove = new HashSet(this.managedEndorsedLibs.keySet());
        final HashSet extensionLibsToRemove = new HashSet(this.managedExtensionLibs.keySet());
        HashSet sysPropsToRemove = new HashSet(this.managedSysProps.keySet());
        HashSet configPropsToRemove = new HashSet(this.managedConfigProps.keySet());
        final HashSet etcsToRemove = new HashSet(this.managedEtcs.keySet());
        final org.apache.felix.utils.properties.Properties configProps = new org.apache.felix.utils.properties.Properties(new File(KARAF_BASE + File.separator + "etc" + File.separator + "config.properties"));
        org.apache.felix.utils.properties.Properties systemProps = new org.apache.felix.utils.properties.Properties(new File(KARAF_BASE + File.separator + "etc" + File.separator + "system.properties"));
        Downloader downloader = manager.createDownloader();
        for (String key : properties.keySet()) {
            String value;
            Object v;
            String k;
            if (key.equals("framework")) {
                String url = properties.get(key);
                if (!url.startsWith("mvn:")) {
                    throw new IllegalArgumentException("Framework url must use the mvn: protocol");
                }
                downloader.download(url, new DownloadCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void downloaded(StreamProvider provider) throws Exception {
                        File file = provider.getFile();
                        String path = file.getPath();
                        if (path.startsWith(KARAF_HOME)) {
                            path = path.substring(KARAF_HOME.length() + 1);
                        }
                        Object object = lock;
                        synchronized (object) {
                            if (!path.equals(configProps.get("karaf.framework.felix"))) {
                                configProps.put("karaf.framework", "felix");
                                configProps.put("karaf.framework.felix", path);
                                restart.set(true);
                            }
                        }
                    }
                });
                continue;
            }
            if (key.startsWith("config.")) {
                k = key.substring("config.".length());
                v = properties.get(key);
                Object object = lock;
                synchronized (object) {
                    this.managedConfigProps.put(k, (String)v);
                    configPropsToRemove.remove(k);
                    if (!((String)v).equals(configProps.get(k))) {
                        configProps.put(k, (String)v);
                        restart.set(true);
                    }
                    continue;
                }
            }
            if (key.startsWith("system.")) {
                k = key.substring("system.".length());
                v = lock;
                synchronized (v) {
                    String v2 = properties.get(key);
                    this.managedSysProps.put(k, v2);
                    sysPropsToRemove.remove(k);
                    if (!v2.equals(systemProps.get(k))) {
                        systemProps.put(k, v2);
                        restart.set(true);
                    }
                    continue;
                }
            }
            if (key.startsWith("lib.")) {
                value = properties.get(key);
                downloader.download(value, new DownloadCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void downloaded(StreamProvider provider) throws Exception {
                        boolean update;
                        File libFile = provider.getFile();
                        String libName = libFile.getName();
                        Long checksum = ChecksumUtils.checksum(libFile);
                        Object object = lock;
                        synchronized (object) {
                            DeploymentAgent.this.managedLibs.put(libName, "true");
                            libsToRemove.remove(libName);
                            update = !Long.toString(checksum).equals(DeploymentAgent.this.libChecksums.getProperty(libName));
                        }
                        if (update) {
                            Files.copy(libFile, new File(LIB_PATH, libName));
                            restart.set(true);
                        }
                    }
                });
                continue;
            }
            if (key.startsWith("endorsed.")) {
                value = properties.get(key);
                downloader.download(value, new DownloadCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void downloaded(StreamProvider provider) throws Exception {
                        boolean update;
                        File libFile = provider.getFile();
                        String libName = libFile.getName();
                        Long checksum = ChecksumUtils.checksum(new FileInputStream(libFile));
                        Object object = lock;
                        synchronized (object) {
                            DeploymentAgent.this.managedEndorsedLibs.put(libName, "true");
                            endorsedLibsToRemove.remove(libName);
                            update = !Long.toString(checksum).equals(DeploymentAgent.this.endorsedChecksums.getProperty(libName));
                        }
                        if (update) {
                            Files.copy(libFile, new File(LIB_ENDORSED_PATH, libName));
                            restart.set(true);
                        }
                    }
                });
                continue;
            }
            if (key.startsWith("extension.")) {
                value = properties.get(key);
                downloader.download(value, new DownloadCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void downloaded(StreamProvider provider) throws Exception {
                        boolean update;
                        File libFile = provider.getFile();
                        String libName = libFile.getName();
                        Long checksum = ChecksumUtils.checksum(libFile);
                        Object object = lock;
                        synchronized (object) {
                            DeploymentAgent.this.managedExtensionLibs.put(libName, "true");
                            extensionLibsToRemove.remove(libName);
                            update = !Long.toString(checksum).equals(DeploymentAgent.this.extensionChecksums.getProperty(libName));
                        }
                        if (update) {
                            Files.copy(libFile, new File(LIB_EXT_PATH, libName));
                            restart.set(true);
                        }
                    }
                });
                continue;
            }
            if (!key.startsWith("etc.")) continue;
            value = properties.get(key);
            downloader.download(value, new DownloadCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void downloaded(StreamProvider provider) throws Exception {
                    boolean update;
                    File etcFile = provider.getFile();
                    String etcName = etcFile.getName();
                    Long checksum = ChecksumUtils.checksum(new FileInputStream(etcFile));
                    Object object = lock;
                    synchronized (object) {
                        DeploymentAgent.this.managedEtcs.put(etcName, "true");
                        etcsToRemove.remove(etcName);
                        update = !Long.toString(checksum).equals(DeploymentAgent.this.etcChecksums.getProperty(etcName));
                    }
                    if (update) {
                        Files.copy(etcFile, new File(KARAF_ETC, etcName));
                    }
                }
            });
        }
        downloader.await();
        for (String sysProp : sysPropsToRemove) {
            systemProps.remove(sysProp);
            this.managedSysProps.remove(sysProp);
            System.clearProperty(sysProp);
            restart.set(true);
        }
        for (String configProp : configPropsToRemove) {
            configProps.remove(configProp);
            this.managedConfigProps.remove(configProp);
            restart.set(true);
        }
        for (String lib : libsToRemove) {
            libFile = new File(LIB_PATH, lib);
            libFile.delete();
            this.libChecksums.remove(lib);
            this.managedLibs.remove(lib);
            restart.set(true);
        }
        for (String lib : endorsedLibsToRemove) {
            libFile = new File(LIB_ENDORSED_PATH, lib);
            libFile.delete();
            this.endorsedChecksums.remove(lib);
            this.managedEndorsedLibs.remove(lib);
            restart.set(true);
        }
        for (String lib : extensionLibsToRemove) {
            libFile = new File(LIB_EXT_PATH, lib);
            libFile.delete();
            this.extensionChecksums.remove(lib);
            this.managedExtensionLibs.remove(lib);
            restart.set(true);
        }
        for (String etc : etcsToRemove) {
            File etcFile = new File(KARAF_ETC, etc);
            etcFile.delete();
            this.etcChecksums.remove(etc);
            this.managedEtcs.remove(etc);
        }
        this.libChecksums.save();
        this.endorsedChecksums.save();
        this.extensionChecksums.save();
        this.etcChecksums.save();
        this.managedLibs.save();
        this.managedEndorsedLibs.save();
        this.managedExtensionLibs.save();
        this.managedConfigProps.save();
        this.managedSysProps.save();
        this.managedEtcs.save();
        if (restart.get()) {
            this.updateStatus("restarting", null);
            configProps.save();
            systemProps.save();
            System.setProperty("karaf.restart", "true");
            this.bundleContext.getBundle(0L).stop();
            return false;
        }
        FeatureConfigInstaller configInstaller = null;
        ServiceReference configAdminServiceReference = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (configAdminServiceReference != null) {
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.bundleContext.getService(configAdminServiceReference);
            configInstaller = new FeatureConfigInstaller(this.bundleContext, configAdmin, manager);
        }
        int bundleStartTimeout = 60;
        String overriddenTimeout = properties.get("io.fabric8.agent.bundle.start.timeout");
        try {
            if (overriddenTimeout != null) {
                bundleStartTimeout = Integer.parseInt(overriddenTimeout);
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Failed to set {} value: [{}], applying default value: {}", new Object[]{"io.fabric8.agent.bundle.start.timeout", overriddenTimeout, 60});
        }
        Agent agent = new Agent(this.bundleContext.getBundle(), this.systemBundleContext, manager, configInstaller, null, "${range;[====,====]}", "${range;[==,=+)}", "crc", this.bundleContext.getDataFile(STATE_FILE), bundleStartTimeout){

            @Override
            public void updateStatus(String status) {
                DeploymentAgent.this.updateStatus(status, null, false);
            }

            @Override
            public void updateStatus(String status, boolean force) {
                DeploymentAgent.this.updateStatus(status, null, force);
            }

            @Override
            protected void saveState(State newState) throws IOException {
                super.saveState(newState);
                DeploymentAgent.this.state.replace(newState);
            }

            @Override
            protected void provisionList(Set<Resource> resources) {
                DeploymentAgent.this.provisionList = resources;
            }

            @Override
            protected boolean done(boolean agentStarted, List<String> urls) {
                if (agentStarted) {
                    return true;
                }
                ServiceReference srPm = DeploymentAgent.this.systemBundleContext.getServiceReference(PatchManagement.class);
                ServiceReference srFs = DeploymentAgent.this.systemBundleContext.getServiceReference(FabricService.class);
                if (srPm != null && srFs != null) {
                    PatchManagement pm = (PatchManagement)DeploymentAgent.this.systemBundleContext.getService(srPm);
                    FabricService fs = (FabricService)DeploymentAgent.this.systemBundleContext.getService(srFs);
                    if (pm != null && fs != null) {
                        LOGGER.info("Validating baseline information");
                        this.updateStatus("validating baseline information", true);
                        Profile profile = fs.getCurrentContainer().getOverlayProfile();
                        Map versions = profile.getConfiguration("io.fabric8.version");
                        File localRepository = resolver.getLocalRepository();
                        if (pm.alignTo(versions, urls, localRepository, new Runnable(){

                            @Override
                            public void run() {
                                FabricPatchService fps;
                                ServiceReference srFps = DeploymentAgent.this.systemBundleContext.getServiceReference(FabricPatchService.class);
                                if (srFps != null && (fps = (FabricPatchService)DeploymentAgent.this.systemBundleContext.getService(srFps)) != null) {
                                    try {
                                        fps.synchronize();
                                    }
                                    catch (Exception e) {
                                        LOGGER.error(e.getMessage(), (Throwable)e);
                                    }
                                }
                            }
                        })) {
                            this.updateStatus("requires full restart", true);
                            restart.set(true);
                            return false;
                        }
                    }
                }
                return true;
            }
        };
        agent.setDeploymentAgentId(this.deploymentAgentId);
        agent.provision(DeploymentAgent.getPrefixedProperties(properties, "repository."), DeploymentAgent.getPrefixedProperties(properties, "feature."), DeploymentAgent.getPrefixedProperties(properties, "bundle."), DeploymentAgent.getPrefixedProperties(properties, "req."), DeploymentAgent.getPrefixedProperties(properties, "override."), DeploymentAgent.getPrefixedProperties(properties, "optional."), DeploymentAgent.getMetadata(properties, "metadata#"));
        return !restart.get();
    }

    public static Set<String> getPrefixedProperties(Map<String, String> properties, String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (String key : properties.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String url = properties.get(key);
            if (url == null || url.length() == 0) {
                url = key.substring(prefix.length());
            }
            if (url.length() <= 0) continue;
            result.add(url);
        }
        return result;
    }

    public static Map<String, Map<VersionRange, Map<String, String>>> getMetadata(Map<String, String> properties, String prefix) {
        HashMap<String, Map<VersionRange, Map<String, String>>> result = new HashMap<String, Map<VersionRange, Map<String, String>>>();
        for (String key : properties.keySet()) {
            VersionRange range;
            HashMap<String, String> hdrs;
            String version;
            if (!key.startsWith(prefix)) continue;
            String val = properties.get(key);
            String[] parts = (key = key.substring(prefix.length())).split("#");
            if (parts.length != 3) continue;
            HashMap<VersionRange, HashMap<String, String>> ranges = (HashMap<VersionRange, HashMap<String, String>>)result.get(parts[0]);
            if (ranges == null) {
                ranges = new HashMap<VersionRange, HashMap<String, String>>();
                result.put(parts[0], ranges);
            }
            if (!(version = parts[1]).startsWith("[") && !version.startsWith("(")) {
                version = Macro.transform("${range;[==,=+)}", version);
            }
            if ((hdrs = (HashMap<String, String>)ranges.get(range = new VersionRange(version))) == null) {
                hdrs = new HashMap<String, String>();
                ranges.put(range, hdrs);
            }
            hdrs.put(parts[2], val);
        }
        return result;
    }

    protected ScheduledExecutorService getDownloadExecutor() {
        return this.downloadExecutor;
    }
}

