/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.download.impl;

import io.fabric8.agent.download.DownloadCallback;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.Downloader;
import io.fabric8.agent.download.StreamProvider;
import io.fabric8.agent.download.impl.AbstractDownloadTask;
import io.fabric8.agent.download.impl.DownloadManagerHelper;
import io.fabric8.agent.download.impl.FutureListener;
import io.fabric8.agent.download.impl.MavenDownloadTask;
import io.fabric8.agent.download.impl.SimpleDownloadTask;
import io.fabric8.common.util.MultiException;
import io.fabric8.maven.MavenResolver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;

public class MavenDownloadManager
implements DownloadManager {
    private final MavenResolver mavenResolver;
    private final ScheduledExecutorService executorService;
    private File tmpPath;
    private final Map<String, AbstractDownloadTask> downloaded = new HashMap<String, AbstractDownloadTask>();
    private final Map<String, AbstractDownloadTask> downloading = new HashMap<String, AbstractDownloadTask>();
    private final List<DownloadCallback> listeners = new CopyOnWriteArrayList<DownloadCallback>();
    private final Object lock = new Object();
    private volatile int allPending = 0;

    public MavenDownloadManager(MavenResolver mavenResolver, ScheduledExecutorService executorService) {
        this.mavenResolver = mavenResolver;
        this.executorService = executorService;
        String karafRoot = System.getProperty("karaf.home", "karaf");
        String karafData = System.getProperty("karaf.data", karafRoot + "/data");
        this.tmpPath = new File(karafData, "tmp");
    }

    @Override
    public int pending() {
        return this.allPending;
    }

    @Override
    public Downloader createDownloader() {
        return new MavenDownloader();
    }

    @Override
    public Map<String, StreamProvider> getProviders() {
        return Collections.synchronizedMap(this.downloaded);
    }

    @Override
    public void addListener(DownloadCallback listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(DownloadCallback listener) {
        this.listeners.remove(listener);
    }

    class MavenDownloader
    implements Downloader {
        private volatile int pending = 0;
        private final MultiException exception = new MultiException("Error");

        MavenDownloader() {
        }

        @Override
        public int pending() {
            return this.pending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void await() throws InterruptedException, MultiException {
            Object object = MavenDownloadManager.this.lock;
            synchronized (object) {
                while (this.pending != 0) {
                    MavenDownloadManager.this.lock.wait();
                }
            }
            this.exception.throwIfCauses();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void download(final String location, final DownloadCallback downloadCallback) throws MalformedURLException {
            AbstractDownloadTask task;
            Object object = MavenDownloadManager.this.lock;
            synchronized (object) {
                task = (AbstractDownloadTask)MavenDownloadManager.this.downloaded.get(location);
                if (task == null) {
                    task = (AbstractDownloadTask)MavenDownloadManager.this.downloading.get(location);
                }
            }
            if (task == null) {
                task = this.createDownloadTask(location);
            }
            object = MavenDownloadManager.this.lock;
            synchronized (object) {
                AbstractDownloadTask prev = (AbstractDownloadTask)MavenDownloadManager.this.downloaded.get(location);
                if (prev == null) {
                    prev = (AbstractDownloadTask)MavenDownloadManager.this.downloading.get(location);
                }
                if (prev == null) {
                    MavenDownloadManager.this.downloading.put(location, task);
                    MavenDownloadManager.this.executorService.execute(task);
                } else {
                    task = prev;
                }
                ++this.pending;
                MavenDownloadManager.this.allPending++;
            }
            final AbstractDownloadTask downloadTask = task;
            task.addListener(new FutureListener<AbstractDownloadTask>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(AbstractDownloadTask future) {
                    try {
                        downloadTask.getFile();
                        if (downloadCallback != null) {
                            downloadCallback.downloaded(downloadTask);
                        }
                        for (DownloadCallback listener : MavenDownloadManager.this.listeners) {
                            listener.downloaded(downloadTask);
                        }
                    }
                    catch (Exception e) {
                        MavenDownloader.this.exception.addCause(e);
                    }
                    finally {
                        Object object = MavenDownloadManager.this.lock;
                        synchronized (object) {
                            MavenDownloadManager.this.downloading.remove(location);
                            MavenDownloadManager.this.downloaded.put(location, downloadTask);
                            --MavenDownloadManager.this.allPending;
                            if (--MavenDownloader.this.pending == 0) {
                                MavenDownloadManager.this.lock.notifyAll();
                            }
                        }
                    }
                }
            });
        }

        private AbstractDownloadTask createDownloadTask(String url) {
            String mvnUrl = DownloadManagerHelper.stripUrl(url);
            if (mvnUrl.startsWith("mvn:")) {
                if (!mvnUrl.equals(url)) {
                    return new ChainedDownloadTask(MavenDownloadManager.this.executorService, url, mvnUrl);
                }
                return new MavenDownloadTask(MavenDownloadManager.this.executorService, MavenDownloadManager.this.mavenResolver, mvnUrl);
            }
            return new SimpleDownloadTask(MavenDownloadManager.this.executorService, url, MavenDownloadManager.this.tmpPath);
        }

        class ChainedDownloadTask
        extends AbstractDownloadTask {
            private String innerUrl;

            public ChainedDownloadTask(ScheduledExecutorService executorService, String url, String innerUrl) {
                super(executorService, url);
                this.innerUrl = innerUrl;
            }

            @Override
            public void run() {
                try {
                    MavenDownloader.this.download(this.innerUrl, new DownloadCallback(){

                        @Override
                        public void downloaded(StreamProvider provider) throws Exception {
                            try {
                                AbstractDownloadTask future = (AbstractDownloadTask)provider;
                                String file = future.getFile().toURI().toURL().toExternalForm();
                                String real = ChainedDownloadTask.this.url.replace(ChainedDownloadTask.this.innerUrl, file);
                                MavenDownloader.this.download(real, new DownloadCallback(){

                                    @Override
                                    public void downloaded(StreamProvider provider) throws Exception {
                                        try {
                                            AbstractDownloadTask future = (AbstractDownloadTask)provider;
                                            ChainedDownloadTask.this.setFile(future.getFile());
                                        }
                                        catch (IOException e) {
                                            ChainedDownloadTask.this.setException(e);
                                        }
                                    }
                                });
                            }
                            catch (IOException e) {
                                ChainedDownloadTask.this.setException(e);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    this.setException(e);
                }
            }
        }
    }
}

