/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.download.impl;

import io.fabric8.agent.download.impl.AbstractDownloadTask;
import io.fabric8.agent.download.impl.AbstractRetryableDownloadTask;
import io.fabric8.agent.download.impl.DownloadManagerHelper;
import io.fabric8.common.util.IOHelpers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDownloadTask
extends AbstractRetryableDownloadTask {
    private static final String BLUEPRINT_PREFIX = "blueprint:";
    private static final String SPRING_PREFIX = "spring:";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDownloadTask.class);
    private static final String Ix2 = "  ";
    private static final String Ix4 = "    ";
    private File basePath;

    public SimpleDownloadTask(ScheduledExecutorService executorService, String url, File basePath) {
        super(executorService, url);
        this.basePath = basePath;
    }

    @Override
    protected File download() throws Exception {
        LOG.trace("Downloading [" + this.url + "]");
        String s = this.url;
        if (s.startsWith("fab:")) {
            s = s.substring(4);
        }
        if (s.startsWith(BLUEPRINT_PREFIX) || s.startsWith(SPRING_PREFIX)) {
            return this.downloadBlueprintOrSpring();
        }
        try {
            this.basePath.mkdirs();
            if (!this.basePath.isDirectory()) {
                throw new IOException("Unable to create directory " + this.basePath.toString());
            }
            URL urlObj = new URL(s);
            File file = new File(this.basePath, this.getFileName(urlObj.getFile()));
            File dir = new File(System.getProperty("karaf.data"), "fabric-agent");
            dir.mkdirs();
            if (!dir.isDirectory()) {
                throw new IOException("Unable to create directory " + dir.toString());
            }
            File tmpFile = File.createTempFile("download-", null, dir);
            try (InputStream is = urlObj.openStream();
                 FileOutputStream os = new FileOutputStream(tmpFile);){
                IOHelpers.copy(is, os);
            }
            if (file.exists() && !file.delete()) {
                throw new IOException("Unable to delete file: " + file.toString());
            }
            if (!tmpFile.renameTo(file)) {
                throw new IOException("Unable to rename file " + tmpFile.toString() + " to " + file.toString());
            }
            return file;
        }
        catch (IOException ignore) {
            LOG.debug("  Could not download [" + this.url + "]");
            LOG.trace("  Reason [" + ignore.getClass().getName() + ": " + ignore.getMessage() + "]");
            throw new IOException("URL [" + this.url + "] could not be resolved.");
        }
    }

    private String getFileName(String url) {
        url = DownloadManagerHelper.stripUrl(url);
        url = DownloadManagerHelper.removeInlinedMavenRepositoryUrl(url);
        int unixPos = url.lastIndexOf(47);
        int windowsPos = url.lastIndexOf(92);
        return url.substring(Math.max(unixPos, windowsPos) + 1);
    }

    protected File downloadBlueprintOrSpring() throws Exception {
        File dir = new File(System.getProperty("karaf.data"), "fabric-agent");
        dir.mkdirs();
        File tmpFile = File.createTempFile("download-", null, dir);
        try (InputStream is = new URL(this.url).openStream();
             FileOutputStream os = new FileOutputStream(tmpFile);){
            IOHelpers.copy(is, os);
        }
        return tmpFile;
    }
}

