/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.model;

import io.fabric8.agent.model.Capability;
import io.fabric8.agent.model.Conditional;
import io.fabric8.agent.model.Content;
import io.fabric8.agent.model.Requirement;
import io.fabric8.agent.model.Scoping;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.felix.utils.version.VersionCleaner;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="feature", propOrder={"details", "config", "configfile", "feature", "bundle", "conditional", "capability", "requirement", "scoping"})
public class Feature
extends Content {
    public static final String VERSION_SEPARATOR = "/";
    public static final String DEFAULT_VERSION = "0.0.0";
    protected String details;
    @XmlAttribute(required=true)
    protected String name;
    @XmlTransient
    protected String version;
    @XmlAttribute
    protected String description;
    @XmlAttribute
    protected String resolver;
    @XmlAttribute
    protected String install;
    @XmlAttribute(name="start-level")
    protected Integer startLevel;
    @XmlAttribute
    protected Boolean hidden;
    protected List<Conditional> conditional;
    protected List<Capability> capability;
    protected List<Requirement> requirement;
    protected Scoping scoping;

    public Feature() {
    }

    public Feature(String name) {
        this.name = name;
    }

    public Feature(String name, String version) {
        this.name = name;
        this.version = VersionCleaner.clean(version);
    }

    public static Feature valueOf(String str) {
        if (str.contains(VERSION_SEPARATOR)) {
            String strName = str.substring(0, str.indexOf(VERSION_SEPARATOR));
            String strVersion = str.substring(str.indexOf(VERSION_SEPARATOR) + VERSION_SEPARATOR.length(), str.length());
            return new Feature(strName, strVersion);
        }
        return new Feature(str);
    }

    public String getId() {
        return this.getName() + VERSION_SEPARATOR + this.getVersion();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getVersion() {
        if (this.version == null) {
            return DEFAULT_VERSION;
        }
        return this.version;
    }

    @XmlAttribute
    public void setVersion(String value) {
        this.version = VersionCleaner.clean(value);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getResolver() {
        return this.resolver;
    }

    public String getInstall() {
        return this.install;
    }

    public void setInstall(String install) {
        this.install = install;
    }

    public void setResolver(String value) {
        this.resolver = value;
    }

    public int getStartLevel() {
        return this.startLevel == null ? 0 : this.startLevel;
    }

    public void setStartLevel(Integer value) {
        this.startLevel = value;
    }

    public boolean isHidden() {
        return this.hidden == null ? false : this.hidden;
    }

    public void setHidden(Boolean value) {
        this.hidden = value;
    }

    public List<Conditional> getConditional() {
        if (this.conditional == null) {
            this.conditional = new ArrayList<Conditional>();
        }
        return this.conditional;
    }

    public List<Capability> getCapabilities() {
        if (this.capability == null) {
            this.capability = new ArrayList<Capability>();
        }
        return this.capability;
    }

    public List<Requirement> getRequirements() {
        if (this.requirement == null) {
            this.requirement = new ArrayList<Requirement>();
        }
        return this.requirement;
    }

    public Scoping getScoping() {
        return this.scoping;
    }

    public void setScoping(Scoping scoping) {
        this.scoping = scoping;
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature)o;
        if (this.name != null ? !this.name.equals(feature.name) : feature.name != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(feature.version) : feature.version != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    protected void interpolation(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = properties.getProperty(key);
            Matcher matcher = Pattern.compile("\\$\\{([^}]+)\\}").matcher(val);
            while (matcher.find()) {
                String rep = System.getProperty(matcher.group(1));
                if (rep == null) continue;
                val = val.replace(matcher.group(0), rep);
                matcher.reset(val);
            }
            properties.put(key, val);
        }
    }
}

