/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.service;

import io.fabric8.agent.download.DownloadCallback;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.Downloader;
import io.fabric8.agent.download.StreamProvider;
import io.fabric8.agent.internal.MapUtils;
import io.fabric8.agent.model.Feature;
import io.fabric8.agent.model.Repository;
import io.fabric8.agent.repository.StaticRepository;
import io.fabric8.agent.resolver.ResourceBuilder;
import io.fabric8.agent.resolver.ResourceImpl;
import io.fabric8.agent.service.Constants;
import io.fabric8.agent.service.Deployer;
import io.fabric8.agent.service.FeatureConfigInstaller;
import io.fabric8.agent.service.MetadataBuilder;
import io.fabric8.agent.service.State;
import io.fabric8.agent.service.StateStorage;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.gravia.ServiceLocator;
import io.fabric8.common.util.ChecksumUtils;
import io.fabric8.common.util.MultiException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.util.bundles.BundleUtils;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Agent {
    private static final Logger LOGGER = LoggerFactory.getLogger(Agent.class);
    private final Bundle serviceBundle;
    private final BundleContext systemBundleContext;
    private final DownloadManager manager;
    private final FeatureConfigInstaller configInstaller;
    private final RegionDigraph digraph;
    private final int bundleStartTimeout;
    private final String featureResolutionRange;
    private final String bundleUpdateRange;
    private final String updateSnaphots;
    private final StateStorage storage;
    private EnumSet<Constants.Option> options = EnumSet.noneOf(Constants.Option.class);
    private String deploymentAgentId;

    public Agent(Bundle serviceBundle, BundleContext systemBundleContext, DownloadManager manager) {
        this(serviceBundle, systemBundleContext, manager, null, null, "${range;[====,====]}", "${range;[==,=+)}", "crc", null, 60);
    }

    public Agent(Bundle serviceBundle, BundleContext systemBundleContext, DownloadManager manager, FeatureConfigInstaller configInstaller, RegionDigraph digraph, String featureResolutionRange, String bundleUpdateRange, String updateSnaphots, File stateFile, int bundleStartTimeout) {
        this.serviceBundle = serviceBundle;
        this.systemBundleContext = systemBundleContext;
        this.manager = manager;
        this.configInstaller = configInstaller;
        this.digraph = digraph;
        this.featureResolutionRange = featureResolutionRange;
        this.bundleUpdateRange = bundleUpdateRange;
        this.updateSnaphots = updateSnaphots;
        this.bundleStartTimeout = bundleStartTimeout;
        final File file = stateFile;
        this.storage = new StateStorage(){

            @Override
            protected InputStream getInputStream() throws IOException {
                if (file != null && file.exists()) {
                    return new FileInputStream(file);
                }
                return null;
            }

            @Override
            protected OutputStream getOutputStream() throws IOException {
                if (file != null) {
                    return new FileOutputStream(file);
                }
                return null;
            }
        };
    }

    public void updateStatus(String status) {
    }

    public void updateStatus(String status, boolean force) {
    }

    public void provision(Set<String> repositories, Set<String> features, Set<String> bundles, Set<String> reqs, Set<String> overrides, Set<String> optionals, Map<String, Map<VersionRange, Map<String, String>>> metadata) throws Exception {
        this.updateStatus("downloading");
        Callable<Map<String, Repository>> repos = AgentUtils.downloadRepositories(this.manager, repositories);
        HashMap<String, Feature> allFeatures = new HashMap<String, Feature>();
        for (Repository repository : repos.call().values()) {
            for (Feature f : repository.getFeatures()) {
                String id = f.getId();
                if (allFeatures.put(id, f) == null) continue;
                throw new IllegalStateException("Duplicate feature found: " + id);
            }
        }
        this.provision(allFeatures, features, bundles, reqs, overrides, optionals, metadata);
    }

    public void provision(Map<String, Feature> allFeatures, Set<String> features, Set<String> bundles, Set<String> reqs, Set<String> overrides, Set<String> optionals, Map<String, Map<VersionRange, Map<String, String>>> metadata) throws Exception {
        Callable<Map<String, Resource>> res = Agent.loadResources(this.manager, metadata, optionals);
        HashMap<String, Set<String>> requirements = new HashMap<String, Set<String>>();
        for (String feature : features) {
            MapUtils.addToMapSet(requirements, "root", "feature:" + feature);
        }
        for (String bundle : bundles) {
            MapUtils.addToMapSet(requirements, "root", "bundle:" + bundle);
        }
        for (String req : reqs) {
            MapUtils.addToMapSet(requirements, "root", "req:" + req);
        }
        Deployer.DeploymentRequest request = new Deployer.DeploymentRequest();
        request.updateSnaphots = this.updateSnaphots;
        request.bundleUpdateRange = this.bundleUpdateRange;
        request.featureResolutionRange = this.featureResolutionRange;
        request.globalRepository = new StaticRepository(res.call().values());
        request.overrides = overrides;
        request.requirements = requirements;
        request.stateChanges = Collections.emptyMap();
        request.options = this.options;
        request.metadata = metadata;
        request.bundleStartTimeout = this.bundleStartTimeout;
        Deployer.DeploymentState dstate = new Deployer.DeploymentState();
        dstate.serviceBundle = this.serviceBundle;
        FrameworkStartLevel fsl = (FrameworkStartLevel)this.systemBundleContext.getBundle().adapt(FrameworkStartLevel.class);
        dstate.initialBundleStartLevel = fsl.getInitialBundleStartLevel();
        dstate.currentStartLevel = fsl.getStartLevel();
        dstate.bundles = new HashMap<Long, Bundle>();
        for (Bundle bundle : this.systemBundleContext.getBundles()) {
            dstate.bundles.put(bundle.getBundleId(), bundle);
        }
        dstate.features = allFeatures;
        dstate.bundlesPerRegion = new HashMap<String, Set<Long>>();
        dstate.filtersPerRegion = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        if (this.digraph == null) {
            for (Long id : dstate.bundles.keySet()) {
                MapUtils.addToMapSet(dstate.bundlesPerRegion, "root", id);
            }
        } else {
            RegionDigraph clone = this.digraph.copy();
            for (Region region : clone.getRegions()) {
                dstate.bundlesPerRegion.put(region.getName(), new HashSet<Long>(region.getBundleIds()));
                HashMap edges = new HashMap();
                for (RegionDigraph.FilteredRegion fr : clone.getEdges(region)) {
                    HashMap policy = new HashMap();
                    Map<String, Collection<String>> current = fr.getFilter().getSharingPolicy();
                    for (String ns : current.keySet()) {
                        for (String f : current.get(ns)) {
                            MapUtils.addToMapSet(policy, ns, f);
                        }
                    }
                    edges.put(fr.getRegion().getName(), policy);
                }
                dstate.filtersPerRegion.put(region.getName(), edges);
            }
        }
        final State state = new State();
        try {
            this.storage.load(state);
        }
        catch (IOException e) {
            LOGGER.warn("Error loading agent state", (Throwable)e);
        }
        if (state.managedBundles.isEmpty()) {
            for (Bundle b : this.systemBundleContext.getBundles()) {
                if (b.getBundleId() == 0L) continue;
                MapUtils.addToMapSet(state.managedBundles, "root", b.getBundleId());
            }
        }
        for (Map.Entry<Long, Bundle> entry : dstate.bundles.entrySet()) {
            long id = entry.getKey();
            Bundle bundle = entry.getValue();
            if (id <= 0L || !this.isUpdateable(bundle) || state.bundleChecksums.containsKey(id)) continue;
            try {
                URL url = bundle.getResource("META-INF/MANIFEST.MF");
                URLConnection con = url.openConnection();
                Method method = con.getClass().getDeclaredMethod("getLocalURL", new Class[0]);
                method.setAccessible(true);
                String jarUrl = ((URL)method.invoke((Object)con, new Object[0])).toExternalForm();
                if (!jarUrl.startsWith("jar:")) continue;
                String jar = jarUrl.substring("jar:".length(), jarUrl.indexOf("!/"));
                jar = new URL(jar).getFile();
                long checksum = ChecksumUtils.checksumFile(new File(jar));
                state.bundleChecksums.put(id, checksum);
            }
            catch (Throwable t) {
                LOGGER.debug("Error calculating checksum for bundle: %s", (Object)bundle, (Object)t);
            }
        }
        dstate.state = state;
        HashSet<String> prereqs = new HashSet<String>();
        while (true) {
            try {
                BaseDeployCallback callback = new BaseDeployCallback(){

                    @Override
                    public void phase(String message) {
                        Agent.this.updateStatus(message);
                    }

                    @Override
                    public void saveState(State newState) {
                        state.replace(newState);
                        try {
                            Agent.this.saveState(newState);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Error storing agent state", (Throwable)e);
                        }
                    }

                    @Override
                    public void provisionList(Set<Resource> resources) {
                        Agent.this.provisionList(resources);
                    }

                    @Override
                    public void restoreConfigAdminIfNeeded() {
                        if (Agent.this.configInstaller != null) {
                            Agent.this.configInstaller.restoreConfigAdminIfNeeded();
                        }
                    }

                    @Override
                    public boolean done(boolean agentStarted, List<String> urls) {
                        return Agent.this.done(agentStarted, urls);
                    }
                };
                Deployer deployer = new Deployer(this.manager, callback);
                deployer.setDeploymentAgentId(this.deploymentAgentId);
                deployer.deploy(dstate, request);
            }
            catch (Deployer.PartialDeploymentException e) {
                if (!prereqs.containsAll(e.getMissing())) {
                    prereqs.addAll(e.getMissing());
                    continue;
                }
                throw new Exception("Deployment aborted due to loop in missing prerequisites: " + e.getMissing());
            }
            break;
        }
    }

    protected <T> void awaitService(Class<T> serviceClass, String filterspec, int timeout, TimeUnit timeUnit) {
        ServiceLocator.awaitService((BundleContext)this.systemBundleContext, serviceClass, (String)filterspec, (long)timeout, (TimeUnit)timeUnit);
    }

    protected boolean isUpdateable(Bundle bundle) {
        String uri = bundle.getLocation();
        return uri.matches("mvn:.*-SNAPSHOT((\\.\\w{3})?|\\$.*|\\?.*|\\#.*|\\&.*)|(?!mvn:).*");
    }

    protected void saveState(State newState) throws IOException {
        this.storage.save(newState);
    }

    protected void provisionList(Set<Resource> resources) {
    }

    protected boolean done(boolean agentStarted, List<String> urls) {
        return true;
    }

    public void setOptions(EnumSet<Constants.Option> options) {
        this.options = options;
    }

    public EnumSet<Constants.Option> getOptions() {
        return this.options;
    }

    public void setDeploymentAgentId(String deploymentAgentId) {
        this.deploymentAgentId = deploymentAgentId;
    }

    public static Callable<Map<String, Resource>> loadResources(DownloadManager manager, Map<String, Map<VersionRange, Map<String, String>>> metadata, Set<String> uris) throws MultiException, InterruptedException, MalformedURLException {
        final HashMap resources = new HashMap();
        final Downloader downloader = manager.createDownloader();
        final MetadataBuilder builder = new MetadataBuilder(metadata);
        DownloadCallback callback = new DownloadCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void downloaded(StreamProvider provider) throws Exception {
                String uri = provider.getUrl();
                Map<String, String> headers = builder.getMetadata(uri, provider.getFile());
                ResourceImpl resource = ResourceBuilder.build(uri, headers);
                Map map = resources;
                synchronized (map) {
                    resources.put(uri, resource);
                }
            }
        };
        for (String uri : uris) {
            downloader.download(uri, callback);
        }
        return new Callable<Map<String, Resource>>(){

            @Override
            public Map<String, Resource> call() throws Exception {
                downloader.await();
                return resources;
            }
        };
    }

    abstract class BaseDeployCallback
    implements Deployer.DeployCallback {
        BaseDeployCallback() {
        }

        @Override
        public void print(String message, int display) {
            if ((display & 1) != 0) {
                LOGGER.info(message);
            }
            if ((display & 2) != 0) {
                System.out.println(message);
            }
        }

        @Override
        public void refreshPackages(Collection<Bundle> bundles) throws InterruptedException {
            final CountDownLatch latch = new CountDownLatch(1);
            FrameworkWiring fw = (FrameworkWiring)Agent.this.systemBundleContext.getBundle().adapt(FrameworkWiring.class);
            fw.refreshBundles(bundles, new FrameworkListener[]{new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 2) {
                        LOGGER.error("Framework error", event.getThrowable());
                    }
                    latch.countDown();
                }
            }});
            latch.await();
        }

        @Override
        public void persistResolveRequest(Deployer.DeploymentRequest request) throws IOException {
        }

        @Override
        public void installFeatureConfigs(Feature feature) throws IOException, InvalidSyntaxException {
            if (Agent.this.configInstaller != null) {
                Agent.this.configInstaller.installFeatureConfigs(feature);
            }
        }

        @Override
        public Bundle installBundle(String region, String uri, InputStream is) throws BundleException {
            if (Agent.this.digraph == null) {
                if ("root".equals(region)) {
                    return Agent.this.systemBundleContext.installBundle(uri, is);
                }
                throw new IllegalStateException("Can not install the bundle " + uri + " in the region " + region + " as regions are not supported");
            }
            if ("root".equals(region)) {
                return Agent.this.digraph.getRegion(region).installBundleAtLocation(uri, is);
            }
            return Agent.this.digraph.getRegion(region).installBundle(uri, is);
        }

        @Override
        public void updateBundle(Bundle bundle, String uri, InputStream is) throws BundleException {
            try {
                File file = BundleUtils.fixBundleWithUpdateLocation(is, uri);
                bundle.update((InputStream)new FileInputStream(file));
                file.delete();
            }
            catch (IOException e) {
                throw new BundleException("Unable to update bundle", (Throwable)e);
            }
        }

        @Override
        public void uninstall(Bundle bundle) throws BundleException {
            bundle.uninstall();
        }

        @Override
        public void startBundle(Bundle bundle) throws BundleException {
            bundle.start();
        }

        @Override
        public void stopBundle(Bundle bundle, int options) throws BundleException {
            bundle.stop(options);
        }

        @Override
        public void setBundleStartLevel(Bundle bundle, int startLevel) {
            ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(startLevel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resolveBundles(Set<Bundle> bundles, final Map<Resource, List<Wire>> wiring, Map<Resource, Bundle> resToBnd) {
            final Thread thread = Thread.currentThread();
            final HashMap<Bundle, Resource> bndToRes = new HashMap<Bundle, Resource>();
            for (Resource res : resToBnd.keySet()) {
                bndToRes.put(resToBnd.get(res), res);
            }
            final ResolverHook hook = new ResolverHook(){

                public void filterResolvable(Collection<BundleRevision> candidates) {
                }

                public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                }

                public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                    if (Thread.currentThread() == thread) {
                        if ("osgi.ee".equals(requirement.getNamespace())) {
                            return;
                        }
                        Bundle sourceBundle = requirement.getRevision().getBundle();
                        Resource sourceResource = (Resource)bndToRes.get(sourceBundle);
                        HashSet<Resource> wired = new HashSet<Resource>();
                        wired.add(sourceResource);
                        for (Wire wire : (List)wiring.get(sourceResource)) {
                            wired.add(wire.getProvider());
                            if (!"osgi.wiring.host".equals(wire.getRequirement().getNamespace())) continue;
                            for (Wire hostWire : (List)wiring.get(wire.getProvider())) {
                                wired.add(hostWire.getProvider());
                            }
                        }
                        Iterator<BundleCapability> candIter = candidates.iterator();
                        while (candIter.hasNext()) {
                            BundleCapability cand = candIter.next();
                            BundleRevision br = cand.getRevision();
                            if ((br.getTypes() & 1) != 0) {
                                br = ((BundleWire)br.getWiring().getRequiredWires(null).get(0)).getProvider();
                            }
                            Resource res = (Resource)bndToRes.get(br.getBundle());
                            if (wired.contains(br) || wired.contains(res)) continue;
                            candIter.remove();
                        }
                    }
                }

                public void end() {
                }
            };
            ResolverHookFactory factory = new ResolverHookFactory(){

                public ResolverHook begin(Collection<BundleRevision> triggers) {
                    return hook;
                }
            };
            ServiceRegistration registration = Agent.this.systemBundleContext.registerService(ResolverHookFactory.class, (Object)factory, null);
            try {
                FrameworkWiring frameworkWiring = (FrameworkWiring)Agent.this.systemBundleContext.getBundle().adapt(FrameworkWiring.class);
                for (Bundle bundle : bundles) {
                    frameworkWiring.resolveBundles(Collections.singleton(bundle));
                }
            }
            finally {
                registration.unregister();
            }
        }

        @Override
        public void replaceDigraph(Map<String, Map<String, Map<String, Set<String>>>> policies, Map<String, Set<Long>> bundles) throws BundleException, InvalidSyntaxException {
            if (Agent.this.digraph == null) {
                if (policies.size() >= 1 && !policies.containsKey("root") || bundles.size() >= 1 && !bundles.containsKey("root")) {
                    throw new IllegalStateException("Can not update non trivial digraph as regions are not supported");
                }
                return;
            }
            RegionDigraph temp = Agent.this.digraph.copy();
            for (Region region : temp.getRegions()) {
                temp.removeRegion(region);
            }
            for (String string : policies.keySet()) {
                temp.createRegion(string);
            }
            for (Map.Entry entry : bundles.entrySet()) {
                Region region = temp.getRegion((String)entry.getKey());
                Iterator<Object> i$ = ((Set)entry.getValue()).iterator();
                while (i$.hasNext()) {
                    long l = (Long)i$.next();
                    region.addBundle(l);
                }
            }
            for (Map.Entry entry : policies.entrySet()) {
                Region region1 = temp.getRegion((String)entry.getKey());
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    Region region2 = temp.getRegion((String)entry2.getKey());
                    RegionFilterBuilder rfb = temp.createRegionFilterBuilder();
                    for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                        for (String flt : (Set)entry3.getValue()) {
                            rfb.allow((String)entry3.getKey(), flt);
                        }
                    }
                    region1.connectRegion(region2, rfb.build());
                }
            }
            Agent.this.digraph.replace(temp);
        }
    }
}

