/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.service;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.Downloader;
import io.fabric8.agent.download.StreamProvider;
import io.fabric8.agent.internal.Macro;
import io.fabric8.agent.internal.MapUtils;
import io.fabric8.agent.model.BundleInfo;
import io.fabric8.agent.model.ConfigFile;
import io.fabric8.agent.model.Feature;
import io.fabric8.agent.region.SubsystemResolver;
import io.fabric8.agent.resolver.FeatureResource;
import io.fabric8.agent.resolver.ResourceUtils;
import io.fabric8.agent.service.BundleComparator;
import io.fabric8.agent.service.Constants;
import io.fabric8.agent.service.MetadataBuilder;
import io.fabric8.agent.service.RequirementSort;
import io.fabric8.agent.service.ResourceComparator;
import io.fabric8.agent.service.State;
import io.fabric8.agent.utils.OsgiUtils;
import io.fabric8.common.util.ChecksumUtils;
import io.fabric8.common.util.MultiException;
import io.fabric8.utils.NamedThreadFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployer {
    public static final int DISPLAY_LOG = 1;
    public static final int DISPLAY_STDOUT = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(Deployer.class);
    private final DownloadManager manager;
    private final DeployCallback callback;
    private String deploymentAgentId;

    public Deployer(DownloadManager manager, DeployCallback callback) {
        this.manager = manager;
        this.callback = callback;
    }

    public void setDeploymentAgentId(String deploymentAgentId) {
        this.deploymentAgentId = deploymentAgentId;
    }

    /*
     * WARNING - void declaration
     */
    public void deploy(DeploymentState dstate, final DeploymentRequest request) throws Exception {
        boolean bl;
        Object r2;
        Bundle bundle4;
        boolean bl2;
        String threadFactoryName = this.deploymentAgentId != null ? String.format("%s-deployer", this.deploymentAgentId) : "deployer";
        ExecutorService deploymentsExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory(threadFactoryName));
        boolean noRefreshUnmanaged = request.options.contains((Object)Constants.Option.NoAutoRefreshUnmanagedBundles);
        boolean noRefreshManaged = request.options.contains((Object)Constants.Option.NoAutoRefreshManagedBundles);
        boolean noRefresh = request.options.contains((Object)Constants.Option.NoAutoRefreshBundles);
        boolean noStart = request.options.contains((Object)Constants.Option.NoAutoStartBundles);
        boolean verbose = request.options.contains((Object)Constants.Option.Verbose);
        boolean silent = request.options.contains((Object)Constants.Option.Silent);
        boolean simulate = request.options.contains((Object)Constants.Option.Simulate);
        boolean noManageBundles = request.options.contains((Object)Constants.Option.NoAutoManageBundles);
        int display = silent ? 0 : (verbose ? 3 : 1);
        Map<String, Set<Long>> managedBundles = MapUtils.copy(dstate.state.managedBundles);
        Map<String, Set<Bundle>> unmanagedBundles = MapUtils.apply(MapUtils.diff(dstate.bundlesPerRegion, dstate.state.managedBundles), MapUtils.map(dstate.bundles));
        SubsystemResolver resolver = new SubsystemResolver(this.manager);
        resolver.prepare(dstate.features.values(), request.requirements, MapUtils.apply(unmanagedBundles, this.adapt(BundleRevision.class)));
        Set<String> prereqs = resolver.collectPrerequisites();
        if (!prereqs.isEmpty()) {
            Iterator<String> iterator = prereqs.iterator();
            while (iterator.hasNext()) {
                String prereq = iterator.next();
                String[] parts = prereq.split("/");
                VersionRange range = parts[1].equals("0.0.0") ? VersionRange.ANY_VERSION : (!parts[1].startsWith("[") && !parts[1].startsWith("(") ? new VersionRange(Macro.transform(request.featureResolutionRange, parts[1])) : new VersionRange(parts[1]));
                boolean found = false;
                for (Set<String> featureSet : dstate.state.installedFeatures.values()) {
                    String feature;
                    String[] p;
                    Iterator<String> iterator2 = featureSet.iterator();
                    while (iterator2.hasNext() && !(found = parts[0].equals((p = (feature = iterator2.next()).split("/"))[0]) && range.contains(VersionTable.getVersion(p[1])))) {
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) continue;
                iterator.remove();
            }
        }
        if (!prereqs.isEmpty()) {
            DeploymentRequest newRequest = new DeploymentRequest();
            newRequest.bundleUpdateRange = request.bundleUpdateRange;
            newRequest.featureResolutionRange = request.featureResolutionRange;
            newRequest.globalRepository = request.globalRepository;
            newRequest.options = request.options;
            newRequest.overrides = request.overrides;
            newRequest.requirements = MapUtils.copy(dstate.state.requirements);
            for (String prereq : prereqs) {
                MapUtils.addToMapSet(newRequest.requirements, "root", prereq);
            }
            newRequest.stateChanges = Collections.emptyMap();
            newRequest.updateSnaphots = request.updateSnaphots;
            this.deploy(dstate, newRequest);
            throw new PartialDeploymentException(prereqs);
        }
        this.callback.phase("resolving");
        resolver.resolve(new MetadataBuilder(request.metadata), request.overrides, request.featureResolutionRange, request.globalRepository);
        Map<String, StreamProvider> providers = resolver.getProviders();
        Map<String, Set<Resource>> featuresPerRegion = resolver.getFeaturesPerRegions();
        Map<String, Set<String>> installedFeatures = MapUtils.apply(featuresPerRegion, this.featureId());
        Map<String, Set<String>> newFeatures = MapUtils.diff(installedFeatures, dstate.state.installedFeatures);
        Map<String, Set<String>> delFeatures = MapUtils.diff(dstate.state.installedFeatures, installedFeatures);
        Map<String, Map<String, String>> stateFeatures = MapUtils.copy(dstate.state.stateFeatures);
        for (Map.Entry<String, Set<String>> entry : delFeatures.entrySet()) {
            Map<String, String> map = stateFeatures.get(entry.getKey());
            if (map == null) continue;
            map.keySet().removeAll((Collection)entry.getValue());
            if (!map.isEmpty()) continue;
            stateFeatures.remove(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : request.stateChanges.entrySet()) {
            String region = entry.getKey();
            Map<String, String> regionStates = stateFeatures.get(region);
            if (regionStates == null) continue;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                String feature = (String)entry2.getKey();
                if (!regionStates.containsKey(feature)) continue;
                regionStates.put(feature, ((Constants.RequestedState)((Object)entry2.getValue())).name());
            }
        }
        for (Map.Entry<String, Object> entry : newFeatures.entrySet()) {
            for (String feature : (Set)entry.getValue()) {
                Map<String, String> map = stateFeatures.get(entry.getKey());
                if (map == null) {
                    map = new HashMap<String, String>();
                    stateFeatures.put(entry.getKey(), map);
                }
                map.put(feature, noStart ? Constants.RequestedState.Installed.name() : Constants.RequestedState.Started.name());
            }
        }
        Map<String, Map<String, BundleInfo>> bundleInfos = resolver.getBundleInfos();
        Deployment deployment = this.computeDeployment(dstate, request, resolver);
        TreeMap<Bundle, String> toRefresh = new TreeMap<Bundle, String>(new BundleComparator());
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            for (Bundle b : regionDeployment.toDelete) {
                toRefresh.put(b, "Bundle will be uninstalled");
            }
            for (Bundle b : regionDeployment.toUpdate.keySet()) {
                toRefresh.put(b, "Bundle will be updated");
            }
        }
        if (!noRefreshManaged) {
            this.computeBundlesToRefresh(toRefresh, dstate.bundles.values(), deployment.resToBnd, resolver.getWiring());
        }
        if (noRefreshUnmanaged) {
            toRefresh.keySet().removeAll(MapUtils.flatten(unmanagedBundles));
        }
        TreeSet<Bundle> toManage = new TreeSet<Bundle>(new BundleComparator());
        if (!noManageBundles) {
            Set<Resource> features = resolver.getFeatures().keySet();
            Set<BundleRevision> unmanaged = MapUtils.apply(MapUtils.flatten(unmanagedBundles), this.adapt(BundleRevision.class));
            HashSet<Resource> requested = new HashSet<Resource>();
            if (resolver.getWiring() != null) {
                for (List<Wire> wires : resolver.getWiring().values()) {
                    for (Wire wire : wires) {
                        if (!features.contains(wire.getRequirer()) || !unmanaged.contains(wire.getProvider())) continue;
                        requested.add(wire.getProvider());
                    }
                }
            }
            unmanaged.removeAll(requested);
            if (resolver.getWiring() != null) {
                for (List<Wire> wires : resolver.getWiring().values()) {
                    for (Wire wire : wires) {
                        if (!requested.contains(wire.getProvider()) || !unmanaged.contains(wire.getRequirer())) continue;
                        requested.remove(wire.getProvider());
                    }
                }
            }
            if (!requested.isEmpty()) {
                long l;
                HashMap<Long, String> bundleToRegion = new HashMap<Long, String>();
                for (Map.Entry<String, Set<Long>> entry : dstate.bundlesPerRegion.entrySet()) {
                    Iterator<Object> i$ = entry.getValue().iterator();
                    while (i$.hasNext()) {
                        l = (Long)i$.next();
                        bundleToRegion.put(l, entry.getKey());
                    }
                }
                for (Resource rev : requested) {
                    Bundle bundle2 = ((BundleRevision)rev).getBundle();
                    l = bundle2.getBundleId();
                    MapUtils.addToMapSet(managedBundles, bundleToRegion.get(l), l);
                    toManage.add(bundle2);
                }
            }
        }
        HashSet<Bundle> toStart = new HashSet<Bundle>();
        HashSet<Bundle> toResolve = new HashSet<Bundle>();
        HashSet<Object> toStop = new HashSet<Bundle>();
        HashMap<Resource, Constants.RequestedState> states = new HashMap<Resource, Constants.RequestedState>();
        HashMap<Resource, Constants.RequestedState> featuresState = new HashMap<Resource, Constants.RequestedState>();
        HashMap conditionals = new HashMap();
        if (resolver.getFeaturesPerRegions() != null) {
            for (Map.Entry entry : resolver.getFeaturesPerRegions().entrySet()) {
                String region = (String)entry.getKey();
                Map<String, String> map = stateFeatures.get(region);
                for (Resource resource : (Set)entry.getValue()) {
                    HashSet<Resource> hashSet = new HashSet<Resource>();
                    for (Wire wire : resolver.getWiring().get(resource)) {
                        if (!"osgi.identity".equals(wire.getRequirement().getNamespace()) || !"true".equals(wire.getRequirement().getDirectives().get("condition"))) continue;
                        hashSet.add(wire.getProvider());
                    }
                    if (hashSet.isEmpty()) {
                        String string = map.get(ResourceUtils.getFeatureId(resource));
                        featuresState.put(resource, Constants.RequestedState.valueOf(string));
                        continue;
                    }
                    conditionals.put(resource, hashSet);
                }
            }
        }
        for (Resource resource : conditionals.keySet()) {
            Constants.RequestedState state = null;
            for (Resource cond : (Set)conditionals.get(resource)) {
                Constants.RequestedState requestedState = (Constants.RequestedState)((Object)featuresState.get(cond));
                if (state == null) {
                    state = requestedState;
                    continue;
                }
                if (state != Constants.RequestedState.Started || requestedState != Constants.RequestedState.Resolved) continue;
                state = Constants.RequestedState.Resolved;
            }
            featuresState.put(resource, state);
        }
        for (Resource resource : featuresState.keySet()) {
            if (featuresState.get(resource) != Constants.RequestedState.Resolved) continue;
            this.propagateState(states, resource, Constants.RequestedState.Resolved, resolver);
        }
        for (Resource resource : featuresState.keySet()) {
            if (featuresState.get(resource) != Constants.RequestedState.Started) continue;
            this.propagateState(states, resource, Constants.RequestedState.Started, resolver);
        }
        for (Resource resource : resolver.getBundles().keySet()) {
            if (states.containsKey(resource)) continue;
            states.put(resource, Constants.RequestedState.Started);
        }
        for (Resource resource : featuresState.keySet()) {
            if (!(resource instanceof FeatureResource)) continue;
            FeatureResource featureResource = (FeatureResource)resource;
            List<BundleInfo> list = featureResource.getFeature().getBundles();
            for (BundleInfo bundleInfo : list) {
                int n;
                String string;
                String string2;
                String[] stringArray;
                if (bundleInfo.isStart() || (stringArray = (string2 = (string = bundleInfo.getLocation()).substring((n = string.lastIndexOf(":")) + 1)).split("/")).length < 3) continue;
                String key = stringArray[0] + "." + stringArray[1] + "/" + stringArray[2];
                for (Resource res : resolver.getBundles().keySet()) {
                    if (!res.toString().equals(key)) continue;
                    states.put(res, Constants.RequestedState.Installed);
                }
            }
        }
        states.keySet().retainAll(resolver.getBundles().keySet());
        for (Map.Entry entry : states.entrySet()) {
            Bundle bundle3 = deployment.resToBnd.get(entry.getKey());
            if (bundle3 == null) continue;
            switch ((Constants.RequestedState)((Object)entry.getValue())) {
                case Started: {
                    toResolve.add(bundle3);
                    toStart.add(bundle3);
                    break;
                }
                case Resolved: {
                    toResolve.add(bundle3);
                    toStop.add(bundle3);
                }
            }
        }
        HashMap<Resource, Integer> startLevels = new HashMap<Resource, Integer>();
        final HashMap<Bundle, Integer> hashMap = new HashMap<Bundle, Integer>();
        for (Map.Entry<String, Set<Resource>> entry : resolver.getBundlesPerRegions().entrySet()) {
            String region = entry.getKey();
            for (Resource resource : entry.getValue()) {
                int curSl;
                BundleInfo bundleInfo = bundleInfos.get(region).get(ResourceUtils.getUri(resource));
                if (bundleInfo == null) continue;
                int n = bundleInfo.getStartLevel() > 0 ? bundleInfo.getStartLevel() : dstate.initialBundleStartLevel;
                startLevels.put(resource, n);
                Bundle bundle7 = deployment.resToBnd.get(resource);
                if (bundle7 == null || n == (curSl = ((BundleStartLevel)bundle7.adapt(BundleStartLevel.class)).getStartLevel())) continue;
                hashMap.put(bundle7, n);
                if (n <= dstate.currentStartLevel) continue;
                toStop.add(bundle7);
            }
        }
        this.logDeployment(deployment, display);
        if (!noRefresh && !toRefresh.isEmpty()) {
            this.print("  Bundles to refresh:", display);
            for (Map.Entry<String, Set<Object>> entry : toRefresh.entrySet()) {
                Bundle bundle4 = (Bundle)entry.getKey();
                this.print("    " + bundle4.getSymbolicName() + " / " + bundle4.getVersion() + " (" + (String)((Object)entry.getValue()) + ")", display);
            }
        }
        if (!toManage.isEmpty()) {
            this.print("  Managing bundle:", display);
            for (Bundle bundle2 : toManage) {
                this.print("    " + bundle2.getSymbolicName() + " / " + bundle2.getVersion(), display);
            }
        }
        if (simulate) {
            return;
        }
        this.callback.phase("installing");
        RegionDeployment rootRegionDeployment = deployment.regions.get("root");
        if (rootRegionDeployment != null && rootRegionDeployment.toDelete.contains(dstate.serviceBundle)) {
            throw new UnsupportedOperationException("Uninstalling the agent bundle is not supported");
        }
        if (toRefresh.containsKey(dstate.serviceBundle)) {
            OsgiUtils.ensureAllClassesLoaded(dstate.serviceBundle);
        }
        if (rootRegionDeployment != null && rootRegionDeployment.toUpdate.containsKey(dstate.serviceBundle)) {
            this.callback.phase("updating agent");
            this.callback.persistResolveRequest(request);
            if (deployment.bundleChecksums.containsKey(dstate.serviceBundle.getBundleId())) {
                State state = dstate.state.copy();
                state.bundleChecksums.put(dstate.serviceBundle.getBundleId(), deployment.bundleChecksums.get(dstate.serviceBundle.getBundleId()));
                this.callback.saveState(state);
            }
            Resource resource = rootRegionDeployment.toUpdate.get(dstate.serviceBundle);
            String uri = ResourceUtils.getUri(resource);
            this.print("The agent bundle needs is being updated with " + uri, display);
            toRefresh.clear();
            toRefresh.put(dstate.serviceBundle, "DeploymentAgent bundle is being updated");
            this.computeBundlesToRefresh(toRefresh, dstate.bundles.values(), Collections.emptyMap(), Collections.emptyMap());
            this.callback.stopBundle(dstate.serviceBundle, 1);
            Throwable throwable = null;
            try (InputStream inputStream = this.getBundleInputStream(resource, providers);){
                this.callback.updateBundle(dstate.serviceBundle, uri, inputStream);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            this.callback.refreshPackages(toRefresh.keySet());
            this.callback.startBundle(dstate.serviceBundle);
            return;
        }
        if (!newFeatures.isEmpty()) {
            Set<Feature> set = MapUtils.apply(MapUtils.flatten(newFeatures), MapUtils.map(dstate.features));
            for (Feature feature : set) {
                Downloader downloader = this.manager.createDownloader();
                for (ConfigFile configFile : feature.getConfigurationFiles()) {
                    downloader.download(configFile.getLocation(), null);
                }
                downloader.await();
            }
        }
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            toStop.addAll(regionDeployment.toUpdate.keySet());
            toStop.addAll(regionDeployment.toDelete);
        }
        this.removeFragmentsAndBundlesInState(toStop, 21);
        if (!toStop.isEmpty()) {
            this.callback.phase("updating (stopping bundles)");
            this.print("Stopping bundles:", display);
            while (!toStop.isEmpty()) {
                List<Bundle> list = this.getBundlesToStop(toStop);
                for (final Bundle bundle3 : list) {
                    this.print("  " + bundle3.getSymbolicName() + " / " + bundle3.getVersion(), display);
                    List list2 = deploymentsExecutor.invokeAll(Arrays.asList(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            try {
                                LOGGER.info("Scheduled stop for bundle:" + bundle3.getSymbolicName() + " with a timeout limit of " + request.bundleStartTimeout + " seconds");
                                Deployer.this.callback.stopBundle(bundle3, hashMap.containsKey(bundle3) ? 0 : 1);
                            }
                            catch (BundleException e) {
                                LOGGER.warn("Error while trying to stop bundle {}", (Object)bundle3.getSymbolicName(), (Object)e);
                            }
                            return null;
                        }
                    }), request.bundleStartTimeout, TimeUnit.SECONDS);
                    for (Future future : list2) {
                        try {
                            future.get();
                        }
                        catch (CancellationException e) {
                            LOGGER.warn("Error while trying to stop bundle {}", (Object)bundle3.getSymbolicName(), (Object)e);
                        }
                    }
                    toStop.remove(bundle3);
                }
            }
        }
        boolean bl3 = false;
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            bl2 = !regionDeployment.toDelete.isEmpty();
            if (!bl2) continue;
            break;
        }
        if (bl2) {
            this.callback.phase("updating (uninstalling bundles)");
            this.print("Uninstalling bundles:", display);
            for (Map.Entry entry : deployment.regions.entrySet()) {
                String string = (String)entry.getKey();
                RegionDeployment regionDeployment = (RegionDeployment)entry.getValue();
                for (final Bundle bundle4 : regionDeployment.toDelete) {
                    this.print("  " + bundle4.getSymbolicName() + " / " + bundle4.getVersion(), display);
                    this.callback.uninstall(bundle4);
                    MapUtils.removeFromMapSet(managedBundles, string, bundle4.getBundleId());
                }
            }
        }
        HashMap<String, Set<Long>> bundles = new HashMap<String, Set<Long>>();
        MapUtils.add(bundles, MapUtils.apply(unmanagedBundles, this.bundleId()));
        MapUtils.add(bundles, managedBundles);
        RegionDigraph regionDigraph = resolver.getFlatDigraph();
        Map<String, Map<String, Map<String, Set<String>>>> map = MapUtils.copy(dstate.filtersPerRegion);
        map.keySet().retainAll(bundles.keySet());
        for (String string : map.keySet()) {
            map.get(string).keySet().retainAll(map.keySet());
        }
        for (Region region : regionDigraph.getRegions()) {
            String name = region.getName();
            Map<String, Map<String, Set<String>>> policy = map.get(name);
            if (policy == null) {
                policy = new HashMap<String, Map<String, Set<String>>>();
                map.put(name, policy);
            }
            for (RegionDigraph.FilteredRegion filteredRegion : region.getEdges()) {
                r2 = filteredRegion.getRegion().getName();
                HashMap filters = new HashMap();
                Map<String, Collection<String>> current = filteredRegion.getFilter().getSharingPolicy();
                for (String ns : current.keySet()) {
                    for (String f : current.get(ns)) {
                        MapUtils.addToMapSet(filters, ns, f);
                    }
                }
                policy.put((String)r2, filters);
            }
        }
        this.callback.replaceDigraph(map, bundles);
        boolean hasToUpdate = false;
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            hasToUpdate = !regionDeployment.toUpdate.isEmpty();
            if (!hasToUpdate) continue;
            break;
        }
        if (hasToUpdate) {
            this.callback.phase("updating (updating bundles)");
            this.print("Updating bundles:", display);
            for (Map.Entry<String, RegionDeployment> entry : deployment.regions.entrySet()) {
                for (Map.Entry<Bundle, Resource> entry2 : entry.getValue().toUpdate.entrySet()) {
                    bundle4 = entry2.getKey();
                    Resource resource = entry2.getValue();
                    String uri = ResourceUtils.getUri(resource);
                    this.print("  " + uri, display);
                    InputStream inputStream = this.getBundleInputStream(resource, providers);
                    r2 = null;
                    try {
                        this.callback.updateBundle(bundle4, uri, inputStream);
                    }
                    catch (Throwable x2) {
                        r2 = x2;
                        throw x2;
                    }
                    finally {
                        if (inputStream != null) {
                            if (r2 != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable x2) {
                                    ((Throwable)r2).addSuppressed(x2);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                    toStart.add(bundle4);
                }
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Bundle bundle5 = (Bundle)entry.getKey();
            int n = (Integer)entry.getValue();
            this.callback.setBundleStartLevel(bundle5, n);
        }
        boolean bl4 = false;
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            bl = !regionDeployment.toInstall.isEmpty();
            if (!bl) continue;
            break;
        }
        if (bl) {
            this.callback.phase("updating (installing bundles)");
            this.print("Installing bundles:", display);
            for (Map.Entry<String, RegionDeployment> entry : deployment.regions.entrySet()) {
                String string = entry.getKey();
                RegionDeployment regionDeployment = entry.getValue();
                for (Resource resource : regionDeployment.toInstall) {
                    Constants.RequestedState reqState;
                    int startLevel;
                    void bundle6;
                    long crc;
                    String string3 = ResourceUtils.getUri(resource);
                    this.print("  " + string3, display);
                    try (ChecksumUtils.CRCInputStream is = new ChecksumUtils.CRCInputStream(this.getBundleInputStream(resource, providers));){
                        Bundle bundle9 = this.callback.installBundle(string, string3, is);
                        crc = is.getCRC();
                    }
                    MapUtils.addToMapSet(managedBundles, string, bundle6.getBundleId());
                    deployment.resToBnd.put(resource, (Bundle)bundle6);
                    if ("crc".equals(request.updateSnaphots) && this.isUpdateable(resource) && !deployment.bundleChecksums.containsKey(bundle6.getBundleId())) {
                        deployment.bundleChecksums.put(bundle6.getBundleId(), crc);
                    }
                    if (startLevels.containsKey(resource) && (startLevel = ((Integer)startLevels.get(resource)).intValue()) != dstate.initialBundleStartLevel) {
                        this.callback.setBundleStartLevel((Bundle)bundle6, startLevel);
                    }
                    if ((reqState = (Constants.RequestedState)((Object)states.get(resource))) == null) {
                        reqState = Constants.RequestedState.Started;
                    }
                    switch (reqState) {
                        case Started: {
                            toResolve.add((Bundle)bundle6);
                            toStart.add((Bundle)bundle6);
                            break;
                        }
                        case Resolved: {
                            toResolve.add((Bundle)bundle6);
                        }
                    }
                }
            }
        }
        State state = new State();
        state.bundleChecksums.putAll(deployment.bundleChecksums);
        state.requirements.putAll(request.requirements);
        state.installedFeatures.putAll(installedFeatures);
        state.stateFeatures.putAll(stateFeatures);
        state.managedBundles.putAll(managedBundles);
        this.callback.saveState(state);
        if (!newFeatures.isEmpty()) {
            this.callback.phase("updating (installing configurations)");
            Set<Feature> set = MapUtils.apply(MapUtils.flatten(newFeatures), MapUtils.map(dstate.features));
            this.callback.restoreConfigAdminIfNeeded();
            for (Feature feature : set) {
                this.callback.installFeatureConfigs(feature);
            }
        }
        this.callback.phase("finalizing");
        if (!noRefresh) {
            toStop = new HashSet();
            toStop.addAll(toRefresh.keySet());
            this.removeFragmentsAndBundlesInState(toStop, 21);
            if (!toStop.isEmpty()) {
                this.callback.phase("finalizing (stopping bundles)");
                this.print("Stopping bundles:", display);
                while (!toStop.isEmpty()) {
                    List<Bundle> list = this.getBundlesToStop(toStop);
                    for (final Bundle bundle4 : list) {
                        this.print("  " + bundle4.getSymbolicName() + " / " + bundle4.getVersion(), display);
                        List futures = deploymentsExecutor.invokeAll(Arrays.asList(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                try {
                                    LOGGER.info("Scheduled stop for bundle:" + bundle4.getSymbolicName() + " with a timeout limit of " + request.bundleStartTimeout + " seconds");
                                    Deployer.this.callback.stopBundle(bundle4, 1);
                                }
                                catch (BundleException e) {
                                    LOGGER.warn("Error while trying to stop bundle {}", (Object)bundle4.getSymbolicName(), (Object)e);
                                }
                                return null;
                            }
                        }), request.bundleStartTimeout, TimeUnit.SECONDS);
                        for (Future future : futures) {
                            try {
                                future.get();
                            }
                            catch (CancellationException e) {
                                LOGGER.warn("Error while trying to stop bundle {}", (Object)bundle4.getSymbolicName(), (Object)e);
                            }
                        }
                        toStop.remove(bundle4);
                        toStart.add(bundle4);
                    }
                }
            }
            if (!toRefresh.isEmpty()) {
                this.callback.phase("finalizing (refreshing bundles)");
                this.print("Refreshing bundles:", display);
                for (Map.Entry entry : toRefresh.entrySet()) {
                    bundle4 = (Bundle)entry.getKey();
                    this.print("    " + bundle4.getSymbolicName() + " / " + bundle4.getVersion() + " (" + (String)entry.getValue() + ")", display);
                }
                if (!toRefresh.isEmpty()) {
                    this.callback.refreshPackages(toRefresh.keySet());
                }
            }
        }
        this.callback.phase("finalizing (resolving bundles)");
        toResolve.addAll(toStart);
        toResolve.addAll(toRefresh.keySet());
        this.removeBundlesInState(toResolve, 1);
        this.callback.resolveBundles(toResolve, resolver.getWiring(), deployment.resToBnd);
        boolean[] blArray = new boolean[]{false};
        this.removeFragmentsAndBundlesInState(toStart, 41);
        if (!toStart.isEmpty()) {
            final ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
            this.callback.phase("finalizing (starting bundles)");
            this.print("Starting bundles:", display);
            while (!toStart.isEmpty()) {
                List<Bundle> bs = this.getBundlesToStart(toStart, dstate.serviceBundle);
                for (final Bundle bundle10 : bs) {
                    this.print("  " + bundle10.getSymbolicName() + " / " + bundle10.getVersion(), display);
                    if ("io.fabric8.fabric-agent".equals(bundle10.getSymbolicName())) {
                        blArray[0] = true;
                    }
                    List list = deploymentsExecutor.invokeAll(Arrays.asList(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            try {
                                LOGGER.info("Scheduled start for bundle:" + bundle10.getSymbolicName() + " with a timeout limit of " + request.bundleStartTimeout + " seconds");
                                Deployer.this.callback.startBundle(bundle10);
                            }
                            catch (BundleException e) {
                                arrayList.add(e);
                            }
                            return null;
                        }
                    }), request.bundleStartTimeout, TimeUnit.SECONDS);
                    for (Future f : list) {
                        try {
                            f.get();
                        }
                        catch (CancellationException e) {
                            arrayList.add(new BundleException("Unable to start bundle [" + bundle10.getSymbolicName() + "] within " + request.bundleStartTimeout + " seconds"));
                        }
                    }
                    toStart.remove(bundle10);
                }
            }
            deploymentsExecutor.shutdown();
            if (!arrayList.isEmpty()) {
                throw new MultiException("Error restarting bundles", arrayList);
            }
        }
        this.callback.provisionList(deployment.resToBnd.keySet());
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Feature ft : dstate.features.values()) {
            if (ft.getName().equals("fabric-startup") && ft.getBundles() != null) {
                for (BundleInfo bundleInfo : ft.getBundles()) {
                    linkedList.add(bundleInfo.getLocation());
                }
            }
            if (!ft.getName().equals("esb-commands-startup") || ft.getBundles() == null) continue;
            for (BundleInfo bundleInfo : ft.getBundles()) {
                linkedList.add(bundleInfo.getLocation());
            }
        }
        if (this.callback.done(blArray[0], linkedList)) {
            this.print("Done.", display);
        }
    }

    private void propagateState(Map<Resource, Constants.RequestedState> states, Resource resource, Constants.RequestedState state, SubsystemResolver resolver) {
        Constants.RequestedState reqState;
        if (!this.isSubsystem(resource) && (reqState = this.mergeStates(state, states.get(resource))) != states.get(resource)) {
            states.put(resource, reqState);
            for (Wire wire : resolver.getWiring().get(resource)) {
                if (!"osgi.identity".equals(wire.getCapability().getNamespace())) continue;
                this.propagateState(states, wire.getProvider(), reqState, resolver);
            }
        }
    }

    private boolean isSubsystem(Resource resource) {
        return "karaf.subsystem".equals(ResourceUtils.getType(resource));
    }

    private boolean isBundle(Resource resource) {
        return "osgi.bundle".equals(ResourceUtils.getType(resource));
    }

    private Constants.RequestedState mergeStates(Constants.RequestedState s1, Constants.RequestedState s2) {
        if (s1 == Constants.RequestedState.Started || s2 == Constants.RequestedState.Started) {
            return Constants.RequestedState.Started;
        }
        if (s1 == Constants.RequestedState.Resolved || s2 == Constants.RequestedState.Resolved) {
            return Constants.RequestedState.Resolved;
        }
        return Constants.RequestedState.Installed;
    }

    private void computeBundlesToRefresh(Map<Bundle, String> toRefresh, Collection<Bundle> bundles, Map<Resource, Bundle> resources, Map<Resource, List<Wire>> resolution) {
        int size;
        HashMap newFragments = new HashMap();
        for (Bundle bundle : bundles) {
            newFragments.put(bundle, new HashSet());
        }
        if (resolution != null) {
            for (Resource res : resolution.keySet()) {
                for (Wire wire : resolution.get(res)) {
                    Bundle bundle;
                    if (!"osgi.wiring.host".equals(wire.getCapability().getNamespace()) || (bundle = resources.get(wire.getProvider())) == null) continue;
                    Bundle b = resources.get(wire.getRequirer());
                    Resource r = b != null ? (Resource)b.adapt(BundleRevision.class) : wire.getRequirer();
                    ((Set)newFragments.get(bundle)).add(r);
                }
            }
        }
        HashMap<Bundle, Resource> bndToRes = new HashMap<Bundle, Resource>();
        for (Map.Entry<Resource, Bundle> entry : resources.entrySet()) {
            bndToRes.put(entry.getValue(), entry.getKey());
        }
        block4: do {
            size = toRefresh.size();
            block5: for (Bundle bundle : bundles) {
                List<Wire> newWires;
                BundleWiring wiring;
                Resource resource = (Resource)bndToRes.get(bundle);
                if (resource == null || toRefresh.containsKey(bundle) || (wiring = (BundleWiring)bundle.adapt(BundleWiring.class)) == null || (newWires = resolution.get(resource)) == null) continue;
                HashSet<BundleRevision> oldFragments = new HashSet<BundleRevision>();
                for (BundleWire wire : wiring.getProvidedWires(null)) {
                    if (!"osgi.wiring.host".equals(wire.getCapability().getNamespace())) continue;
                    oldFragments.add(wire.getRequirer());
                }
                if (!oldFragments.equals(newFragments.get(bundle))) {
                    toRefresh.put(bundle, "Attached fragments changed: " + new ArrayList((Collection)newFragments.get(bundle)));
                    continue block4;
                }
                HashSet<Resource> wiredBundles = new HashSet<Resource>();
                for (BundleWire wire : wiring.getRequiredWires(null)) {
                    BundleRevision rev = wire.getProvider();
                    Bundle provider = rev.getBundle();
                    if (toRefresh.containsKey(provider)) {
                        toRefresh.put(bundle, "Wired to " + provider.getSymbolicName() + "/" + provider.getVersion() + " which is being refreshed");
                        continue block5;
                    }
                    Resource res = (Resource)bndToRes.get(provider);
                    wiredBundles.add((Resource)(res != null ? res : rev));
                }
                HashMap<Resource, Requirement> wiredResources = new HashMap<Resource, Requirement>();
                for (Wire wire : newWires) {
                    String effective;
                    String namespace = wire.getRequirement().getNamespace();
                    if (!namespace.equals("osgi.wiring.bundle") && !namespace.equals("osgi.wiring.package") && !namespace.equals("osgi.wiring.host") || (effective = (String)wire.getRequirement().getDirectives().get("effective")) != null && !"resolve".equals(effective) || !this.isBundle(wire.getProvider()) || wiredResources.containsKey(wire.getProvider())) continue;
                    wiredResources.put(wire.getProvider(), wire.getRequirement());
                }
                if (wiredBundles.containsAll(wiredResources.keySet())) continue;
                HashMap newResources = new HashMap(wiredResources);
                newResources.keySet().removeAll(wiredBundles);
                StringBuilder sb = new StringBuilder();
                sb.append("Should be wired to: ");
                boolean first = true;
                for (Map.Entry entry : newResources.entrySet()) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    Resource res = (Resource)entry.getKey();
                    Requirement req = (Requirement)entry.getValue();
                    sb.append(ResourceUtils.getSymbolicName(res)).append("/").append(ResourceUtils.getVersion(res));
                    sb.append(" (through ");
                    sb.append(req);
                    sb.append(")");
                }
                toRefresh.put(bundle, sb.toString());
            }
        } while (toRefresh.size() > size);
    }

    private void print(String message, int verbose) {
        this.callback.print(message, verbose);
    }

    private void removeFragmentsAndBundlesInState(Collection<Bundle> bundles, int state) {
        Iterator<Bundle> iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = iterator.next();
            if ((bundle.getState() & state) == 0 && bundle.getHeaders().get("Fragment-Host") == null) continue;
            iterator.remove();
        }
    }

    private void removeBundlesInState(Collection<Bundle> bundles, int state) {
        Iterator<Bundle> iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = iterator.next();
            if ((bundle.getState() & state) == 0) continue;
            iterator.remove();
        }
    }

    protected void logDeployment(Deployment overallDeployment, int verbose) {
        if (overallDeployment.regions.isEmpty()) {
            this.print("No deployment change.", verbose);
            return;
        }
        this.print("Changes to perform:", verbose);
        for (Map.Entry<String, RegionDeployment> region : overallDeployment.regions.entrySet()) {
            RegionDeployment deployment = region.getValue();
            this.print("  Region: " + region.getKey(), verbose);
            if (!deployment.toDelete.isEmpty()) {
                this.print("    Bundles to uninstall:", verbose);
                for (Bundle bundle : deployment.toDelete) {
                    this.print("      " + bundle.getSymbolicName() + " / " + bundle.getVersion(), verbose);
                }
            }
            if (!deployment.toUpdate.isEmpty()) {
                this.print("    Bundles to update:", verbose);
                for (Map.Entry entry : deployment.toUpdate.entrySet()) {
                    this.print("      " + ((Bundle)entry.getKey()).getSymbolicName() + " / " + ((Bundle)entry.getKey()).getVersion() + " with " + ResourceUtils.getUri((Resource)entry.getValue()), verbose);
                }
            }
            if (deployment.toInstall.isEmpty()) continue;
            this.print("    Bundles to install:", verbose);
            for (Resource resource : deployment.toInstall) {
                this.print("      " + ResourceUtils.getUri(resource), verbose);
            }
        }
    }

    protected Deployment computeDeployment(DeploymentState dstate, DeploymentRequest request, SubsystemResolver resolver) throws IOException {
        Deployment result = new Deployment();
        Map<String, Set<Resource>> bundlesPerRegions = resolver.getBundlesPerRegions();
        HashSet<String> regions = new HashSet<String>();
        regions.addAll(dstate.state.managedBundles.keySet());
        regions.addAll(bundlesPerRegions.keySet());
        for (String region : regions) {
            Set<Resource> bundlesInRegion;
            RegionDeployment deployment = new RegionDeployment();
            Set<Long> managed = dstate.state.managedBundles.get(region);
            if (managed == null) {
                managed = Collections.emptySet();
            }
            ArrayList<Resource> toDeploy = (bundlesInRegion = bundlesPerRegions.get(region)) != null ? new ArrayList<Resource>(bundlesInRegion) : new ArrayList();
            for (long bundleId : managed) {
                Bundle bundle = dstate.bundles.get(bundleId);
                if (bundle == null) continue;
                Resource resource = null;
                for (Resource res : toDeploy) {
                    if (!bundle.getSymbolicName().equals(ResourceUtils.getSymbolicName(res)) || !bundle.getVersion().equals((Object)ResourceUtils.getVersion(res))) continue;
                    resource = res;
                    break;
                }
                if (resource != null) {
                    if (this.isUpdateable(resource)) {
                        if ("always".equalsIgnoreCase(request.updateSnaphots)) {
                            LOGGER.debug("Update snapshot for " + bundle.getLocation());
                            deployment.toUpdate.put(bundle, resource);
                        } else if ("crc".equalsIgnoreCase(request.updateSnaphots)) {
                            try (InputStream is = this.getBundleInputStream(resource, resolver.getProviders());){
                                long oldCrc;
                                long newCrc = ChecksumUtils.checksum(is);
                                long l = oldCrc = dstate.state.bundleChecksums.containsKey(bundle.getBundleId()) ? dstate.state.bundleChecksums.get(bundle.getBundleId()) : 0L;
                                if (newCrc != oldCrc) {
                                    LOGGER.debug("New snapshot available for " + bundle.getLocation());
                                    deployment.toUpdate.put(bundle, resource);
                                }
                                result.bundleChecksums.put(bundle.getBundleId(), newCrc);
                            }
                        }
                    }
                    toDeploy.remove(resource);
                    result.resToBnd.put(resource, bundle);
                    continue;
                }
                if (!managed.contains(bundle.getBundleId())) continue;
                deployment.toDelete.add(bundle);
            }
            for (Resource resource : toDeploy) {
                TreeMap<Version, Bundle> matching = new TreeMap<Version, Bundle>();
                VersionRange range = new VersionRange(Macro.transform(request.bundleUpdateRange, ResourceUtils.getVersion(resource).toString()));
                for (Bundle bundle : deployment.toDelete) {
                    if (!bundle.getSymbolicName().equals(ResourceUtils.getSymbolicName(resource)) || !range.contains(bundle.getVersion())) continue;
                    matching.put(bundle.getVersion(), bundle);
                }
                if (!matching.isEmpty()) {
                    Bundle bundle = (Bundle)matching.lastEntry().getValue();
                    deployment.toUpdate.put(bundle, resource);
                    deployment.toDelete.remove(bundle);
                    result.resToBnd.put(resource, bundle);
                    continue;
                }
                deployment.toInstall.add(resource);
            }
            Collections.sort(deployment.toInstall, new ResourceComparator());
            if (deployment.toDelete.isEmpty() && deployment.toUpdate.isEmpty() && deployment.toInstall.isEmpty()) continue;
            result.regions.put(region, deployment);
        }
        return result;
    }

    protected <T> MapUtils.Function<Bundle, T> adapt(final Class<T> clazz) {
        return new MapUtils.Function<Bundle, T>(){

            @Override
            public T apply(Bundle bundle) {
                return bundle.adapt(clazz);
            }
        };
    }

    protected MapUtils.Function<Bundle, Long> bundleId() {
        return new MapUtils.Function<Bundle, Long>(){

            @Override
            public Long apply(Bundle bundle) {
                return bundle.getBundleId();
            }
        };
    }

    protected MapUtils.Function<Resource, String> featureId() {
        return new MapUtils.Function<Resource, String>(){

            @Override
            public String apply(Resource resource) {
                return ResourceUtils.getFeatureId(resource);
            }
        };
    }

    protected boolean isUpdateable(Resource resource) {
        String uri = ResourceUtils.getUri(resource);
        return uri.matches("mvn:.*-SNAPSHOT((\\.\\w{3})?|\\$.*|\\?.*|\\#.*|\\&.*)|(?!mvn:).*");
    }

    protected List<Bundle> getBundlesToStart(Collection<Bundle> bundles, Bundle serviceBundle) {
        boolean restart = false;
        TreeMap bundlesPerStartLevel = new TreeMap();
        for (Bundle bundle : bundles) {
            if (bundle == serviceBundle) {
                restart = true;
                continue;
            }
            int n = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
            MapUtils.addToMapSet(bundlesPerStartLevel, n, bundle);
        }
        bundles = bundlesPerStartLevel.isEmpty() ? Collections.emptyList() : (Collection<Object>)bundlesPerStartLevel.remove(bundlesPerStartLevel.firstKey());
        ArrayList<Object> revs = new ArrayList<Object>();
        for (Bundle bundle : bundles) {
            revs.add(bundle.adapt(BundleRevision.class));
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        for (BundleRevision rev : RequirementSort.sort(revs)) {
            arrayList.add(rev.getBundle());
        }
        if (arrayList.isEmpty() && restart) {
            arrayList.add(serviceBundle);
        }
        return arrayList;
    }

    protected List<Bundle> getBundlesToStop(Collection<Bundle> bundles) {
        TreeMap bundlesPerStartLevel = new TreeMap();
        for (Bundle bundle : bundles) {
            int sl = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
            MapUtils.addToMapSet(bundlesPerStartLevel, sl, bundle);
        }
        bundles = (Collection)bundlesPerStartLevel.get(bundlesPerStartLevel.lastKey());
        ArrayList<Bundle> bundlesToDestroy = new ArrayList<Bundle>();
        for (Bundle bundle : bundles) {
            ServiceReference[] references = bundle.getRegisteredServices();
            int usage = 0;
            if (references != null) {
                for (ServiceReference reference : references) {
                    usage += Deployer.getServiceUsage(reference, bundles);
                }
            }
            LOGGER.debug("Usage for bundle {} is {}", (Object)bundle, (Object)usage);
            if (usage != 0) continue;
            bundlesToDestroy.add(bundle);
        }
        if (!bundlesToDestroy.isEmpty()) {
            Collections.sort(bundlesToDestroy, new Comparator<Bundle>(){

                @Override
                public int compare(Bundle b1, Bundle b2) {
                    return (int)(b2.getLastModified() - b1.getLastModified());
                }
            });
            LOGGER.debug("Selected bundles {} for destroy (no services in use)", bundlesToDestroy);
        } else {
            ServiceReference ref = null;
            for (Bundle bundle : bundles) {
                ServiceReference[] references;
                for (ServiceReference reference : references = bundle.getRegisteredServices()) {
                    if (Deployer.getServiceUsage(reference, bundles) == 0 || ref != null && reference.compareTo(ref) >= 0) continue;
                    LOGGER.debug("Currently selecting bundle {} for destroy (with reference {})", (Object)bundle, (Object)reference);
                    ref = reference;
                }
            }
            if (ref != null) {
                bundlesToDestroy.add(ref.getBundle());
            }
            LOGGER.debug("Selected bundle {} for destroy (lowest ranking service)", bundlesToDestroy);
        }
        return bundlesToDestroy;
    }

    private static int getServiceUsage(ServiceReference ref, Collection<Bundle> bundles) {
        Bundle[] usingBundles = ref.getUsingBundles();
        int nb = 0;
        if (usingBundles != null) {
            for (Bundle bundle : usingBundles) {
                if (!bundles.contains(bundle)) continue;
                ++nb;
            }
        }
        return nb;
    }

    protected InputStream getBundleInputStream(Resource resource, Map<String, StreamProvider> providers) throws IOException {
        String uri = ResourceUtils.getUri(resource);
        if (uri == null) {
            throw new IllegalStateException("Resource has no uri");
        }
        StreamProvider provider = providers.get(uri);
        if (provider == null) {
            throw new IllegalStateException("Resource " + uri + " has no StreamProvider");
        }
        return new FileInputStream(provider.getFile());
    }

    static class RegionDeployment {
        List<Resource> toInstall = new ArrayList<Resource>();
        List<Bundle> toDelete = new ArrayList<Bundle>();
        Map<Bundle, Resource> toUpdate = new HashMap<Bundle, Resource>();

        RegionDeployment() {
        }
    }

    static class Deployment {
        Map<Long, Long> bundleChecksums = new HashMap<Long, Long>();
        Map<Resource, Bundle> resToBnd = new HashMap<Resource, Bundle>();
        Map<String, RegionDeployment> regions = new HashMap<String, RegionDeployment>();

        Deployment() {
        }
    }

    static class DeploymentRequest {
        Set<String> overrides;
        String featureResolutionRange;
        String bundleUpdateRange;
        String updateSnaphots;
        Repository globalRepository;
        Map<String, Map<VersionRange, Map<String, String>>> metadata;
        Map<String, Set<String>> requirements;
        Map<String, Map<String, Constants.RequestedState>> stateChanges;
        EnumSet<Constants.Option> options;
        int bundleStartTimeout;

        DeploymentRequest() {
        }
    }

    static class DeploymentState {
        State state;
        Bundle serviceBundle;
        int initialBundleStartLevel;
        int currentStartLevel;
        Map<Long, Bundle> bundles;
        Map<String, Feature> features;
        Map<String, Set<Long>> bundlesPerRegion;
        Map<String, Map<String, Map<String, Set<String>>>> filtersPerRegion;

        DeploymentState() {
        }
    }

    public static class PartialDeploymentException
    extends Exception {
        private final Set<String> missing;

        public PartialDeploymentException(Set<String> missing) {
            this.missing = missing;
        }

        public Set<String> getMissing() {
            return this.missing;
        }
    }

    public static interface DeployCallback {
        public void phase(String var1);

        public void print(String var1, int var2);

        public void saveState(State var1);

        public void persistResolveRequest(DeploymentRequest var1) throws IOException;

        public void installFeatureConfigs(Feature var1) throws IOException, InvalidSyntaxException;

        public Bundle installBundle(String var1, String var2, InputStream var3) throws BundleException;

        public void updateBundle(Bundle var1, String var2, InputStream var3) throws BundleException;

        public void uninstall(Bundle var1) throws BundleException;

        public void startBundle(Bundle var1) throws BundleException;

        public void stopBundle(Bundle var1, int var2) throws BundleException;

        public void setBundleStartLevel(Bundle var1, int var2);

        public void refreshPackages(Collection<Bundle> var1) throws InterruptedException;

        public void resolveBundles(Set<Bundle> var1, Map<Resource, List<Wire>> var2, Map<Resource, Bundle> var3);

        public void replaceDigraph(Map<String, Map<String, Map<String, Set<String>>>> var1, Map<String, Set<Long>> var2) throws BundleException, InvalidSyntaxException;

        public void provisionList(Set<Resource> var1);

        public void restoreConfigAdminIfNeeded();

        public boolean done(boolean var1, List<String> var2);
    }
}

