/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.service;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.model.Config;
import io.fabric8.agent.model.ConfigFile;
import io.fabric8.agent.model.Feature;
import io.fabric8.common.util.Files;
import io.fabric8.common.util.Strings;
import io.fabric8.utils.BundleUtils;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureConfigInstaller {
    public static final String FABRIC_ZOOKEEPER_PID = "fabric.zookeeper.pid";
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureConfigInstaller.class);
    private static final String CONFIG_KEY = "org.apache.karaf.features.configKey";
    private ConfigurationAdmin configAdmin;
    private final DownloadManager manager;
    private final BundleContext context;

    public FeatureConfigInstaller(BundleContext context, ConfigurationAdmin configAdmin, DownloadManager manager) {
        this.context = context;
        this.configAdmin = configAdmin;
        this.manager = manager;
    }

    private String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    private Configuration createConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        if (factoryPid != null) {
            return configurationAdmin.createFactoryConfiguration(pid, null);
        }
        return configurationAdmin.getConfiguration(pid, null);
    }

    private Configuration findExistingConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        String filter;
        if (factoryPid == null) {
            filter = "(service.pid=" + pid + ")";
        } else {
            String key = this.createConfigurationKey(pid, factoryPid);
            filter = "(org.apache.karaf.features.configKey=" + key + ")";
        }
        Configuration[] configurations = configurationAdmin.listConfigurations(filter);
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    void installFeatureConfigs(Feature feature) throws IOException, InvalidSyntaxException {
        for (Config config : feature.getConfigurations()) {
            Dictionary properties;
            String fabricManagedPid;
            String subname;
            Properties props = config.getProperties();
            String[] split = this.parsePid(config.getName());
            String pid = split[0];
            Configuration cfg = this.findExistingConfiguration(this.configAdmin, pid, subname = split[1]);
            if (cfg == null) {
                Dictionary<String, String> cfgProps = this.convertToDict(props);
                cfg = this.createConfiguration(this.configAdmin, pid, subname);
                String key = this.createConfigurationKey(pid, subname);
                cfgProps.put(CONFIG_KEY, key);
                cfg.update(cfgProps);
                continue;
            }
            if (!config.isAppend() || Strings.isNotBlank(fabricManagedPid = (String)(properties = cfg.getProperties()).get(FABRIC_ZOOKEEPER_PID))) continue;
            Enumeration propKeys = properties.keys();
            while (propKeys.hasMoreElements()) {
                String key = (String)propKeys.nextElement();
                if (!props.containsKey(key)) continue;
                props.remove(key);
            }
            if (props.size() <= 0) continue;
            Dictionary<String, String> cfgProps = this.convertToDict(props);
            cfg.update(cfgProps);
        }
        for (ConfigFile configFile : feature.getConfigurationFiles()) {
            this.installConfigurationFile(configFile.getLocation(), configFile.getFinalname(), configFile.isOverride());
        }
    }

    private Dictionary<String, String> convertToDict(Properties props) {
        Hashtable<String, String> cfgProps = new Hashtable<String, String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = props.getProperty(key);
            ((Dictionary)cfgProps).put(key, val);
        }
        return cfgProps;
    }

    private String createConfigurationKey(String pid, String factoryPid) {
        return factoryPid == null ? pid : pid + "-" + factoryPid;
    }

    private void installConfigurationFile(String fileLocation, String finalname, boolean override) throws IOException {
        File file;
        String basePath = System.getProperty("karaf.base");
        if (finalname.contains("${")) {
            int marker = finalname.indexOf("}");
            finalname = finalname.substring(marker + 1);
        }
        if ((file = new File(finalname = basePath + File.separator + finalname)).exists()) {
            if (!override) {
                LOGGER.debug("Configuration file {} already exist, don't override it", (Object)finalname);
                return;
            }
            LOGGER.info("Configuration file {} already exist, overriding it", (Object)finalname);
        } else {
            LOGGER.info("Creating configuration file {}", (Object)finalname);
        }
        File downloaded = this.manager.getProviders().get(fileLocation).getFile();
        Files.copy(downloaded, file);
    }

    public void restoreConfigAdminIfNeeded() {
        Bundle b = null;
        try {
            b = new BundleUtils(this.context).findBundle("org.apache.felix.configadmin");
            if (b.getState() != 32) {
                b.start();
                ServiceReference ref = this.context.getServiceReference(ConfigurationAdmin.class);
                if (ref != null) {
                    this.configAdmin = (ConfigurationAdmin)this.context.getService(ref);
                }
            }
        }
        catch (BundleException e) {
            this.configAdmin = null;
            LOGGER.warn(e.getMessage());
        }
    }
}

