/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.service;

import io.fabric8.agent.resolver.CapabilitySet;
import io.fabric8.agent.resolver.SimpleFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public final class RequirementSort {
    private RequirementSort() {
    }

    public static <T extends Resource> Collection<T> sort(Collection<T> resources) {
        HashSet<String> namespaces = new HashSet<String>();
        for (Resource r : resources) {
            for (Capability cap : r.getCapabilities(null)) {
                namespaces.add(cap.getNamespace());
            }
        }
        CapabilitySet capSet = new CapabilitySet(new ArrayList<String>(namespaces));
        for (Resource r : resources) {
            for (Capability cap : r.getCapabilities(null)) {
                capSet.addCapability(cap);
            }
        }
        LinkedHashSet sorted = new LinkedHashSet();
        LinkedHashSet visited = new LinkedHashSet();
        for (Resource r : resources) {
            RequirementSort.visit(r, visited, sorted, capSet);
        }
        return sorted;
    }

    private static <T extends Resource> void visit(T resource, Set<T> visited, Set<T> sorted, CapabilitySet capSet) {
        if (!visited.add(resource)) {
            return;
        }
        for (T r : RequirementSort.collectDependencies(resource, capSet)) {
            RequirementSort.visit(r, visited, sorted, capSet);
        }
        sorted.add(resource);
    }

    private static <T extends Resource> Set<T> collectDependencies(T resource, CapabilitySet capSet) {
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        for (Requirement requirement : resource.getRequirements(null)) {
            String filter = (String)requirement.getDirectives().get("filter");
            SimpleFilter sf = filter != null ? SimpleFilter.parse(filter) : new SimpleFilter(null, null, 0);
            for (Capability cap : capSet.match(sf, true)) {
                result.add(cap.getResource());
            }
        }
        return result;
    }
}

