/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.service;

import io.fabric8.agent.internal.MapUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class State {
    public final AtomicBoolean bootDone = new AtomicBoolean();
    public final Set<String> repositories = new TreeSet<String>();
    public final Map<String, Set<String>> requirements = new HashMap<String, Set<String>>();
    public final Map<String, Set<String>> installedFeatures = new HashMap<String, Set<String>>();
    public final Map<String, Map<String, String>> stateFeatures = new HashMap<String, Map<String, String>>();
    public final Map<String, Set<Long>> managedBundles = new HashMap<String, Set<Long>>();
    public final Map<Long, Long> bundleChecksums = new HashMap<Long, Long>();

    public State copy() {
        State state = new State();
        State.copy(this, state, false);
        return state;
    }

    public void replace(State state) {
        State.copy(state, this, true);
    }

    private static void copy(State from, State to, boolean clear) {
        if (clear) {
            to.repositories.clear();
            to.requirements.clear();
            to.installedFeatures.clear();
            to.stateFeatures.clear();
            to.managedBundles.clear();
            to.bundleChecksums.clear();
        }
        to.bootDone.set(from.bootDone.get());
        MapUtils.copy(from.repositories, to.repositories);
        MapUtils.copy(from.requirements, to.requirements);
        MapUtils.copy(from.installedFeatures, to.installedFeatures);
        MapUtils.copy(from.stateFeatures, to.stateFeatures);
        MapUtils.copy(from.managedBundles, to.managedBundles);
        MapUtils.copy(from.bundleChecksums, to.bundleChecksums);
    }
}

