/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.utils;

import io.fabric8.agent.download.DownloadCallback;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.Downloader;
import io.fabric8.agent.download.StreamProvider;
import io.fabric8.agent.model.BundleInfo;
import io.fabric8.agent.model.Dependency;
import io.fabric8.agent.model.Feature;
import io.fabric8.agent.model.Repository;
import io.fabric8.agent.utils.FeatureUtils;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileService;
import io.fabric8.common.util.MultiException;
import io.fabric8.common.util.Strings;
import io.fabric8.maven.util.Parser;
import io.fabric8.service.VersionPropertyPointerResolver;
import io.fabric8.utils.PatchUtils;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.maven.settings.Mirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentUtils.class);

    public static Map<String, Parser> getProfileArtifacts(FabricService fabricService, DownloadManager downloadManager, Profile profile) throws Exception {
        return AgentUtils.getProfileArtifacts(fabricService, downloadManager, profile, null);
    }

    public static Map<String, Parser> getProfileArtifacts(FabricService fabricService, DownloadManager downloadManager, Profile profile, Callback<String> callback) throws Exception {
        List bundles = profile.getBundles();
        Set<Feature> features = AgentUtils.getFeatures(fabricService, downloadManager, profile);
        return AgentUtils.getProfileArtifacts(fabricService, profile, bundles, features, callback);
    }

    public static Set<Feature> getFeatures(FabricService fabricService, DownloadManager downloadManager, Profile profile) throws Exception {
        HashSet<Feature> features = new HashSet<Feature>();
        AgentUtils.addFeatures(features, fabricService, downloadManager, profile);
        return features;
    }

    public static Map<String, Parser> getProfileArtifacts(FabricService fabricService, Profile profile, Iterable<String> bundles, Iterable<Feature> features) {
        return AgentUtils.getProfileArtifacts(fabricService, profile, bundles, features, null);
    }

    public static Map<String, Parser> getProfileArtifacts(FabricService fabricService, Profile profile, Iterable<String> bundles, Iterable<Feature> features, Callback<String> nonMavenLocationCallback) {
        HashSet<String> locations = new HashSet<String>();
        for (Feature feature : features) {
            List<BundleInfo> bundleList = feature.getBundles();
            if (bundleList == null) {
                LOGGER.warn("No bundles for feature " + feature);
                continue;
            }
            for (BundleInfo bundle : bundleList) {
                locations.add(bundle.getLocation());
            }
        }
        for (String bundle : bundles) {
            locations.add(bundle);
        }
        HashMap<String, Parser> artifacts = new HashMap<String, Parser>();
        for (String location : locations) {
            try {
                if (location.contains("$")) {
                    ProfileService profileService = (ProfileService)fabricService.adapt(ProfileService.class);
                    Profile overlay = profileService.getOverlayProfile(profile);
                    location = VersionPropertyPointerResolver.replaceVersions((FabricService)fabricService, (Map)overlay.getConfigurations(), (String)location);
                }
                if (location.startsWith("mvn:") || location.contains(":mvn:")) {
                    Parser parser = Parser.parsePathWithSchemePrefix((String)location);
                    artifacts.put(location, parser);
                    continue;
                }
                if (nonMavenLocationCallback == null) continue;
                nonMavenLocationCallback.call(location);
            }
            catch (MalformedURLException e) {
                LOGGER.error("Failed to parse bundle URL: " + location + ". " + e, (Throwable)e);
            }
        }
        return artifacts;
    }

    protected static Map<String, Repository> getRepositories(FabricService fabricService, DownloadManager downloadManager, Profile profile) throws Exception {
        HashSet<String> uris = new HashSet<String>();
        for (String repositoryUrl : profile.getRepositories()) {
            if (!Strings.isNotBlank(repositoryUrl)) continue;
            String replacedUrl = repositoryUrl;
            if (repositoryUrl.contains("$")) {
                replacedUrl = VersionPropertyPointerResolver.replaceVersions((FabricService)fabricService, (Map)profile.getConfigurations(), (String)repositoryUrl);
            }
            uris.add(replacedUrl);
        }
        return AgentUtils.downloadRepositories(downloadManager, uris).call();
    }

    public static void addFeatures(Set<Feature> features, FabricService fabricService, DownloadManager downloadManager, Profile profile) throws Exception {
        List featureNames = profile.getFeatures();
        Map<String, Repository> repositories = AgentUtils.getRepositories(fabricService, downloadManager, profile);
        for (String featureName : featureNames) {
            Feature feature = FeatureUtils.search(featureName, repositories.values());
            if (feature == null) {
                LOGGER.warn("Could not find feature " + featureName + " for profile " + profile.getId() + " in repositories " + repositories.keySet());
                continue;
            }
            features.addAll(AgentUtils.expandFeature(feature, repositories));
        }
    }

    public static Set<Feature> expandFeature(Feature feature, Map<String, Repository> repositories) {
        HashSet<Feature> features = new HashSet<Feature>();
        for (Dependency f : feature.getDependencies()) {
            Feature loaded = FeatureUtils.search(f.getName(), repositories.values());
            features.addAll(AgentUtils.expandFeature(loaded, repositories));
        }
        features.add(feature);
        return features;
    }

    public static Callable<Map<String, Repository>> downloadRepositories(DownloadManager manager, Set<String> uris) throws MultiException, InterruptedException, MalformedURLException {
        final HashMap repositories = new HashMap();
        final Downloader downloader = manager.createDownloader();
        for (String uri : uris) {
            downloader.download(uri, new DownloadCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void downloaded(StreamProvider provider) throws Exception {
                    String uri = provider.getUrl();
                    Repository repository = new Repository(URI.create(uri));
                    repository.load(new FileInputStream(provider.getFile()), true);
                    Map map = repositories;
                    synchronized (map) {
                        repositories.put(uri, repository);
                    }
                    for (URI repo : repository.getRepositories()) {
                        downloader.download(repo.toASCIIString(), this);
                    }
                }
            });
        }
        return new Callable<Map<String, Repository>>(){

            @Override
            public Map<String, Repository> call() throws Exception {
                downloader.await();
                return repositories;
            }
        };
    }

    public static Map<String, File> downloadLocations(DownloadManager manager, Collection<String> uris) throws MultiException, InterruptedException, MalformedURLException {
        final HashMap<String, File> files = new HashMap<String, File>();
        Downloader downloader = manager.createDownloader();
        for (String uri : uris) {
            downloader.download(uri, new DownloadCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void downloaded(StreamProvider provider) throws Exception {
                    String uri = provider.getUrl();
                    File file = provider.getFile();
                    Map map = files;
                    synchronized (map) {
                        files.put(uri, file);
                    }
                }
            });
        }
        downloader.await();
        return files;
    }

    public static Map<String, File> downloadProfileArtifacts(FabricService fabricService, DownloadManager downloadManager, Profile profile) throws Exception {
        List bundles = profile.getBundles();
        Set<Feature> features = AgentUtils.getFeatures(fabricService, downloadManager, profile);
        return AgentUtils.downloadBundles(downloadManager, features, bundles, Collections.emptySet());
    }

    public static Map<String, File> downloadBundles(DownloadManager manager, Iterable<Feature> features, Iterable<String> bundles, Set<String> overrides) throws Exception {
        return AgentUtils.downloadBundles(manager, features, bundles, overrides, false);
    }

    public static Map<String, File> downloadBundles(DownloadManager manager, Iterable<Feature> features, Iterable<String> bundles, Set<String> overrides, boolean ignoreProfileUrls) throws Exception {
        HashSet<String> locations = new HashSet<String>();
        for (Feature feature : features) {
            for (BundleInfo bundle : feature.getBundles()) {
                locations.add(bundle.getLocation());
            }
        }
        for (String bundle : bundles) {
            locations.add(bundle);
        }
        for (String override : overrides) {
            locations.add(PatchUtils.extractUrl(override));
        }
        if (ignoreProfileUrls) {
            Iterator it = locations.iterator();
            while (it.hasNext()) {
                if (!((String)it.next()).startsWith("profile:")) continue;
                it.remove();
            }
        }
        return AgentUtils.downloadLocations(manager, locations);
    }

    public static Mirror getMavenProxy(FabricService fabricService) {
        try {
            if (fabricService != null) {
                String httpUrl = fabricService.getCurrentContainer().getHttpUrl();
                List uris = fabricService.getMavenRepoURIs();
                if (uris == null || uris.isEmpty()) {
                    return null;
                }
                URI uri = (URI)uris.get(0);
                if (uri.toString().startsWith(httpUrl)) {
                    return null;
                }
                Mirror mirror = new Mirror();
                mirror.setName("fabric-maven-proxy");
                mirror.setUrl(uri.toURL().toExternalForm());
                mirror.setMirrorOf("*");
                return mirror;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to retrieve maven proxy urls: " + e.getMessage());
            LOGGER.debug("Unable to retrieve maven proxy urls: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static void addMavenProxies(Dictionary<String, String> props, String httpUrl, List<URI> mavenRepoUris) {
        try {
            if (httpUrl != null && mavenRepoUris != null) {
                StringBuilder sb = new StringBuilder();
                for (URI uri : mavenRepoUris) {
                    String mavenRepo = uri.toString();
                    if (mavenRepo.startsWith(httpUrl)) continue;
                    if (!mavenRepo.endsWith("/")) {
                        mavenRepo = mavenRepo + "/";
                    }
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(mavenRepo);
                    sb.append("@snapshots@snapshotsUpdate=always");
                }
                String existingRepos = props.get("org.ops4j.pax.url.mvn.repositories");
                if (existingRepos != null) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(existingRepos);
                }
                props.put("org.ops4j.pax.url.mvn.repositories", sb.toString());
            } else {
                if (httpUrl == null) {
                    LOGGER.warn("Could not get httpUrl from fabricService");
                }
                if (mavenRepoUris == null) {
                    LOGGER.warn("Could not get mavenRepoUris from fabricService");
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to retrieve maven proxy urls: " + e.getMessage());
            LOGGER.debug("Unable to retrieve maven proxy urls: " + e.getMessage(), (Throwable)e);
        }
    }

    public static interface Callback<T> {
        public void call(T var1);
    }
}

