/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.http;

import io.fabric8.git.GitService;
import io.fabric8.zookeeper.ZkPath;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.shared.SharedCount;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.http.server.GitServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricGitServlet
extends GitServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricGitServlet.class);
    private final CuratorFramework curator;
    private SharedCount counter;
    private Git git;

    FabricGitServlet(Git git, CuratorFramework curator) {
        this.curator = curator;
        this.git = git;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.counter = new SharedCount(this.curator, ZkPath.GIT_TRIGGER.getPath(new String[0]), 0);
            this.counter.start();
            Thread currentThread = Thread.currentThread();
            ClassLoader backupClassLoader = null;
            try {
                backupClassLoader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(GitService.class.getClassLoader());
                Class.forName("org.eclipse.jgit.lib.BatchingProgressMonitor");
            }
            finally {
                currentThread.setContextClassLoader(backupClassLoader);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void handleException(Exception ex) throws ServletException {
        if (ex instanceof IllegalStateException && "Client is not started".equals(ex.getMessage())) {
            LOGGER.debug("", (Throwable)ex);
            throw new ServletException("Error starting SharedCount. ZK Client is not Started");
        }
        LOGGER.error("Error starting SharedCount", (Throwable)ex);
        throw new ServletException("Error starting SharedCount", (Throwable)ex);
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.counter.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Error closing SharedCount due to: " + ex + ". This exception is ignored.");
        }
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        LOGGER.debug("GitHttp service req={}", (Object)req);
        super.service(req, res);
        LOGGER.debug("GitHttp service res={}", (Object)res);
        String resContentType = res.getContentType();
        if (resContentType.contains("x-git-receive-pack-result")) {
            LOGGER.info("GitHttp service res={}", (Object)res);
            int httpStatus = 0;
            try {
                Method method = res.getClass().getMethod("getStatus", new Class[0]);
                httpStatus = (Integer)method.invoke((Object)res, new Object[0]);
            }
            catch (Exception ex) {
                LOGGER.error("Cannot obtain http response code: " + ex);
            }
            if (httpStatus == 200) {
                if (LOGGER.isDebugEnabled()) {
                    try {
                        List refs = this.git.branchList().call();
                        LOGGER.debug("Remote git content updated: {}", (Object)refs);
                    }
                    catch (Exception refs) {
                        // empty catch block
                    }
                }
                try {
                    while (!this.counter.trySetCount(this.counter.getCount() + 1)) {
                    }
                }
                catch (Exception ex) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Error incrementing shared counter: " + ex + ". This exception is ignored.", (Throwable)ex);
                    }
                    LOGGER.warn("Error incrementing shared counter: " + ex + ". This exception is ignored.");
                }
            }
        }
    }
}

