/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.http;

import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.git.GitDataStore;
import io.fabric8.git.GitHttpEndpoint;
import io.fabric8.git.GitNode;
import io.fabric8.git.http.FabricGitServlet;
import io.fabric8.git.http.GitSecureHttpContext;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ZooKeeperGroup;
import io.fabric8.utils.NamedThreadFactory;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.util.FileUtils;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.git.server", label="Fabric8 Git HTTP Server Registration Handler", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={GitHttpEndpoint.class})
public final class GitHttpServerRegistrationHandler
extends AbstractComponent
implements GitHttpEndpoint,
GroupListener<GitNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHttpServerRegistrationHandler.class);
    private static final String REALM_PROPERTY_NAME = "realm";
    private static final String ROLE_PROPERTY_NAME = "role";
    private static final String DEFAULT_ROLE = "admin";
    private static final String DEFAULT_REALM = "karaf";
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=HttpService.class)
    private final ValidatingReference<HttpService> httpService = new ValidatingReference();
    @Reference(referenceInterface=GitDataStore.class)
    private final ValidatingReference<GitDataStore> gitDataStore = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference
    private FabricService fabricService;
    private final AtomicBoolean isMaster = new AtomicBoolean();
    private final AtomicReference<String> gitRemoteUrl = new AtomicReference();
    private Group<GitNode> group;
    private Path basePath;
    private Git git;
    private String realm;
    private String role;
    private Path dataPath;

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        this.realm = this.getConfiguredRealm(sysprops, configuration);
        this.role = this.getConfiguredRole(sysprops, configuration);
        this.dataPath = sysprops.getDataPath();
        this.activateComponent();
        this.group = new ZooKeeperGroup((CuratorFramework)this.curator.get(), ZkPath.GIT.getPath(new String[0]), GitNode.class, (ThreadFactory)new NamedThreadFactory("zkgroup-git-httpreg"));
        this.zkCleanUp(this.group);
        this.group.add((GroupListener)this);
        this.group.update((NodeState)this.createState());
        this.group.start();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        this.unregisterServlet();
        try {
            if (this.group != null) {
                this.group.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to remove git server from registry.", (Throwable)e);
        }
    }

    public void groupEvent(Group<GitNode> group, GroupListener.GroupEvent event) {
        if (this.isValid()) {
            switch (event) {
                case CONNECTED: 
                case CHANGED: {
                    this.updateMasterUrl(group);
                    break;
                }
            }
        }
    }

    private String getConfiguredRealm(RuntimeProperties sysprops, Map<String, ?> configuration) {
        String realm = (String)configuration.get(REALM_PROPERTY_NAME);
        if (realm == null) {
            realm = DEFAULT_REALM;
        }
        return realm;
    }

    private String getConfiguredRole(RuntimeProperties sysprops, Map<String, ?> configuration) {
        return configuration.containsKey(ROLE_PROPERTY_NAME) ? (String)configuration.get(ROLE_PROPERTY_NAME) : DEFAULT_ROLE;
    }

    private void updateMasterUrl(Group<GitNode> group) {
        try {
            if (group.isMaster()) {
                LOGGER.debug("Git repo is the master");
                if (!this.isMaster.getAndSet(true)) {
                    this.registerServlet(this.dataPath, this.realm, this.role);
                }
            } else {
                LOGGER.debug("Git repo is not the master");
                if (this.isMaster.getAndSet(false)) {
                    this.unregisterServlet();
                }
            }
            GitNode state = this.createState();
            group.update((NodeState)state);
            String url = state.getUrl();
            this.gitRemoteUrl.set(ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)url));
        }
        catch (Exception e) {
            LOGGER.debug("Failed to update master git server url.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerServlet(Path dataPath, String realm, String role) throws Exception {
        AtomicReference<String> atomicReference = this.gitRemoteUrl;
        synchronized (atomicReference) {
            this.basePath = dataPath.resolve(Paths.get("git", "servlet"));
            Path fabricRepoPath = this.basePath.resolve("fabric");
            String servletBase = this.basePath.toFile().getAbsolutePath();
            File fabricRoot = fabricRepoPath.toFile();
            if (!fabricRoot.exists()) {
                LOGGER.info("Cloning master root repo into {}", (Object)fabricRoot);
                File localRepo = ((GitDataStore)this.gitDataStore.get()).getGit().getRepository().getDirectory();
                this.git = ((CloneCommand)Git.cloneRepository().setTimeout(10)).setBare(true).setNoCheckout(true).setCloneAllBranches(true).setDirectory(fabricRoot).setURI(localRepo.toURI().toString()).call();
            } else {
                LOGGER.info("{} already exists", (Object)fabricRoot);
                this.git = Git.open((File)fabricRoot);
            }
            HttpContext base = ((HttpService)this.httpService.get()).createDefaultHttpContext();
            GitSecureHttpContext secure = new GitSecureHttpContext(base, (CuratorFramework)this.curator.get(), realm, role);
            Hashtable<String, String> initParams = new Hashtable<String, String>();
            ((Dictionary)initParams).put("base-path", servletBase);
            ((Dictionary)initParams).put("repository-root", servletBase);
            ((Dictionary)initParams).put("export-all", "true");
            ((HttpService)this.httpService.get()).registerServlet("/git", (Servlet)new FabricGitServlet(this.git, (CuratorFramework)this.curator.get()), initParams, (HttpContext)secure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterServlet() {
        AtomicReference<String> atomicReference = this.gitRemoteUrl;
        synchronized (atomicReference) {
            if (this.basePath != null) {
                try {
                    ((HttpService)this.httpService.get()).unregister("/git");
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("/git Servlet wasn't registered. Unregistration not required.");
                }
                WindowCacheConfig cfg = new WindowCacheConfig();
                cfg.install();
                this.git.getRepository().close();
                this.git = null;
                boolean basePathExists = this.basePath.toFile().exists();
                for (int i = 0; i < 10; ++i) {
                    try {
                        if (!basePathExists) break;
                        this.recursiveDelete(this.basePath.toFile());
                        basePathExists = false;
                        break;
                    }
                    catch (IOException e) {
                        LOGGER.debug("Failed to recursively delete this filesystem path: {}", (Object)this.basePath, (Object)e);
                        System.gc();
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                }
                if (basePathExists) {
                    LOGGER.error("Failed to recursively delete this filesystem path: {}", (Object)this.basePath);
                } else {
                    LOGGER.info("Correctly removed old git repo: {}", (Object)this.basePath);
                }
            }
        }
    }

    private void recursiveDelete(File file) throws IOException {
        FileUtils.delete((File)file, (int)3);
        LOGGER.info("Deleted path: {}", (Object)file.getAbsoluteFile());
    }

    private String readExternalGitUrl() {
        String result = null;
        try {
            Configuration conf = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration("io.fabric8.datastore");
            if (conf == null) {
                LOGGER.warn("No configuration for pid io.fabric8.datastore");
            } else {
                Object o;
                Dictionary properties = conf.getProperties();
                result = properties != null ? ((o = conf.getProperties().get("gitRemoteUrl")) != null ? o.toString() : null) : null;
            }
        }
        catch (Throwable e) {
            LOGGER.error("Could not load config admin for pid io.fabric8.datastore. Reason: " + e, e);
        }
        return result;
    }

    private GitNode createState() {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        String runtimeIdentity = sysprops.getRuntimeIdentity();
        GitNode state = new GitNode("fabric-repo", runtimeIdentity);
        if (this.group != null && this.group.isMaster()) {
            String externalGitUrl = this.readExternalGitUrl();
            if (externalGitUrl != null) {
                state.setUrl(externalGitUrl);
            } else {
                String fabricRepoUrl = "${zk:" + runtimeIdentity + "/http}/git/fabric/";
                state.setUrl(fabricRepoUrl);
            }
        }
        return state;
    }

    private void zkCleanUp(Group<GitNode> group) {
        try {
            RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
            String runtimeIdentity = sysprops.getRuntimeIdentity();
            ((CuratorFramework)this.curator.get()).newNamespaceAwareEnsurePath(ZkPath.GIT.getPath(new String[0])).ensure(((CuratorFramework)this.curator.get()).getZookeeperClient());
            List allChildren = ZooKeeperUtils.getAllChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.GIT.getPath(new String[0]));
            for (String path : allChildren) {
                String stringData = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path);
                if (!stringData.contains("\"container\":\"" + runtimeIdentity + "\"")) continue;
                LOGGER.info("Found older ZK \"/fabric/registry/clusters/git\" entry for node " + runtimeIdentity);
                ZooKeeperUtils.delete((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path);
                LOGGER.info("Older ZK \"/fabric/registry/clusters/git\" entry for node " + runtimeIdentity + " has been removed");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to remove git server from registry.", (Throwable)e);
        }
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindGitDataStore(GitDataStore service) {
        this.gitDataStore.bind((Object)service);
    }

    void unbindGitDataStore(GitDataStore service) {
        this.gitDataStore.unbind((Object)service);
    }

    void bindHttpService(HttpService service) {
        this.httpService.bind((Object)service);
    }

    void unbindHttpService(HttpService service) {
        this.httpService.unbind((Object)service);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    protected void bindFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected void unbindFabricService(FabricService fabricService) {
        if (this.fabricService == fabricService) {
            this.fabricService = null;
        }
    }
}

