/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.http;

import io.fabric8.utils.Base64Encoder;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.curator.framework.CuratorFramework;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitSecureHttpContext
implements HttpContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitSecureHttpContext.class);
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    private final HttpContext base;
    private final CuratorFramework curator;
    private final String realm;
    private final String role;

    public GitSecureHttpContext(HttpContext base, CuratorFramework curator, String realm, String role) {
        this.base = base;
        this.curator = curator;
        this.realm = realm;
        this.role = role;
    }

    public URL getResource(String name) {
        return this.base.getResource(name);
    }

    public String getMimeType(String name) {
        return this.base.getMimeType(name);
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) {
        String authHeader;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("handleSecurity: request={}", (Object)request);
        }
        if ((authHeader = request.getHeader(HEADER_AUTHORIZATION)) != null && authHeader.length() > 0) {
            int blank;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("handleSecurity: Header[Authorization={}]", (Object)authHeader);
            }
            if ((blank = (authHeader = authHeader.trim()).indexOf(32)) > 0) {
                String authType = authHeader.substring(0, blank);
                String authInfo = authHeader.substring(blank).trim();
                if (authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
                    try {
                        String srcString = GitSecureHttpContext.base64Decode(authInfo);
                        int i = srcString.indexOf(58);
                        String username = srcString.substring(0, i);
                        String password = srcString.substring(i + 1);
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("handleSecurity: Username={}", (Object)username);
                        }
                        if (ZooKeeperUtils.isContainerLogin((String)username)) {
                            Properties containers = ZooKeeperUtils.getContainerTokens((CuratorFramework)this.curator);
                            String token = containers.getProperty(username);
                            if (token == null) {
                                throw new FailedLoginException("Container doesn't exist");
                            }
                            if (!password.equals(token)) {
                                throw new FailedLoginException("Tokens do not match");
                            }
                            request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
                            request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
                            return true;
                        }
                        Subject subject = this.doAuthenticate(username, password);
                        if (subject != null) {
                            request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
                            request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + this.realm + "\"");
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private Subject doAuthenticate(final String username, final String password) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] instanceof NameCallback) {
                            ((NameCallback)callbacks[i]).setName(username);
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            ((PasswordCallback)callbacks[i]).setPassword(password.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callbacks[i]);
                    }
                }
            });
            loginContext.login();
            if (this.role != null && this.role.length() > 0) {
                boolean found = false;
                for (Principal p : subject.getPrincipals()) {
                    if (!this.role.equals(p.getName()) && (!(p instanceof Group) || !this.isGroupMember((Group)p, this.role))) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new FailedLoginException("User does not have the required role: " + this.role);
                }
            }
            return subject;
        }
        catch (AccountException e) {
            LOGGER.debug("Account failure", (Throwable)e);
            return null;
        }
        catch (LoginException e) {
            LOGGER.debug("Login failed", (Throwable)e);
            return null;
        }
    }

    private boolean isGroupMember(Group group, String member) {
        Enumeration members = group.members();
        while (members.hasMoreElements()) {
            Principal m = (Principal)members.nextElement();
            if (!member.equals(m.getName())) continue;
            return true;
        }
        return false;
    }

    private static String base64Decode(String srcString) {
        byte[] transformed = new byte[]{};
        try {
            transformed = Base64Encoder.decode(srcString.getBytes("ISO-8859-1"));
            return new String(transformed, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            return new String(transformed);
        }
    }
}

