/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.core.jmx;

import io.fabric8.api.jmx.ZkContents;
import io.fabric8.api.jmx.ZooKeeperFacadeMXBean;
import io.fabric8.common.util.ShutdownTracker;
import io.fabric8.internal.Objects;
import io.fabric8.service.FabricServiceImpl;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperFacade
implements ZooKeeperFacadeMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(ZooKeeperFacade.class);
    private final FabricServiceImpl fabricService;
    private ObjectName objectName;

    public ZooKeeperFacade(FabricServiceImpl fabricService) {
        this.fabricService = fabricService;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this.objectName == null) {
            this.objectName = new ObjectName("io.fabric8:type=ZooKeeper");
        }
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void registerMBeanServer(ShutdownTracker shutdownTracker, MBeanServer mbeanServer) {
        try {
            ObjectName name = this.getObjectName();
            if (!mbeanServer.isRegistered(name)) {
                StandardMBean mbean = new StandardMBean(this, ZooKeeperFacadeMXBean.class);
                mbeanServer.registerMBean(mbean, name);
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                ObjectName name = this.getObjectName();
                if (mbeanServer.isRegistered(name)) {
                    mbeanServer.unregisterMBean(name);
                }
            }
            catch (Exception e) {
                LOG.warn("An error occurred during mbean server registration: " + e, (Throwable)e);
            }
        }
    }

    protected FabricServiceImpl getFabricService() {
        return this.fabricService;
    }

    protected CuratorFramework getCurator() {
        CuratorFramework curator = this.fabricService.adapt(CuratorFramework.class);
        Objects.notNull(curator, "curator");
        return curator;
    }

    public ZkContents read(String path) throws Exception {
        return this.read(path, true);
    }

    public ZkContents read(String path, boolean escape) throws Exception {
        CuratorFramework curator = this.getCurator();
        Stat exists = ZooKeeperUtils.exists((CuratorFramework)curator, (String)path);
        if (exists == null) {
            return null;
        }
        int numChildren = exists.getNumChildren();
        int dataLength = exists.getDataLength();
        List children = null;
        String data = null;
        if (numChildren > 0) {
            children = ZooKeeperUtils.getChildren((CuratorFramework)curator, (String)path);
        } else {
            data = this.getContents(path, escape);
        }
        return new ZkContents(dataLength, children, data);
    }

    public String getContents(String path) throws Exception {
        return this.getContents(path, true);
    }

    public String getContents(String path, boolean escape) throws Exception {
        CuratorFramework curator = this.getCurator();
        String answer = ZooKeeperUtils.getStringData((CuratorFramework)curator, (String)path);
        if (answer != null) {
            return ZooKeeperUtils.getSubstitutedData((CuratorFramework)curator, (String)answer);
        }
        return answer;
    }
}

