/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.EncryptingPersistenceManager;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.crypt", label="Fabric8 Encrypted Property Placeholder Resolver", metatype=false)
@Service(value={PlaceholderResolver.class, EncryptedPropertyResolver.class})
@Properties(value={@Property(name="scheme", value={"crypt"})})
public final class EncryptedPropertyResolver
extends AbstractComponent
implements PlaceholderResolver {
    public static Logger LOG = LoggerFactory.getLogger(EncryptedPropertyResolver.class);
    public static final String RESOLVER_SCHEME = "crypt";
    private BundleContext bundleContext;
    private PBEStringEncryptor encryptor;
    private ServiceRegistration<PBEStringEncryptor> seRegistration;
    private PersistenceManager encryptingPersistenceManager;
    private PersistenceManager originalPersistenceManager;
    @Reference
    private ConfigurationAdmin configAdmin;

    @Activate
    void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        if (this.originalPersistenceManager != null) {
            this.inject(this.configAdmin, this.originalPersistenceManager);
        }
        if (this.seRegistration != null) {
            this.seRegistration.unregister();
        }
        this.encryptor = null;
    }

    public void initialize(FabricService fabricService) {
        this.encryptor = this.getEncryptor(fabricService);
        if (this.bundleContext != null) {
            this.seRegistration = this.bundleContext.registerService(PBEStringEncryptor.class, (Object)this.encryptor, null);
            BundleContext context = FrameworkUtil.getBundle(PersistenceManager.class).getBundleContext();
            this.encryptingPersistenceManager = new EncryptingPersistenceManager(context, context.getProperty("felix.cm.dir"), this.encryptor);
            this.originalPersistenceManager = this.inject(this.configAdmin, this.encryptingPersistenceManager);
        }
    }

    private PersistenceManager inject(ConfigurationAdmin configAdmin, PersistenceManager pm) {
        try {
            Field configurationManager = configAdmin.getClass().getDeclaredField("configurationManager");
            configurationManager.setAccessible(true);
            Object configurationManagerValue = configurationManager.get(configAdmin);
            Field persistenceManagers = configurationManagerValue.getClass().getDeclaredField("persistenceManagers");
            persistenceManagers.setAccessible(true);
            Object[] persistenceManagersValue = (Object[])persistenceManagers.get(configurationManagerValue);
            if (persistenceManagersValue != null && persistenceManagersValue.length == 1) {
                Field pmField = persistenceManagersValue[0].getClass().getDeclaredField("pm");
                pmField.setAccessible(true);
                PersistenceManager originalPM = (PersistenceManager)pmField.get(persistenceManagersValue[0]);
                pmField.set(persistenceManagersValue[0], pm);
                return originalPM;
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage());
        }
        return null;
    }

    public String getScheme() {
        return RESOLVER_SCHEME;
    }

    public String resolve(FabricService fabricService, Map<String, Map<String, String>> configs, String pid, String key, String value) {
        if (this.encryptor == null) {
            this.encryptor = this.getEncryptor(fabricService);
        }
        String decrypted = this.encryptor.decrypt(value.substring(RESOLVER_SCHEME.length() + 1));
        if (configs != null) {
            String encryptedValues;
            Map<String, String> pidConfiguration = configs.get(pid);
            if (!pidConfiguration.containsKey("fabric.zookeeper.encrypted.values")) {
                pidConfiguration.put("fabric.zookeeper.encrypted.values", "");
            }
            if (!(encryptedValues = pidConfiguration.get("fabric.zookeeper.encrypted.values")).isEmpty()) {
                encryptedValues = encryptedValues + ", ";
            }
            encryptedValues = encryptedValues + key;
            pidConfiguration.put("fabric.zookeeper.encrypted.values", encryptedValues);
            pidConfiguration.put(key + ".encrypted", value);
        }
        return decrypted;
    }

    private PBEStringEncryptor getEncryptor(FabricService fabricService) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setAlgorithm(this.getAlgorithm(fabricService));
        encryptor.setPassword(this.getPassword(fabricService));
        return encryptor;
    }

    private String getAlgorithm(FabricService fabricService) {
        try {
            return ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)fabricService.adapt(CuratorFramework.class)), (String)ZkPath.AUTHENTICATION_CRYPT_ALGORITHM.getPath(new String[0]));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    private String getPassword(FabricService fabricService) {
        try {
            String pw = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)fabricService.adapt(CuratorFramework.class)), (String)ZkPath.AUTHENTICATION_CRYPT_PASSWORD.getPath(new String[0]));
            return PasswordEncoder.decode(pw);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    protected void bindConfigAdmin(ConfigurationAdmin configurationAdmin) {
        this.configAdmin = configurationAdmin;
    }

    protected void unbindConfigAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configAdmin == configurationAdmin) {
            this.configAdmin = null;
        }
    }
}

