/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.felix.cm.file.FilePersistenceManager;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptingPersistenceManager
extends FilePersistenceManager {
    public static Logger LOG = LoggerFactory.getLogger(EncryptingPersistenceManager.class);
    private static final String TMP_EXT = ".tmp";
    private static final String FILE_EXT = ".config";
    private final PBEStringEncryptor encryptor;

    public EncryptingPersistenceManager(BundleContext bundleContext, String location, PBEStringEncryptor encryptor) {
        super(bundleContext, location);
        this.encryptor = encryptor;
    }

    @Override
    public Dictionary load(String pid) throws IOException {
        File cfgFile = this.getFile(pid);
        if (System.getSecurityManager() != null) {
            return this._privilegedLoad(cfgFile);
        }
        return this._load(cfgFile);
    }

    private Dictionary _privilegedLoad(final File cfgFile) throws IOException {
        try {
            Object result = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return EncryptingPersistenceManager.this._load(cfgFile);
                }
            });
            return (Dictionary)result;
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Dictionary _load(File cfgFile) throws IOException {
        EncryptingPersistenceManager encryptingPersistenceManager = this;
        synchronized (encryptingPersistenceManager) {
            Dictionary dictionary;
            block15: {
                FileInputStream ins = null;
                try {
                    ins = new FileInputStream(cfgFile);
                    Dictionary storedProps = ConfigurationHandler.read(ins);
                    if (storedProps.get("fabric.zookeeper.encrypted.values") != null) {
                        String[] encryptedValues;
                        String encryptedValuesList = (String)storedProps.get("fabric.zookeeper.encrypted.values");
                        for (String encryptedValue : encryptedValues = encryptedValuesList.split("\\s*,\\s")) {
                            String value = (String)storedProps.get(encryptedValue);
                            if (value == null || !value.startsWith("crypt:")) continue;
                            storedProps.put(encryptedValue + ".encrypted", value);
                            try {
                                storedProps.put(encryptedValue, this.encryptor.decrypt(value.substring("crypt:".length())));
                            }
                            catch (EncryptionOperationNotPossibleException e) {
                                LOG.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    dictionary = storedProps;
                    if (ins == null) break block15;
                }
                catch (Throwable throwable) {
                    if (ins != null) {
                        try {
                            ((InputStream)ins).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return dictionary;
        }
    }

    @Override
    public void store(String pid, Dictionary props) throws IOException {
        if (System.getSecurityManager() != null) {
            this._privilegedStore(pid, props);
        } else {
            this._store(pid, props);
        }
    }

    private void _privilegedStore(final String pid, final Dictionary props) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    EncryptingPersistenceManager.this._store(pid, props);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _store(String pid, Dictionary props) throws IOException {
        OutputStream out = null;
        File tmpFile = null;
        try {
            File cfgFile = new File(this.getLocation(), this.encodePid(pid) + FILE_EXT);
            Hashtable storedProps = props;
            if (props != null && ((Dictionary)props).get("fabric.zookeeper.encrypted.values") != null) {
                String[] encryptedValues;
                String encryptedValuesList = (String)((Dictionary)props).get("fabric.zookeeper.encrypted.values");
                Hashtable newProps = new Hashtable();
                Enumeration e = ((Dictionary)props).keys();
                while (e.hasMoreElements()) {
                    Object k = e.nextElement();
                    newProps.put(k, ((Dictionary)props).get(k));
                }
                for (String encryptedValue : encryptedValues = encryptedValuesList.split("\\s*,\\s")) {
                    newProps.put(encryptedValue, ((Dictionary)props).get(encryptedValue + ".encrypted"));
                    newProps.remove(encryptedValue + ".encrypted");
                }
                storedProps = newProps;
            }
            File cfgDir = cfgFile.getParentFile();
            cfgDir.mkdirs();
            tmpFile = File.createTempFile(cfgFile.getName(), TMP_EXT, cfgDir);
            out = new FileOutputStream(tmpFile);
            ConfigurationHandler.write(out, storedProps);
            out.close();
            EncryptingPersistenceManager encryptingPersistenceManager = this;
            synchronized (encryptingPersistenceManager) {
                if (cfgFile.exists() && !cfgFile.delete()) {
                    throw new IOException("Cannot remove old file '" + cfgFile + "'; changes in '" + tmpFile + "' cannot be persisted at this time");
                }
                if (!tmpFile.renameTo(cfgFile)) {
                    throw new IOException("Failed to rename configuration file from '" + tmpFile + "' to '" + cfgFile);
                }
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
        }
    }
}

