/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.conflicts;

import io.fabric8.patch.management.conflicts.ChooseUserVersionResolver;
import io.fabric8.patch.management.conflicts.KarafFeaturesPropertiesFileResolver;
import io.fabric8.patch.management.conflicts.PropertiesFileResolver;
import io.fabric8.patch.management.conflicts.Resolver;
import io.fabric8.patch.management.conflicts.UsersPropertiesResolver;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class ConflictResolver {
    private Map<String, Resolver> builtInResolvers = new HashMap<String, Resolver>();

    public ConflictResolver() {
        this.builtInResolvers.put("etc/users.properties", new UsersPropertiesResolver());
        this.builtInResolvers.put("etc/org.apache.karaf.features.cfg", new KarafFeaturesPropertiesFileResolver());
        this.builtInResolvers.put("bin/setenv", new ChooseUserVersionResolver());
        this.builtInResolvers.put("bin/setenv.bat", new ChooseUserVersionResolver());
        PropertiesFileResolver resolver = new PropertiesFileResolver();
        this.builtInResolvers.put("*.properties", resolver);
        this.builtInResolvers.put("*.cfg", resolver);
    }

    public Resolver getResolver(String path) {
        Resolver resolver = this.builtInResolvers.get(path);
        if (resolver == null) {
            String ext = FilenameUtils.getExtension(path);
            resolver = this.builtInResolvers.get("*." + ext);
        }
        return resolver;
    }
}

